/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.weather;

import insane96mcp.iguanatweaksreborn.module.world.weather.Foggy;
import insane96mcp.iguanatweaksreborn.module.world.weather.WeatherSavedData;
import insane96mcp.iguanatweaksreborn.network.message.FoggyEnabledSync;
import insane96mcp.iguanatweaksreborn.network.message.FoggySync;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:world", canBeDisabled=false, description="Thunderstorm Intensity and Foggy Weather. Disable them via gamerules: iguanatweaks:thunderstormIntensity and iguanatweaks:foggyWeather")
public class Weather
extends Feature {
    public static final GameRules.Key<GameRules.BooleanValue> RULE_THUNDERSTORMINTENSITY = GameRules.m_46189_((String)"iguanatweaks:thunderstormIntensity", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_FOGGYWEATHER = GameRules.m_46189_((String)"iguanatweaks:foggyWeather", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)true, (server, booleanValue) -> {
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            FoggyEnabledSync.sync(serverPlayer, booleanValue.m_46223_());
        }
    }));
    @Config(min=1.0, name="Thunderstorm Intensity.Min Intensity", description="Minimum thunderstorm intensity.")
    public static Integer thunderstormIntensityMin = 1;
    @Config(min=1.0, name="Thunderstorm Intensity.Max Intensity", description="Maximum thunderstorm intensity.")
    public static Integer thunderstormIntensityMax = 15;
    @Config(min=1.0, name="Thunderstorm Intensity.Base Duration", description="Base duration of each intensity (in minutes). Lasts less and less the higher the intensity")
    public static Integer thunderstormIntensityBaseDuration = 4;
    @Config(min=1.0, name="Foggy Weather.Min Time", description="Minimum time (in minutes) a foggy weather can last.")
    public static Integer foggyWeatherMinTime = 5;
    @Config(min=1.0, name="Foggy Weather.Max Time", description="Maximum time (in minutes) a foggy weather can last.")
    public static Integer foggyWeatherMaxTime = 30;

    public Weather(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void onSkipNight(int timeSkipped, ServerLevel level) {
        if (!Feature.isEnabled(Weather.class) || !level.m_46469_().m_46207_(GameRules.f_46150_)) {
            return;
        }
        if (level.m_46469_().m_46207_(RULE_FOGGYWEATHER)) {
            Weather.advanceFoggyWeather(level, timeSkipped);
        }
        if (level.m_46469_().m_46207_(RULE_THUNDERSTORMINTENSITY)) {
            Weather.advanceVariableThunderstorm(level, timeSkipped);
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (!this.isEnabled() || event.phase != TickEvent.Phase.START || event.level.m_46472_() != Level.f_46428_ || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Weather.advanceFoggyWeather(serverLevel, 1);
        Weather.advanceVariableThunderstorm(serverLevel, 1);
    }

    public static void advanceFoggyWeather(ServerLevel level, int ticks) {
        if (!level.m_46469_().m_46207_(RULE_FOGGYWEATHER)) {
            return;
        }
        WeatherSavedData wsd = WeatherSavedData.get(level);
        WeatherSavedData.FoggyData foggyData = wsd.foggyData;
        if (foggyData.targetTime <= 0) {
            foggyData.targetTime = Weather.getNewFoggyTargetTime(level.f_46441_);
        }
        foggyData.timer += ticks;
        while (foggyData.timer >= foggyData.targetTime) {
            if (foggyData.current == foggyData.target) {
                foggyData.target = Foggy.getRandom(level.f_46441_);
                foggyData.timer -= foggyData.targetTime;
                foggyData.targetTime = (int)((float)Weather.getNewFoggyTargetTime(level.f_46441_) * foggyData.current.timerMultiplier);
                level.m_6907_().forEach(player -> FoggySync.sync(player, foggyData));
                continue;
            }
            foggyData.current = foggyData.target;
            foggyData.timer -= foggyData.targetTime;
            foggyData.targetTime = (int)((float)Weather.getNewFoggyTargetTime(level.f_46441_) * foggyData.current.timerMultiplier);
        }
        wsd.m_77762_();
        if (ticks > 1) {
            level.m_6907_().forEach(player -> FoggySync.sync(player, foggyData));
        }
    }

    private static int getNewFoggyTargetTime(RandomSource random) {
        return (int)((random.m_188501_() * (float)(foggyWeatherMaxTime - foggyWeatherMinTime) + (float)foggyWeatherMinTime.intValue()) * 60.0f * 20.0f);
    }

    @SubscribeEvent
    public void onPlayerJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getLevel().m_46472_() != Level.f_46428_ || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        FoggyEnabledSync.sync(player, event.getLevel().m_46469_().m_46207_(RULE_FOGGYWEATHER));
        FoggySync.sync(player, WeatherSavedData.get((ServerLevel)player.m_284548_()).foggyData);
    }

    public static void setFoggyWeather(ServerLevel level, Foggy foggy) {
        WeatherSavedData wsd = WeatherSavedData.get(level);
        WeatherSavedData.FoggyData foggyData = wsd.foggyData;
        foggyData.current = foggy;
        foggyData.target = foggy;
        foggyData.timer = 0;
        foggyData.targetTime = Weather.getNewFoggyTargetTime(level.f_46441_);
        foggyData.targetTime = (int)((float)foggyData.targetTime * foggy.timerMultiplier);
        wsd.m_77762_();
        level.m_6907_().forEach(player -> FoggySync.sync(player, foggyData));
    }

    public static void nextFoggyWeather(ServerLevel level) {
        WeatherSavedData wsd = WeatherSavedData.get(level);
        WeatherSavedData.FoggyData foggyData = wsd.foggyData;
        if (foggyData.current == foggyData.target) {
            foggyData.target = Foggy.getRandom(level.f_46441_);
            foggyData.timer = 0;
            foggyData.targetTime = Weather.getNewFoggyTargetTime(level.f_46441_);
            level.m_6907_().forEach(player -> FoggySync.sync(player, foggyData));
        } else {
            foggyData.current = foggyData.target;
            foggyData.timer = 0;
            foggyData.targetTime = Weather.getNewFoggyTargetTime(level.f_46441_);
            foggyData.targetTime = (int)((float)foggyData.targetTime * foggyData.current.timerMultiplier);
        }
        wsd.m_77762_();
        level.m_6907_().forEach(player -> FoggySync.sync(player, foggyData));
    }

    public static WeatherSavedData.FoggyData getCurrentFoggyData(ServerLevel level) {
        return WeatherSavedData.get((ServerLevel)level).foggyData;
    }

    public static void advanceVariableThunderstorm(ServerLevel level, int ticks) {
        if (!level.m_46469_().m_46207_(RULE_THUNDERSTORMINTENSITY)) {
            return;
        }
        WeatherSavedData wsd = WeatherSavedData.get(level);
        WeatherSavedData.ThunderIntensityData tid = wsd.thunderIntensityData;
        if (tid.targetIntensity <= 0) {
            tid.targetIntensity = Weather.getNewTargetIntensity(level.f_46441_);
        }
        tid.timer -= ticks;
        while (tid.timer <= 0) {
            tid.timer += (int)((float)(thunderstormIntensityBaseDuration * 60 * 20) + level.f_46441_.m_188501_() * (float)(thunderstormIntensityBaseDuration * 60 * 20)) / tid.getIntensity();
            int delta = tid.targetIntensity > tid.getIntensity() ? 1 : -1;
            tid.addIntensity(delta);
            if (tid.getIntensity() != tid.targetIntensity) continue;
            tid.targetIntensity = Weather.getNewTargetIntensity(level.f_46441_);
        }
        wsd.m_77762_();
    }

    private static int getNewTargetIntensity(RandomSource random) {
        return random.m_216339_(thunderstormIntensityMin.intValue(), thunderstormIntensityMax + 1);
    }

    public static int getLightningStrikeChance(ServerLevel level, int original) {
        if (!Feature.isEnabled(Weather.class) || !level.m_46469_().m_46207_(RULE_THUNDERSTORMINTENSITY)) {
            return original;
        }
        return original / WeatherSavedData.get((ServerLevel)level).thunderIntensityData.getIntensity();
    }

    public static WeatherSavedData.ThunderIntensityData getCurrentThunderIntensityData(ServerLevel level) {
        return WeatherSavedData.get((ServerLevel)level).thunderIntensityData;
    }
}

