/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.weather;

import insane96mcp.iguanatweaksreborn.module.world.weather.Foggy;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class WeatherSavedData
extends SavedData {
    public FoggyData foggyData = new FoggyData(0, -1, Foggy.NONE, Foggy.NONE);
    public ThunderIntensityData thunderIntensityData = new ThunderIntensityData(0, -1, 5);

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        CompoundTag foggyDataTag = new CompoundTag();
        this.foggyData.save(foggyDataTag);
        compoundTag.m_128365_("foggy_data", (Tag)foggyDataTag);
        CompoundTag thunderIntensityDataTag = new CompoundTag();
        this.thunderIntensityData.save(thunderIntensityDataTag);
        compoundTag.m_128365_("thunder_intensity_data", (Tag)thunderIntensityDataTag);
        return compoundTag;
    }

    public static WeatherSavedData load(CompoundTag compoundTag) {
        WeatherSavedData weatherSavedData = new WeatherSavedData();
        weatherSavedData.foggyData.load(compoundTag.m_128469_("foggy_data"));
        weatherSavedData.thunderIntensityData.load(compoundTag.m_128469_("thunder_intensity_data"));
        return weatherSavedData;
    }

    public static WeatherSavedData get(ServerLevel level) {
        return (WeatherSavedData)level.m_8895_().m_164861_(WeatherSavedData::load, WeatherSavedData::new, "iguanatweaksreborn_weather");
    }

    public static final class FoggyData {
        public int timer;
        public int targetTime;
        public Foggy current;
        public Foggy target;

        public FoggyData(int timer, int targetTime, Foggy current, Foggy target) {
            this.timer = timer;
            this.targetTime = targetTime;
            this.current = current;
            this.target = target;
        }

        public void save(CompoundTag compoundTag) {
            compoundTag.m_128405_("timer", this.timer);
            compoundTag.m_128405_("targetTime", this.targetTime);
            compoundTag.m_128405_("current", this.current.ordinal());
            compoundTag.m_128405_("target", this.target.ordinal());
        }

        public void load(CompoundTag compoundTag) {
            if (compoundTag == null) {
                return;
            }
            this.timer = compoundTag.m_128451_("timer");
            this.targetTime = compoundTag.m_128451_("targetTime");
            this.current = Foggy.values()[compoundTag.m_128451_("current")];
            this.target = Foggy.values()[compoundTag.m_128451_("target")];
        }

        public String toString() {
            return "FoggyData{timer=" + this.timer + ", targetTime=" + this.targetTime + ", current=" + String.valueOf((Object)this.current) + ", target=" + String.valueOf((Object)this.target) + "}";
        }

        public float getRatioToTarget() {
            return (float)this.timer / (float)this.targetTime;
        }
    }

    public static final class ThunderIntensityData {
        public int timer;
        public int targetIntensity;
        private int intensity;

        public ThunderIntensityData(int timer, int targetIntensity, int intensity) {
            this.timer = timer;
            this.targetIntensity = targetIntensity;
            this.intensity = intensity;
        }

        public void save(CompoundTag compoundTag) {
            compoundTag.m_128405_("timer", this.timer);
            compoundTag.m_128405_("targetIntensity", this.targetIntensity);
            compoundTag.m_128405_("intensity", this.intensity);
            if (this.intensity <= 0) {
                this.intensity = 1;
            }
        }

        public void load(CompoundTag compoundTag) {
            if (compoundTag == null) {
                return;
            }
            this.timer = compoundTag.m_128451_("timer");
            this.targetIntensity = compoundTag.m_128451_("targetIntensity");
            this.intensity = compoundTag.m_128451_("intensity");
        }

        public int getIntensity() {
            return this.intensity <= 0 ? 1 : this.intensity;
        }

        public void addIntensity(int amount) {
            this.intensity += amount;
        }

        public String toString() {
            return "ThunderIntensityData{timer=" + this.timer + ", targetIntensity=" + this.targetIntensity + ", intensity=" + this.intensity + "}";
        }
    }
}

