/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.network.message;

import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinition;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinitionReloadListener;
import insane96mcp.iguanatweaksreborn.network.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BlockDefinitionSync {
    int count;
    List<BlockDefinition> blockDefinitionList;

    public BlockDefinitionSync(List<BlockDefinition> blockDefinitionList) {
        this.blockDefinitionList = blockDefinitionList;
        this.count = blockDefinitionList.size();
    }

    public static void encode(BlockDefinitionSync pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.count);
        for (BlockDefinition anvilRepair : pkt.blockDefinitionList) {
            anvilRepair.toNetwork(buf);
        }
    }

    public static BlockDefinitionSync decode(FriendlyByteBuf buf) {
        int count = buf.readInt();
        ArrayList<BlockDefinition> list = new ArrayList<BlockDefinition>(count);
        for (int i = 0; i < count; ++i) {
            list.add(BlockDefinition.fromNetwork(buf));
        }
        return new BlockDefinitionSync(list);
    }

    public static void handle(BlockDefinitionSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockDefinitionReloadListener.restoreOriginalDefinitionsAndClear();
            BlockDefinitionReloadListener.DEFINITIONS.clear();
            BlockDefinitionReloadListener.DEFINITIONS.addAll(message.blockDefinitionList);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sync(List<BlockDefinition> definitions, ServerPlayer player) {
        BlockDefinitionSync msg = new BlockDefinitionSync(definitions);
        NetworkHandler.CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

