/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.network.message;

import insane96mcp.iguanatweaksreborn.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ForgeDataIntSync {
    final int entityId;
    final String tag;
    final int value;

    public ForgeDataIntSync(int entityId, String tag, int value) {
        this.entityId = entityId;
        this.tag = tag;
        this.value = value;
    }

    public static void encode(ForgeDataIntSync pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.entityId);
        buf.m_130070_(pkt.tag);
        buf.writeInt(pkt.value);
    }

    public static ForgeDataIntSync decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        String tag = buf.m_130277_();
        int data = buf.readInt();
        return new ForgeDataIntSync(entityId, tag, data);
    }

    public static void handle(ForgeDataIntSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getPersistentData().m_128405_(message.tag, message.value);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sync(LivingEntity entity, String tag, int value) {
        ForgeDataIntSync msg = new ForgeDataIntSync(entity.m_19879_(), tag, value);
        ((ServerLevel)entity.m_9236_()).m_6907_().forEach(player -> NetworkHandler.CHANNEL.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sync(ServerPlayer player, LivingEntity entity, String tag, int value) {
        ForgeDataIntSync msg = new ForgeDataIntSync(entity.m_19879_(), tag, value);
        NetworkHandler.CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

