/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.Livestock;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class LivestockAgeCondition
implements LootItemCondition {
    final LootContext.EntityTarget entityTarget;
    final Livestock.Age age;

    LivestockAgeCondition(LootContext.EntityTarget entityTarget, Livestock.Age age) {
        this.entityTarget = entityTarget;
        this.age = age;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ISORegistries.LIVESTOCK_AGE_CONDITION.get();
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)this.entityTarget.m_79003_());
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.m_78953_(this.entityTarget.m_79003_());
        if (!(entity instanceof AgeableMob)) {
            return false;
        }
        AgeableMob mob = (AgeableMob)entity;
        return Livestock.getAge(mob) == this.age;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LivestockAgeCondition> {
        @NotNull
        public LivestockAgeCondition deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            return new LivestockAgeCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class), (Livestock.Age)((Object)context.deserialize(jsonObject.get("age"), Livestock.Age.class)));
        }

        public void serialize(JsonObject jsonObject, LivestockAgeCondition livestockAgeCondition, JsonSerializationContext context) {
            jsonObject.add("entity", context.serialize((Object)livestockAgeCondition.entityTarget));
            jsonObject.add("age", context.serialize((Object)livestockAgeCondition.age));
        }
    }
}

