/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.criterion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import insane96mcp.iguanatweaksreborn.data.criterion.ISOTriggers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;

public class SeasonChangedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("iguanatweaksreborn", "season_changed");

    protected TriggerInstance createInstance(JsonObject jsonObject, ContextAwarePredicate pPredicate, DeserializationContext context) {
        ArrayList<Season.SubSeason> seasons = new ArrayList<Season.SubSeason>();
        if (jsonObject.has("seasons")) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"seasons");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                if (!jsonElement.isJsonPrimitive()) continue;
                seasons.add(Season.SubSeason.valueOf((String)jsonElement.getAsString()));
            }
        }
        return new TriggerInstance(pPredicate, seasons);
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, Season.SubSeason season) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(season));
    }

    public static void onSeasonChanged(SeasonChangedEvent.Standard event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_6907_().forEach(serverPlayer -> ISOTriggers.SEASON_CHANGED.trigger((ServerPlayer)serverPlayer, (Season.SubSeason)event.getNewSeason()));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        public List<Season.SubSeason> seasons;

        public TriggerInstance(ContextAwarePredicate pPredicate, List<Season.SubSeason> seasons) {
            super(ID, pPredicate);
            this.seasons = seasons;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            JsonArray jsonArray = new JsonArray();
            for (Season.SubSeason season : this.seasons) {
                jsonArray.add(season.toString());
            }
            jsonObject.add("seasons", (JsonElement)jsonArray);
            return jsonObject;
        }

        public boolean matches(Season.SubSeason season) {
            return this.seasons.contains(season);
        }
    }
}

