/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantWithTreasureFunction
extends LootItemConditionalFunction {
    final boolean allowCurses;
    final boolean allowTreasure;

    protected EnchantWithTreasureFunction(LootItemCondition[] pPredicates, boolean allowCurses, boolean allowTreasure) {
        super(pPredicates);
        this.allowCurses = allowCurses;
        this.allowTreasure = allowTreasure;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        RandomSource random = context.m_230907_();
        boolean isBook = stack.m_150930_(Items.f_42517_) || stack.m_150930_(Items.f_42690_);
        List<Enchantment> list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(ench -> !(!isBook && !ench.m_6081_(stack) || !ench.m_6592_() || !ench.m_6591_() || ench.m_6589_() && !this.allowCurses || !ench.m_6589_() && !this.allowTreasure)).toList();
        if (list.isEmpty()) {
            ISOLogHelper.warn("Couldn't find a compatible treasure enchantment for {}", stack);
            return stack;
        }
        Enchantment enchantment = list.get(random.m_188503_(list.size()));
        return EnchantWithTreasureFunction.enchantItem(stack, enchantment, random);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ISORegistries.ENCHANT_WITH_TREASURE.get();
    }

    private static ItemStack enchantItem(ItemStack pStack, Enchantment pEnchantment, RandomSource pRandom) {
        int i = Mth.m_216271_((RandomSource)pRandom, (int)pEnchantment.m_44702_(), (int)pEnchantment.m_6586_());
        if (pStack.m_150930_(Items.f_42517_)) {
            pStack = new ItemStack((ItemLike)Items.f_42690_);
            EnchantedBookItem.m_41153_((ItemStack)pStack, (EnchantmentInstance)new EnchantmentInstance(pEnchantment, i));
        } else if (pStack.m_150930_(Items.f_42690_)) {
            EnchantedBookItem.m_41153_((ItemStack)pStack, (EnchantmentInstance)new EnchantmentInstance(pEnchantment, i));
        } else {
            pStack.m_41663_(pEnchantment, i);
        }
        return pStack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<EnchantWithTreasureFunction> {
        public void serialize(JsonObject pJson, EnchantWithTreasureFunction pValue, JsonSerializationContext pSerializationContext) {
            pJson.addProperty("allow_curses", Boolean.valueOf(pValue.allowCurses));
            pJson.addProperty("allow_treasure", Boolean.valueOf(pValue.allowTreasure));
            super.m_6170_(pJson, (LootItemConditionalFunction)pValue, pSerializationContext);
        }

        public EnchantWithTreasureFunction deserialize(JsonObject pObject, JsonDeserializationContext pDeserializationContext, LootItemCondition[] pConditions) {
            boolean allowCurses = GsonHelper.m_13855_((JsonObject)pObject, (String)"allow_curses", (boolean)true);
            boolean allowTreasure = GsonHelper.m_13855_((JsonObject)pObject, (String)"allow_treasure", (boolean)true);
            return new EnchantWithTreasureFunction(pConditions, allowCurses, allowTreasure);
        }
    }
}

