/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.lootmodifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;

public class DisenchantModifier
extends LootModifier {
    public static final Supplier<Codec<DisenchantModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DisenchantModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).optionalFieldOf("blacklisted_items_tag").forGetter(m -> m.blacklistedItemsTag)).apply((Applicative)inst, DisenchantModifier::new)));
    private Optional<TagKey<Item>> blacklistedItemsTag;

    public DisenchantModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public DisenchantModifier(LootItemCondition[] conditionsIn, Optional<TagKey<Item>> blacklistedItemsTag) {
        super(conditionsIn);
        this.blacklistedItemsTag = blacklistedItemsTag;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ArrayList toRemove = new ArrayList();
        generatedLoot.forEach(itemStack -> {
            if (this.blacklistedItemsTag.isPresent() && itemStack.m_204117_(this.blacklistedItemsTag.get())) {
                return;
            }
            if (!itemStack.m_150930_(Items.f_42690_)) {
                itemStack.m_41749_("Enchantments");
            } else {
                toRemove.add(itemStack);
            }
        });
        toRemove.forEach(stack -> {
            generatedLoot.remove(stack);
            generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42517_));
        });
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static class Builder {
        final DisenchantModifier disenchantModifier;

        public Builder(LootItemCondition[] conditionsIn) {
            this.disenchantModifier = new DisenchantModifier(conditionsIn);
        }

        public Builder(ResourceLocation lootTable) {
            this(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)lootTable).m_6409_()});
        }

        public DisenchantModifier build() {
            return this.disenchantModifier;
        }
    }
}

