/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.lootmodifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import insane96mcp.insanelib.util.MathHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DropMultiplierModifier
extends LootModifier {
    public static final Supplier<Codec<DropMultiplierModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DropMultiplierModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("item").forGetter(m -> m.item), (App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).optionalFieldOf("tag").forGetter(m -> m.tag), (App)Codec.floatRange((float)0.0f, (float)1024.0f).fieldOf("multiplier").forGetter(m -> Float.valueOf(m.multiplier)), (App)Codec.intRange((int)0, (int)256).optionalFieldOf("amount_to_keep", (Object)0).forGetter(m -> m.amountToKeep), (App)Codec.BOOL.optionalFieldOf("ignore_unstackable", (Object)true).forGetter(m -> m.ignoreUnstackable))).apply((Applicative)inst, DropMultiplierModifier::new)));
    private Optional<Item> item;
    private Optional<TagKey<Item>> tag;
    private final float multiplier;
    private int amountToKeep;
    private boolean ignoreUnstackable;

    public DropMultiplierModifier(LootItemCondition[] conditionsIn, Optional<Item> item, Optional<TagKey<Item>> tag, float multiplier, int amountToKeep, boolean ignoreUnstackable) {
        super(conditionsIn);
        this.item = item;
        this.tag = tag;
        this.multiplier = multiplier;
        this.amountToKeep = amountToKeep;
        this.ignoreUnstackable = ignoreUnstackable;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.multiplier == 1.0f) {
            return generatedLoot;
        }
        Predicate<ItemStack> MATCHES_ITEM_OR_TAG = stack -> {
            if (this.item.isPresent()) {
                return stack.m_150930_(this.item.get());
            }
            if (this.tag.isPresent()) {
                return stack.m_204117_(this.tag.get());
            }
            return true;
        };
        List<ItemStack> filteredStacks = generatedLoot.stream().filter(MATCHES_ITEM_OR_TAG).toList();
        if (filteredStacks.isEmpty()) {
            return generatedLoot;
        }
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (ItemStack stack2 : filteredStacks) {
            if (!stack2.m_41753_() && this.ignoreUnstackable) continue;
            ItemStack existingStack = null;
            for (ItemStack newStack : newStacks) {
                if (!ItemStack.m_150942_((ItemStack)stack2, (ItemStack)newStack)) continue;
                existingStack = newStack;
            }
            if (existingStack == null) {
                existingStack = stack2.m_41777_();
                newStacks.add(existingStack);
                continue;
            }
            existingStack.m_41764_(existingStack.m_41613_() + stack2.m_41613_());
        }
        generatedLoot.removeIf(MATCHES_ITEM_OR_TAG);
        for (ItemStack newStack : newStacks) {
            int count = MathHelper.getAmountWithDecimalChance((RandomSource)context.m_230907_(), (float)((float)(newStack.m_41613_() - this.amountToKeep) * this.multiplier)) + this.amountToKeep;
            if (count <= 0) continue;
            newStack.m_41764_(count);
            generatedLoot.add((Object)newStack);
        }
        return generatedLoot;
    }

    public static DropMultiplierModifier newItem(LootItemCondition[] conditionsIn, Optional<Item> item, float multiplier) {
        return new DropMultiplierModifier(conditionsIn, item, Optional.empty(), multiplier, 0, true);
    }

    public static DropMultiplierModifier newTag(LootItemCondition[] conditionsIn, Optional<TagKey<Item>> tag, float multiplier) {
        return new DropMultiplierModifier(conditionsIn, Optional.empty(), tag, multiplier, 0, true);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static class Builder {
        final DropMultiplierModifier dropMultiplierModifier;

        public Builder(LootItemCondition[] conditionsIn, Item item, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newItem(conditionsIn, Optional.of(item), multiplier);
        }

        public Builder(LootItemCondition[] conditionsIn, TagKey<Item> tag, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newTag(conditionsIn, Optional.of(tag), multiplier);
        }

        public Builder(Item item, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newItem(new LootItemCondition[0], Optional.of(item), multiplier);
        }

        public Builder(TagKey<Item> tag, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newTag(new LootItemCondition[0], Optional.of(tag), multiplier);
        }

        public Builder(EntityType<?> entityType, Item item, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newItem(new LootItemCondition[]{LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)new EntityPredicate.Builder().m_36646_(EntityTypePredicate.m_37647_(entityType)).m_36662_()).m_6409_()}, Optional.of(item), multiplier);
        }

        public Builder(EntityType<?> entityType, TagKey<Item> tag, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newTag(new LootItemCondition[]{LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)new EntityPredicate.Builder().m_36646_(EntityTypePredicate.m_37647_(entityType)).m_36662_()).m_6409_()}, Optional.of(tag), multiplier);
        }

        public Builder(Block block, Item item, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newItem(new LootItemCondition[]{new LootItemBlockStatePropertyCondition.Builder(block).m_6409_()}, Optional.of(item), multiplier);
        }

        public Builder(Block block, TagKey<Item> tag, float multiplier) {
            this.dropMultiplierModifier = DropMultiplierModifier.newTag(new LootItemCondition[]{new LootItemBlockStatePropertyCondition.Builder(block).m_6409_()}, Optional.of(tag), multiplier);
        }

        public Builder keepAmount(int amount) {
            this.dropMultiplierModifier.amountToKeep = amount;
            return this;
        }

        public Builder ignoreUnstackable(boolean ignoreUnstackable) {
            this.dropMultiplierModifier.ignoreUnstackable = ignoreUnstackable;
            return this;
        }

        public DropMultiplierModifier build() {
            return this.dropMultiplierModifier;
        }
    }
}

