/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.lootmodifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;

public class LootPurgerModifier
extends LootModifier {
    public static final Supplier<Codec<LootPurgerModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootPurgerModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.INT.optionalFieldOf("start_range", (Object)0).forGetter(m -> m.startRange), (App)Codec.INT.fieldOf("end_range").forGetter(m -> m.endRange), (App)Codec.FLOAT.optionalFieldOf("multiplier_at_start", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.multiplierAtStart)), (App)Codec.BOOL.optionalFieldOf("apply_to_damageable", (Object)false).forGetter(m -> m.applyToDamageable), (App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).optionalFieldOf("blacklisted_items_tag").forGetter(m -> m.blacklistedItemsTag), (App)TagKey.m_203877_((ResourceKey)Registries.f_256939_).optionalFieldOf("blacklisted_entity_type_tag").forGetter(m -> m.blacklistedEntityTypeTag))).apply((Applicative)inst, LootPurgerModifier::new)));
    private int startRange = 0;
    private int endRange;
    private float multiplierAtStart = 0.0f;
    private boolean applyToDamageable = false;
    private Optional<TagKey<Item>> blacklistedItemsTag;
    private Optional<TagKey<EntityType<?>>> blacklistedEntityTypeTag;

    public LootPurgerModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public LootPurgerModifier(LootItemCondition[] conditionsIn, int startRange, int endRange, float multiplierAtStart, boolean applyToDamageable, Optional<TagKey<Item>> blacklistedItemsTag, Optional<TagKey<EntityType<?>>> blacklistedEntityTypeTag) {
        super(conditionsIn);
        this.startRange = startRange;
        this.endRange = endRange;
        this.multiplierAtStart = multiplierAtStart;
        this.applyToDamageable = applyToDamageable;
        this.blacklistedItemsTag = blacklistedItemsTag;
        this.blacklistedEntityTypeTag = blacklistedEntityTypeTag;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int spawnZ;
        int z;
        if (context.m_78953_(LootContextParams.f_81460_) == null) {
            return generatedLoot;
        }
        if (context.m_78953_(LootContextParams.f_81455_) != null && this.blacklistedEntityTypeTag.isPresent() && ((Entity)context.m_165124_(LootContextParams.f_81455_)).m_6095_().m_204039_(this.blacklistedEntityTypeTag.get())) {
            return generatedLoot;
        }
        int x = (int)((Vec3)context.m_165124_((LootContextParam)LootContextParams.f_81460_)).f_82479_;
        int spawnX = context.m_78952_().m_6106_().m_6789_();
        int distanceFromSpawn = (int)Math.sqrt((x - spawnX) * (x - spawnX) + ((z = (int)((Vec3)context.m_165124_((LootContextParam)LootContextParams.f_81460_)).f_82481_) - (spawnZ = context.m_78952_().m_6106_().m_6526_())) * (z - spawnZ));
        int distanceFromStart = distanceFromSpawn - this.startRange;
        float multiplier = distanceFromStart <= 0 ? 1.0f - this.multiplierAtStart : (float)(this.endRange - distanceFromStart) / ((float)this.endRange - (float)this.startRange) * (1.0f - this.multiplierAtStart);
        generatedLoot.removeIf(itemStack -> {
            if (this.blacklistedItemsTag.isPresent() && itemStack.m_204117_(this.blacklistedItemsTag.get())) {
                return false;
            }
            return context.m_230907_().m_188500_() < (double)multiplier;
        });
        if (this.applyToDamageable) {
            generatedLoot.forEach(itemStack -> {
                if (itemStack.m_41720_().m_41465_()) {
                    itemStack.m_41721_((int)((float)itemStack.m_41776_() - (float)(itemStack.m_41776_() - itemStack.m_41773_()) * (1.0f - multiplier)));
                }
            });
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static class Builder {
        final LootPurgerModifier lootPurgerModifier;

        public Builder(LootItemCondition[] conditionsIn, int endRange) {
            this.lootPurgerModifier = new LootPurgerModifier(conditionsIn);
            this.lootPurgerModifier.endRange = endRange;
        }

        public Builder(ResourceLocation lootTable, int endRange) {
            this(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)lootTable).m_6409_()}, endRange);
        }

        public Builder setStartRange(int startRange) {
            this.lootPurgerModifier.startRange = startRange;
            return this;
        }

        public Builder setMultiplierAtStart(float multiplierAtStart) {
            this.lootPurgerModifier.multiplierAtStart = multiplierAtStart;
            return this;
        }

        public Builder applyToDamageable() {
            this.lootPurgerModifier.applyToDamageable = true;
            return this;
        }

        public Builder blacklistedItemTag(TagKey<Item> tag) {
            this.lootPurgerModifier.blacklistedItemsTag = Optional.of(tag);
            return this;
        }

        public LootPurgerModifier build() {
            return this.lootPurgerModifier;
        }
    }
}

