/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data.lootmodifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import insane96mcp.insanelib.util.MathHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReplaceLootModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item_to_replace").forGetter(m -> m.itemToReplace), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("new_item").forGetter(m -> m.newItem), (App)Codec.INT.optionalFieldOf("amount_to_replace", (Object)-1).forGetter(m -> m.amountToReplace), (App)Codec.list((Codec)Codec.FLOAT).optionalFieldOf("chances", List.of(Float.valueOf(1.0f))).forGetter(m -> m.chances), (App)Codec.list((Codec)Codec.FLOAT).optionalFieldOf("multipliers", List.of(Float.valueOf(1.0f))).forGetter(m -> m.multipliers), (App)Codec.BOOL.optionalFieldOf("keep_durability", (Object)false).forGetter(m -> m.chestsOnly), (App)Codec.BOOL.optionalFieldOf("chests_only", (Object)false).forGetter(m -> m.chestsOnly))).apply((Applicative)inst, ReplaceLootModifier::new)));
    private final Item itemToReplace;
    private final Item newItem;
    private int amountToReplace;
    private List<Float> chances;
    private List<Float> multipliers;
    private boolean keepDurability;
    private boolean chestsOnly;

    public ReplaceLootModifier(LootItemCondition[] conditionsIn, Item itemToReplace, Item newItem) {
        this(conditionsIn, itemToReplace, newItem, -1, List.of(Float.valueOf(1.0f)), List.of(Float.valueOf(1.0f)), false, false);
    }

    public ReplaceLootModifier(LootItemCondition[] conditionsIn, Item itemToReplace, Item newItem, int amountToReplace, List<Float> chances, List<Float> multipliers, boolean keepDurability, boolean chestsOnly) {
        super(conditionsIn);
        this.itemToReplace = itemToReplace;
        this.newItem = newItem;
        this.amountToReplace = amountToReplace;
        this.chances = chances;
        this.multipliers = multipliers;
        this.keepDurability = keepDurability;
        this.chestsOnly = chestsOnly;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.chestsOnly && !context.getQueriedLootTableId().m_135815_().contains("chests/")) {
            return generatedLoot;
        }
        ArrayList toRemove = new ArrayList();
        ArrayList toAdd = new ArrayList();
        generatedLoot.stream().filter(stack -> stack.m_41720_().equals(this.itemToReplace)).forEach(stack -> {
            ItemStack toolStack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            int fortuneLvl = toolStack != null ? toolStack.getEnchantmentLevel(Enchantments.f_44987_) : 0;
            float chance = this.chances.get(Math.min(fortuneLvl, this.chances.size() - 1)).floatValue();
            if (context.m_230907_().m_188500_() >= (double)chance) {
                return;
            }
            float multiplier = this.multipliers.get(Math.min(fortuneLvl, this.multipliers.size() - 1)).floatValue();
            boolean keepDurability = this.keepDurability && this.itemToReplace.m_41465_() && this.newItem.m_41465_();
            float percentageDurability = 1.0f;
            if (keepDurability) {
                percentageDurability = (float)stack.m_41773_() / (float)stack.m_41776_();
            }
            toRemove.add(stack);
            if (this.amountToReplace == -1) {
                int newAmount = MathHelper.getAmountWithDecimalChance((RandomSource)context.m_230907_(), (float)((float)stack.m_41613_() * multiplier));
                ItemStack newItemStack = new ItemStack((ItemLike)this.newItem, newAmount);
                if (keepDurability) {
                    newItemStack.m_41721_((int)((float)newItemStack.m_41776_() * percentageDurability));
                }
                toAdd.add(newItemStack);
            } else {
                int newAmount = MathHelper.getAmountWithDecimalChance((RandomSource)context.m_230907_(), (float)((float)Math.min(stack.m_41613_(), this.amountToReplace) * multiplier));
                ItemStack replacedStack = new ItemStack((ItemLike)this.newItem, newAmount);
                toAdd.add(replacedStack);
                if (this.amountToReplace < stack.m_41613_()) {
                    ItemStack oldStack = new ItemStack((ItemLike)this.itemToReplace, stack.m_41613_() - this.amountToReplace);
                    toAdd.add(oldStack);
                }
            }
        });
        generatedLoot.removeAll(toRemove);
        generatedLoot.addAll(toAdd);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static class Builder {
        final ReplaceLootModifier replaceLootModifier;

        public Builder(Item itemToReplace, Item newItem) {
            this(new LootItemCondition[0], itemToReplace, newItem);
        }

        public Builder(LootItemCondition[] conditionsIn, Item itemToReplace, Item newItem) {
            this.replaceLootModifier = new ReplaceLootModifier(conditionsIn, itemToReplace, newItem);
        }

        public Builder(EntityType<?> entityType, Item itemToReplace, Item newItem) {
            this.replaceLootModifier = new ReplaceLootModifier(new LootItemCondition[]{LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)new EntityPredicate.Builder().m_36646_(EntityTypePredicate.m_37647_(entityType)).m_36662_()).m_6409_()}, itemToReplace, newItem);
        }

        public Builder setAmountToReplace(int amount) {
            this.replaceLootModifier.amountToReplace = amount;
            return this;
        }

        public Builder setChances(List<Float> chances) {
            this.replaceLootModifier.chances = chances;
            return this;
        }

        public Builder setMultipliers(List<Float> multipliers) {
            this.replaceLootModifier.multipliers = multipliers;
            return this;
        }

        public Builder applyToChestsOnly() {
            this.replaceLootModifier.chestsOnly = true;
            return this;
        }

        public Builder keepDurability() {
            this.replaceLootModifier.keepDurability = true;
            return this;
        }

        public ReplaceLootModifier build() {
            return this.replaceLootModifier;
        }
    }
}

