/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.iguanatweaksreborn.modifier.Modifier;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class BiomeModifier
extends Modifier {
    protected final List<IdTagMatcher> biomes = new ArrayList<IdTagMatcher>();
    protected final boolean inverse;

    protected BiomeModifier(float modifier, Modifier.Operation operation, List<IdTagMatcher> biomes, boolean inverse) {
        super(modifier, operation);
        this.biomes.addAll(biomes);
        this.inverse = inverse;
    }

    @Override
    public boolean shouldApply(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        Holder currentBiome = level.m_204166_(pos);
        for (IdTagMatcher biome : this.biomes) {
            if (!biome.matchesBiome(currentBiome)) continue;
            return !this.inverse;
        }
        return this.inverse;
    }

    public static class Serializer
    implements JsonDeserializer<BiomeModifier> {
        public BiomeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            ArrayList<IdTagMatcher> biomes = new ArrayList<IdTagMatcher>();
            JsonArray aCorrectBiomes = GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"biomes");
            if (aCorrectBiomes.isEmpty()) {
                throw new JsonParseException("biomes list must contain at least one entry");
            }
            for (JsonElement jsonElement : aCorrectBiomes) {
                IdTagMatcher biome = (IdTagMatcher)context.deserialize(jsonElement, IdTagMatcher.class);
                biomes.add(biome);
            }
            return new BiomeModifier(GsonHelper.m_13915_((JsonObject)jObject, (String)"modifier"), (Modifier.Operation)((Object)context.deserialize(jObject.get("operation"), Modifier.Operation.class)), biomes, GsonHelper.m_13855_((JsonObject)jObject, (String)"inverse", (boolean)false));
        }
    }
}

