/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.modifier.Modifiers;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@JsonAdapter(value=Serializer.class)
public class Modifier {
    protected final float modifier;
    protected final Operation operation;

    protected Modifier(float modifier, Operation operation) {
        this.modifier = modifier;
        this.operation = operation;
    }

    public boolean shouldApply(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        return true;
    }

    public float getModifier() {
        return this.modifier;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static List<Modifier> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (!jObject.has(memberName)) {
            return modifiers;
        }
        JsonArray aModifiers = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        for (JsonElement jsonElement : aModifiers) {
            JsonObject jObjectModifier = jsonElement.getAsJsonObject();
            ResourceLocation modifierId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jObjectModifier, (String)"id"));
            Type modifierType = Modifiers.MODIFIERS.get(modifierId);
            if (modifierType == null) {
                InsaneSurvivalOverhaul.LOGGER.warn("modifier %s does not exist. Skipping".formatted(modifierId));
                continue;
            }
            modifiers.add((Modifier)context.deserialize((JsonElement)jObjectModifier, modifierType));
        }
        return modifiers;
    }

    public static float applyModifiers(float originalValue, List<Modifier> modifiers, Level level, BlockPos pos, @Nullable LivingEntity entity) {
        List<Modifier> addModifiers = modifiers.stream().filter(modifier -> modifier.operation == Operation.ADD).toList();
        List<Modifier> multiplyModifiers = modifiers.stream().filter(modifier -> modifier.operation == Operation.MULTIPLY).toList();
        float addedUpValue = originalValue;
        for (Modifier modifier2 : addModifiers) {
            if (!modifier2.shouldApply(level, pos, entity)) continue;
            addedUpValue += modifier2.getModifier();
        }
        float finalValue = addedUpValue;
        for (Modifier modifier3 : multiplyModifiers) {
            if (!modifier3.shouldApply(level, pos, entity)) continue;
            finalValue += addedUpValue * modifier3.getModifier();
        }
        return finalValue;
    }

    public static enum Operation {
        ADD,
        MULTIPLY;

    }

    public static class Serializer
    implements JsonDeserializer<Modifier> {
        public Modifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new Modifier(GsonHelper.m_13915_((JsonObject)jObject, (String)"modifier"), (Operation)((Object)context.deserialize(jObject.get("operation"), Operation.class)));
        }
    }
}

