/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.client;

import insane96mcp.iguanatweaksreborn.module.world.weather.ClientWeather;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Fog", description="Makes fog less invasive in some contexts")
@LoadFeature(module="iguanatweaksreborn:client")
public class Fog
extends Feature {
    @Config
    @Label(name="Better visibility in Lava with Fire Resistance Lava", description="If true you'll be able to see better in lava when with the Fire Resistance Effect.")
    public static Boolean betterFireResistanceLavaFog = true;
    @Config
    @Label(name="Better Nether Fog", description="If true Nether Fog is no longer limited to 12 chunks.")
    public static Boolean betterNetherFog = true;
    @Config(min=0.0, max=1.0)
    @Label(name="Nether Fog Ratio", description="Render distance is multiplied by this value in the Nether. Vanilla is 0.5.")
    public static Double netherFogRatio = 0.75;
    @Config(min=0.0, max=1.0)
    @Label(description="Changes fog to start closer to the player. E.g. A value of 0.5 makes fog start at half the render distance. Vanilla is 1, Pre-1.18.1 was 0.75, Pre-1.7.2 was 0.25. This disables itself if Foggy Weather is enabled.")
    public static Double overworld$fogStartRatio = 0.4;
    @Config(max=1.0)
    @Label(description="Changes fog ratio when raining. Vanilla is 1. This disables itself if Foggy Weather is enabled.")
    public static Double overworld$fogStartRatioOnRain = -0.2;

    public Fog(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFog(ViewportEvent.RenderFog event) {
        if (!this.isEnabled()) {
            return;
        }
        this.lavaFog(event);
        this.netherFog(event);
        this.overworldFog(event);
    }

    private void overworldFog(ViewportEvent.RenderFog event) {
        if (Feature.get(ClientWeather.class).isEnabled() || overworld$fogStartRatio == 1.0 && overworld$fogStartRatioOnRain == 1.0 || event.isCanceled() || event.getCamera().m_167685_() != FogType.NONE || event.getMode() != FogRenderer.FogMode.FOG_TERRAIN) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        float rainLevel = entity2.m_9236_().m_46722_(1.0f);
        float ratio = overworld$fogStartRatio.floatValue();
        if (rainLevel > 0.0f) {
            float skyLight = entity2.m_9236_().m_45517_(LightLayer.SKY, entity2.m_20183_());
            float skyLightRatio = skyLight / 12.0f;
            if (skyLightRatio > 1.0f) {
                skyLightRatio = 1.0f;
            }
            float interpolatedRatio = overworld$fogStartRatio.floatValue() * (1.0f - skyLightRatio) + overworld$fogStartRatioOnRain.floatValue() * skyLightRatio;
            event.setNearPlaneDistance(event.getFarPlaneDistance() * (ratio - rainLevel * (ratio - interpolatedRatio)));
        } else {
            event.setNearPlaneDistance(event.getFarPlaneDistance() * ratio);
        }
        event.setCanceled(true);
    }

    public void lavaFog(ViewportEvent.RenderFog event) {
        LivingEntity livingEntity;
        if (!betterFireResistanceLavaFog.booleanValue() || event.getCamera().m_167685_() != FogType.LAVA || event.getCamera().m_90592_().m_5833_()) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19607_)) {
            event.setNearPlaneDistance(-16.0f);
            event.setFarPlaneDistance(16.0f);
            event.setCanceled(true);
        }
    }

    public void netherFog(ViewportEvent.RenderFog event) {
        if (!betterNetherFog.booleanValue() || event.isCanceled()) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (entity.getEyeInFluidType() == ForgeMod.EMPTY_TYPE.get() && entity.m_9236_().m_46472_() == Level.f_46429_) {
            float renderDistance = Minecraft.m_91087_().f_91063_.m_109152_();
            event.setNearPlaneDistance((float)((double)renderDistance * netherFogRatio / 10.0));
            event.setFarPlaneDistance((float)((double)renderDistance * netherFogRatio));
            event.setCanceled(true);
        }
    }
}

