/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.client.hudinfos;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.client.hudinfos.SereneSeasonsIntegration;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Label(name="HUD Infos", description="Adds various infos on top left of the screen")
@LoadFeature(module="iguanatweaksreborn:client")
public class HudInfos
extends Feature {
    @Config
    @Label(name="Cardinal Direction", description="If true, items in the iguanatweaksreborn:hud/cardinal_direction will display the cardinal direction.")
    public static Boolean cardinalDirection = true;
    @Config
    @Label(name="Season", description="If true, items in the iguanatweaksreborn:hud/season will display the current season. Only available if Serene Seasons is installed")
    public static Boolean season = true;
    @Config
    @Label(name="Depth", description="If true, items in the iguanatweaksreborn:hud/depth will display the current Y level")
    public static Boolean depth = true;
    @Config
    @Label(name="Time", description="If true, items in the iguanatweaksreborn:hud/time will display the time of day")
    public static Boolean time = true;
    @Config
    @Label(name="Biome", description="If true, items in the iguanatweaksreborn:hud/biome will display the current biome")
    public static Boolean biome = true;

    public HudInfos(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onHud(CustomizeGuiOverlayEvent.DebugText event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Minecraft.m_91087_().f_91066_.f_92063_ || player == null) {
            return;
        }
        ArrayList<String> toDraw = new ArrayList<String>();
        this.tryRenderCardinalDirection((Player)player, toDraw);
        this.tryRenderDepth((Player)player, toDraw);
        this.tryRenderBiome((Player)player, toDraw);
        this.tryRenderTime((Player)player, toDraw);
        this.tryRenderSeason((Player)player, toDraw);
        event.getLeft().addAll(toDraw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRenderCardinalDirection(Player player, List<String> toDraw) {
        if (!cardinalDirection.booleanValue() || !this.shouldRender(player, Minecraft.m_91087_().f_91077_, ISOItemTagsProvider.HUD_CARDINAL_DIRECTION)) {
            return;
        }
        this.renderCardinalDirection(player, toDraw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderCardinalDirection(Player player, List<String> toDraw) {
        float direction = Mth.m_14177_((float)player.m_6080_());
        String d = HudInfos.getDirectionTranslatable(direction);
        toDraw.add(Component.m_237115_((String)d).getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRenderDepth(Player player, List<String> toDraw) {
        if (!depth.booleanValue() || !this.shouldRender(player, Minecraft.m_91087_().f_91077_, ISOItemTagsProvider.HUD_DEPTH)) {
            return;
        }
        this.renderDepth(player, toDraw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDepth(Player player, List<String> toDraw) {
        toDraw.add(Component.m_237110_((String)"hud_info.depth", (Object[])new Object[]{player.m_146904_()}).getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRenderBiome(Player player, List<String> toDraw) {
        if (!biome.booleanValue() || !this.shouldRender(player, Minecraft.m_91087_().f_91077_, ISOItemTagsProvider.HUD_BIOME)) {
            return;
        }
        this.renderBiome(player, toDraw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBiome(Player player, List<String> toDraw) {
        Holder biome = player.m_9236_().m_204166_(player.m_20183_());
        String name = ((ResourceKey)biome.m_203543_().get()).m_135782_().toString();
        name = name.replace(':', '.');
        toDraw.add(Component.m_237115_((String)("biome." + name)).getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRenderTime(Player player, List<String> toDraw) {
        if (!time.booleanValue() || !this.shouldRender(player, Minecraft.m_91087_().f_91077_, ISOItemTagsProvider.HUD_TIME)) {
            return;
        }
        this.renderTime(player, toDraw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTime(Player player, List<String> toDraw) {
        toDraw.add(Component.m_237110_((String)"hud_info.time", (Object[])new Object[]{(int)((player.m_9236_().m_46468_() + 6000L) % 24000L / 1000L), String.format("%02d", player.m_9236_().m_46468_() % 1000L / 20L), player.m_9236_().m_46467_() / 24000L}).getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRenderSeason(Player player, List<String> toDraw) {
        if (!(ModList.get().isLoaded("sereneseasons") && season.booleanValue() && this.shouldRender(player, Minecraft.m_91087_().f_91077_, ISOItemTagsProvider.HUD_SEASON))) {
            return;
        }
        SereneSeasonsIntegration.addSeasonInfo(toDraw, player.m_9236_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(Player player, @Nullable HitResult hitResult, TagKey<Item> itemTag) {
        return player.m_150109_().m_204075_(itemTag) || this.isLookingAtItemFrameWith(hitResult, itemTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isLookingAtItemFrameWith(@Nullable HitResult hitResult, TagKey<Item> itemTag) {
        ItemFrame itemFrame;
        Entity entity;
        return hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).m_82443_()) instanceof ItemFrame && (itemFrame = (ItemFrame)entity).m_31822_().m_204117_(itemTag);
    }

    @NotNull
    private static String getDirectionTranslatable(float direction) {
        String d = "";
        if ((double)direction > -22.5 && (double)direction <= 22.5) {
            d = "hud_info.cardinal_direction.south";
        } else if ((double)direction > 22.5 && (double)direction <= 67.5) {
            d = "hud_info.cardinal_direction.south_west";
        } else if ((double)direction > 67.5 && (double)direction <= 112.5) {
            d = "hud_info.cardinal_direction.west";
        } else if ((double)direction > 112.5 && (double)direction <= 157.5) {
            d = "hud_info.cardinal_direction.north_west";
        } else if ((double)direction > 157.5 || (double)direction <= -157.5) {
            d = "hud_info.cardinal_direction.north";
        } else if ((double)direction > -157.5 && (double)direction <= -112.5) {
            d = "hud_info.cardinal_direction.north_east";
        } else if ((double)direction > -112.5 && (double)direction <= -67.5) {
            d = "hud_info.cardinal_direction.east";
        } else if ((double)direction > -67.5 && (double)direction <= -22.5) {
            d = "hud_info.cardinal_direction.south_east";
        }
        return d;
    }
}

