/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat;

import com.google.common.collect.Multimap;
import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.module.combat.PiercingDamage;
import insane96mcp.iguanatweaksreborn.module.combat.criticalhits.CriticalRework;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.damage.SweepingEdge;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.AttackDamageMobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Misc Stats")
@LoadFeature(module="iguanatweaksreborn:combat")
public class MiscStats
extends Feature {
    public static final RegistryObject<Enchantment> SWEEPING_EDGE = ISORegistries.ENCHANTMENTS.register("sweeping_edge", SweepingEdge::new);
    @Config
    @Label(name="Fix tooltips", description="Vanilla tooltips on gear don't sum up multiple modifiers (e.g. a sword would have \"4 Attack Damage\" and \"-2 Attack Damage\" instead of \"2 Attack Damage\". This might break other mods messing with these Tooltips (e.g. Quark's improved tooltips)")
    public static Boolean fixTooltips = true;
    @Config
    @Label(name="Better strength and weakness", description="Changes Strength and Weakness +/-3 damage per level to +/-20% damage per level. (Requires a Minecraft restart)")
    public static Boolean betterStrengthWeakness = true;
    @Config
    @Label(name="Better haste/mining fatigue", description="Changes Mining fatigue and haste to no longer affects attack speed. (Requires a Minecraft restart)")
    public static Boolean betterHasteMiningFatigue = true;
    @Config
    @Label(name="Better healing potion", description="Changes Healing potions to work like pre 1.6.1 by healing 3 health per level")
    public static Boolean betterHealingPotion = true;
    @Config
    @Label(name="1 damage for tools attacking", description="If enabled, tools will not take 2 damage when used to hurt entities")
    public static Boolean oneDamageForToolAttacking = true;
    @Config
    @Label(name="Sweeping overhaul", description="Rework Sweeping attack. Sweeping is no longer on swords, instead it's on hoes. Also, the sweeping attack deals full damage and the Sweeping Edge enchantment increases the range. This also replaces the vanilla sweeping edge enchantment with a new one that can be applied to hoes instead of swords.")
    public static Boolean sweepingOverhaul = true;
    @Config
    @Label(description="Enables a data pack that reworks armor, weapons and tools.")
    public static Boolean combatReworkDataPack = true;

    public MiscStats(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("combat_rework", "Insane's Survival Overhaul Combat Rework", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && combatReworkDataPack != false);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (betterStrengthWeakness.booleanValue()) {
            MobEffects.f_19600_.f_19446_.remove(Attributes.f_22281_);
            MobEffects.f_19600_.m_19472_(Attributes.f_22281_, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 0.0, AttributeModifier.Operation.MULTIPLY_BASE);
            ((AttackDamageMobEffect)MobEffects.f_19600_).f_19424_ = 0.2;
        }
        if (betterStrengthWeakness.booleanValue()) {
            MobEffects.f_19613_.f_19446_.remove(Attributes.f_22281_);
            MobEffects.f_19613_.m_19472_(Attributes.f_22281_, "22653B89-116E-49DC-9B6B-9971489B5BE5", 0.0, AttributeModifier.Operation.MULTIPLY_BASE);
            ((AttackDamageMobEffect)MobEffects.f_19613_).f_19424_ = -0.2;
        }
        if (betterHasteMiningFatigue.booleanValue()) {
            MobEffects.f_19598_.f_19446_.remove(Attributes.f_22283_);
            MobEffects.f_19599_.f_19446_.remove(Attributes.f_22283_);
        }
        if (sweepingOverhaul.booleanValue()) {
            ToolActions.DEFAULT_SWORD_ACTIONS.remove(ToolActions.SWORD_SWEEP);
            ToolActions.DEFAULT_HOE_ACTIONS.add(ToolActions.SWORD_SWEEP);
            Enchantments.f_44983_ = (Enchantment)SWEEPING_EDGE.get();
        } else {
            ToolActions.DEFAULT_SWORD_ACTIONS.add(ToolActions.SWORD_SWEEP);
            ToolActions.DEFAULT_HOE_ACTIONS.remove(ToolActions.SWORD_SWEEP);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (!this.isEnabled() || !fixTooltips.booleanValue() || event.getItemStack().m_41720_() instanceof PotionItem) {
            return;
        }
        ArrayList<Component> toRemove = new ArrayList<Component>();
        boolean hasModifiersTooltip = false;
        Component emptyLine = null;
        for (Component mutableComponent : event.getToolTip()) {
            Object object;
            if (emptyLine == null) {
                Component component2 = emptyLine = mutableComponent.m_7360_().isEmpty() && mutableComponent.m_214077_().equals(ComponentContents.f_237124_) ? mutableComponent : null;
            }
            if ((object = mutableComponent.m_214077_()) instanceof TranslatableContents) {
                TranslatableContents t = (TranslatableContents)object;
                if (t.m_237508_().startsWith("item.modifiers.")) {
                    hasModifiersTooltip = true;
                    toRemove.add(mutableComponent);
                    if (emptyLine != null) {
                        toRemove.add(emptyLine);
                    }
                    emptyLine = null;
                } else if (t.m_237508_().startsWith("attribute.modifier.")) {
                    toRemove.add(mutableComponent);
                }
            }
            if (!hasModifiersTooltip) continue;
            List siblings = mutableComponent.m_7360_();
            object = siblings.iterator();
            while (object.hasNext()) {
                TranslatableContents translatableContents;
                Component component3 = (Component)object.next();
                ComponentContents componentContents = component3.m_214077_();
                if (!(componentContents instanceof TranslatableContents) || !(translatableContents = (TranslatableContents)componentContents).m_237508_().startsWith("attribute.modifier.")) continue;
                toRemove.add(mutableComponent);
            }
        }
        toRemove.forEach(component -> event.getToolTip().remove(component));
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            Multimap multimap = event.getItemStack().m_41638_(equipmentslot);
            if (multimap.isEmpty()) continue;
            event.getToolTip().add(CommonComponents.f_237098_);
            event.getToolTip().add(Component.m_237115_((String)("item.modifiers." + equipmentslot.m_20751_())).m_130940_(ChatFormatting.GRAY));
            multimap.keySet().stream().sorted(Comparator.comparing(attr -> ForgeRegistries.ATTRIBUTES.getKey(attr).m_135815_())).forEach(attribute -> {
                Map<AttributeModifier.Operation, List<AttributeModifier>> modifiersByOperation = multimap.get(attribute).stream().collect(Collectors.groupingBy(AttributeModifier::m_22217_));
                modifiersByOperation.forEach((operation, modifier) -> {
                    double amount = modifier.stream().mapToDouble(AttributeModifier::m_22218_).sum();
                    boolean isEqualTooltip = false;
                    if (event.getEntity() != null && operation == AttributeModifier.Operation.ADDITION && equipmentslot == EquipmentSlot.MAINHAND) {
                        if (attribute.equals(Attributes.f_22281_)) {
                            amount += event.getEntity().m_21172_(Attributes.f_22281_);
                            isEqualTooltip = true;
                        }
                        if (attribute.equals(PiercingDamage.PIERCING_DAMAGE.get()) || attribute.equals(Attributes.f_22283_) || attribute.equals(Attributes.f_22278_) || attribute.equals(ForgeMod.ENTITY_REACH.get()) || attribute.equals(ForgeMod.BLOCK_REACH.get()) || attribute.equals(CriticalRework.CHANCE_ATTRIBUTE.get()) || attribute.equals(CriticalRework.DAMAGE_ATTRIBUTE.get())) {
                            amount += event.getEntity().m_21172_(attribute);
                            isEqualTooltip = true;
                            if (attribute.equals(CriticalRework.DAMAGE_ATTRIBUTE.get())) {
                                amount += 1.0;
                            }
                        }
                    }
                    if (!isEqualTooltip && amount == 0.0) {
                        return;
                    }
                    MutableComponent component = null;
                    String translationString = "attribute.modifier.plus.";
                    if (isEqualTooltip || operation == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                        translationString = "attribute.modifier.equals.";
                    } else if (amount < 0.0) {
                        translationString = "attribute.modifier.take.";
                    }
                    MutableComponent attributeComponent = Component.m_237115_((String)attribute.m_22087_());
                    switch (operation) {
                        case ADDITION: {
                            if (attribute.equals(Attributes.f_22278_) || attribute.equals(CriticalRework.CHANCE_ATTRIBUTE.get()) || attribute.equals(CriticalRework.DAMAGE_ATTRIBUTE.get())) {
                                component = Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(amount * 100.0) + "%", attributeComponent});
                                break;
                            }
                            component = Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(amount)), attributeComponent});
                            break;
                        }
                        case MULTIPLY_BASE: {
                            component = Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(amount) * 100.0), attributeComponent});
                            break;
                        }
                        case MULTIPLY_TOTAL: {
                            component = Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{"x" + ItemStack.f_41584_.format(amount > 0.0 ? Math.abs(amount) + 1.0 : 1.0 - Math.abs(amount)), attributeComponent});
                        }
                    }
                    if (isEqualTooltip) {
                        component = CommonComponents.m_264333_().m_7220_((Component)component.m_130940_(ChatFormatting.DARK_GREEN));
                    } else if (amount > 0.0) {
                        component.m_130940_(ChatFormatting.BLUE);
                    } else {
                        component.m_130940_(ChatFormatting.RED);
                    }
                    event.getToolTip().add(component);
                });
            });
        }
    }
}

