/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat;

import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.SerializableAttributeModifier;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Player Stats", description="Apply attribute modifiers to players. Attributes can be added in the json config of this feature's folder. Changing attribute modifiers requires player rejoin")
@LoadFeature(module="iguanatweaksreborn:combat")
public class PlayerStats
extends JsonFeature {
    public static final UUID MOVEMENT_SPEED_REDUCTION_UUID = UUID.fromString("a88ac0d1-e2b3-4cf1-bb0e-9577486c874a");
    public static final UUID BLOCK_REACH_REDUCTION_UUID = UUID.fromString("bae34f6a-c58e-4622-b2ab-f1b89b73b781");
    @Config
    @Label(description="In vanilla, if you attack as soon as you just attacked you already deal 20% of the full damage. This changes that to 0%. This also mixins into Tinkers Construct to apply the same effect.")
    public static Boolean noDamageWhenSpamming = true;
    public static final ArrayList<SerializableAttributeModifier> ATTRIBUTE_MODIFIERS_DEFAULT = new ArrayList<SerializableAttributeModifier>(List.of(new SerializableAttributeModifier(MOVEMENT_SPEED_REDUCTION_UUID, "Player Stats' Movement Speed modifier", List.of(), () -> Attributes.f_22279_, -0.05, AttributeModifier.Operation.MULTIPLY_BASE), new SerializableAttributeModifier(BLOCK_REACH_REDUCTION_UUID, "Player Stats' Block reach modifier", List.of(), (Supplier)ForgeMod.BLOCK_REACH, -1.0, AttributeModifier.Operation.ADDITION)));
    public static final ArrayList<SerializableAttributeModifier> attributeModifiers = new ArrayList();

    public PlayerStats(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("players_attribute_modifiers.json", attributeModifiers, ATTRIBUTE_MODIFIERS_DEFAULT, SerializableAttributeModifier.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public static boolean noDamageWhenSpamming() {
        return PlayerStats.isEnabled(PlayerStats.class) && noDamageWhenSpamming != false;
    }

    @SubscribeEvent
    public void onPlayerJoinLevel(EntityJoinLevelEvent event) {
        Object object;
        if (!this.isEnabled() || !((object = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        for (SerializableAttributeModifier modifier : attributeModifiers) {
            MCUtils.applyModifier((LivingEntity)player, (Attribute)((Attribute)modifier.attribute().get()), (UUID)modifier.uuid(), (String)modifier.name(), (double)modifier.amount(), (AttributeModifier.Operation)modifier.operation(), (boolean)false);
        }
    }
}

