/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat;

import com.mojang.blaze3d.systems.RenderSystem;
import insane96mcp.iguanatweaksreborn.integration.NoHungerIntegration;
import insane96mcp.iguanatweaksreborn.network.message.RegenAbsorptionSync;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.ClientUtils;
import insane96mcp.insanelib.world.effect.ILMobEffect;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Regenerating Absorption", description="Adds a new attribute to add regenerating absorption hearts to the player.")
@LoadFeature(module="iguanatweaksreborn:combat")
public class RegeneratingAbsorption
extends Feature {
    public static final ResourceLocation GUI_ICONS = new ResourceLocation("iguanatweaksreborn", "textures/gui/absorption.png");
    public static final String REGEN_ABSORPTION_TAG = "iguanatweaksreborn:regen_absorption";
    public static final String HURT_COOLDOWN_TAG = "iguanatweaksreborn:regen_absorption_hurt_cooldown";
    public static final String NO_HURT_SOUND_TAG = "iguanatweaksreborn:no_hurt_sound";
    public static final RegistryObject<Attribute> ATTRIBUTE = ISORegistries.ATTRIBUTES.register("regenerating_absorption", () -> new RangedAttribute("attribute.name.regenerating_absorption", 0.0, 0.0, 1024.0));
    public static final RegistryObject<Attribute> SPEED_ATTRIBUTE = ISORegistries.ATTRIBUTES.register("regenerating_absorption_speed", () -> new RangedAttribute("attribute.name.regenerating_absorption_speed", 0.25, 0.0, 20.0));
    public static final RegistryObject<MobEffect> EFFECT = ISORegistries.MOB_EFFECTS.register("regenerating_absorption", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8489108).m_19472_((Attribute)ATTRIBUTE.get(), "704d7291-63ba-4346-8aa8-a08e90a13fdf", 4.0, AttributeModifier.Operation.ADDITION));
    @Config(min=0.0)
    @Label(name="Un-damaged time to regen", description="Ticks that must pass from the last hit to regen absorption hearts. This is affected by regenerating absorption speed (absorp regen speed * this)")
    public static Integer unDamagedTimeToRegen = 150;
    @Config(min=0.0)
    @Label(name="Un-damaged time to regen cap", description="Min Un-damaged time to regen")
    public static Integer unDamagedTimeToRegenCap = 60;
    @Config
    @Label(name="Cap to health", description="The amount of regenerating absorption hearts cannot go over the entity's current health.")
    public static Boolean capToHealth = true;
    @Config
    @Label(description="How fast (each tick) will absorption hearts decay when higher than the current maximum.")
    public static Double decaySpeed = 0.1;
    @Config
    @Label(name="Absorbing bypasses_armor damage only", description="If true, absorption hearts will not shield from damages in the bypasses_armor damage type tag.")
    public static Boolean absorbingDamageTypeTagOnly = true;
    @Config
    @Label(name="Sound on absorption hurt", description="If true, a sound is played when the absorption is damaged.")
    public static Boolean soundOnAbsorptionHurt = true;
    @Config
    @Label(name="Render on the right", description="(Client only) If true, regenerating absorption hearts are rendered on the right instead on top of hearts.")
    public static Boolean renderOnRight = false;
    static int lastAbsorption = 0;
    static long lastAbsorptionTime = 0L;
    static long absorptionBlinkTime = 0L;
    static int displayAbsorption = 0;

    public RegeneratingAbsorption(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void addAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (!event.has(entityType, (Attribute)ATTRIBUTE.get())) {
                event.add(entityType, (Attribute)ATTRIBUTE.get());
            }
            if (event.has(entityType, (Attribute)SPEED_ATTRIBUTE.get())) continue;
            event.add(entityType, (Attribute)SPEED_ATTRIBUTE.get());
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || event.getEntity().m_21224_()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        int hurtCooldown = entity.getPersistentData().m_128451_(HURT_COOLDOWN_TAG);
        if (hurtCooldown > 0) {
            entity.getPersistentData().m_128405_(HURT_COOLDOWN_TAG, --hurtCooldown);
            return;
        }
        float maxAbsorption = (float)entity.m_21133_((Attribute)ATTRIBUTE.get());
        float regenSpeed = (float)(entity.m_21133_((Attribute)SPEED_ATTRIBUTE.get()) / 20.0);
        float currentAbsorption = entity.getPersistentData().m_128457_(REGEN_ABSORPTION_TAG);
        if (capToHealth.booleanValue()) {
            maxAbsorption = Math.min(maxAbsorption, (float)Mth.m_14167_((float)entity.m_21223_()));
        }
        if (currentAbsorption < 0.0f || currentAbsorption == maxAbsorption) {
            return;
        }
        currentAbsorption = currentAbsorption > maxAbsorption ? Math.max(currentAbsorption - decaySpeed.floatValue(), 0.0f) : Math.min(currentAbsorption + regenSpeed, maxAbsorption);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            RegenAbsorptionSync.sync(player, currentAbsorption);
        }
        entity.getPersistentData().m_128350_(REGEN_ABSORPTION_TAG, currentAbsorption);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || unDamagedTimeToRegen == 0 || event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
            return;
        }
        double absorptionSpeed = event.getEntity().m_21133_((Attribute)SPEED_ATTRIBUTE.get());
        event.getEntity().getPersistentData().m_128405_(HURT_COOLDOWN_TAG, (int)Math.max((double)unDamagedTimeToRegen.intValue() * (1.0 - absorptionSpeed), (double)unDamagedTimeToRegenCap.intValue()));
    }

    @SubscribeEvent
    public void onLivingHurtPreAbsorption(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !RegeneratingAbsorption.canDamageAbsorption(event.getSource()) || event.getAmount() <= 0.0f) {
            return;
        }
        float currentAbsorption = event.getEntity().getPersistentData().m_128457_(REGEN_ABSORPTION_TAG);
        if (currentAbsorption <= 0.0f) {
            return;
        }
        float toRemove = Math.min(currentAbsorption, event.getAmount());
        event.setAmount(event.getAmount() - toRemove);
        event.getEntity().getPersistentData().m_128350_(REGEN_ABSORPTION_TAG, currentAbsorption -= toRemove);
        if (soundOnAbsorptionHurt.booleanValue()) {
            event.getEntity().m_9236_().m_6269_(null, (Entity)event.getEntity(), (SoundEvent)ISORegistries.ABSORPTION_HIT.get(), event.getEntity() instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 2.0f);
        }
        if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            RegenAbsorptionSync.sync(player, currentAbsorption);
        }
    }

    public static boolean canDamageAbsorption(DamageSource source) {
        if (!absorbingDamageTypeTagOnly.booleanValue()) {
            return true;
        }
        return source.m_7639_() != null && !source.m_269533_(DamageTypeTags.f_268490_);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        ResourceLocation aboveOverlay = VanillaGuiOverlay.PLAYER_HEALTH.id();
        if (ModList.get().isLoaded("stamina")) {
            aboveOverlay = new ResourceLocation("stamina:stamina_overlay");
        }
        if (renderOnRight.booleanValue()) {
            aboveOverlay = ModList.get().isLoaded("nohunger") && NoHungerIntegration.doesRenderArmorAtHunger() ? new ResourceLocation("iguanatweaksreborn", "armor") : VanillaGuiOverlay.FOOD_LEVEL.id();
        }
        event.registerAbove(aboveOverlay, "regenerating_absorption", (gui, guiGraphics, partialTicks, screenWidth, screenHeight) -> {
            if (RegeneratingAbsorption.isEnabled(RegeneratingAbsorption.class) && gui.shouldDrawSurvivalElements() && gui.shouldDrawSurvivalElements()) {
                RegeneratingAbsorption.renderAbsorption(gui, guiGraphics, screenWidth, screenHeight);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void renderAbsorption(ForgeGui gui, GuiGraphics guiGraphics, int width, int height) {
        int v;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        mc.m_91307_().m_6180_("regen_absorption");
        RenderSystem.enableBlend();
        int left = width / 2 + (renderOnRight == false ? -91 : 82);
        int top = height - (renderOnRight == false ? gui.leftHeight : gui.rightHeight);
        int absorption = Mth.m_14167_((float)mc.f_91074_.getPersistentData().m_128457_(REGEN_ABSORPTION_TAG));
        boolean highlight = absorptionBlinkTime > (long)gui.m_93079_() && (absorptionBlinkTime - (long)gui.m_93079_()) / 3L % 2L == 1L;
        int n = v = highlight ? 9 : 0;
        if (absorption < lastAbsorption && player.f_19802_ > 0) {
            lastAbsorptionTime = Util.m_137550_();
            displayAbsorption = lastAbsorption;
            absorptionBlinkTime = gui.m_93079_() + 20;
        } else if (absorption > lastAbsorption) {
            displayAbsorption = absorption;
            absorptionBlinkTime = gui.m_93079_() + 10;
        }
        if (Util.m_137550_() - lastAbsorptionTime > 1000L) {
            lastAbsorption = absorption;
            displayAbsorption = absorption;
            lastAbsorptionTime = Util.m_137550_();
        }
        lastAbsorption = absorption;
        for (int i = 1; i <= displayAbsorption; ++i) {
            int u;
            if (i > absorption) {
                ClientUtils.setRenderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            int n2 = u = i % 2 == 0 ? 0 : 9;
            if (!renderOnRight.booleanValue()) {
                guiGraphics.m_280163_(GUI_ICONS, left, top, (float)u, (float)v, 9, 9, 18, 18);
            } else {
                ClientUtils.blitVericallyMirrored((ResourceLocation)GUI_ICONS, (GuiGraphics)guiGraphics, (int)left, (int)top, (int)u, (int)v, (int)9, (int)9, (int)18, (int)18);
            }
            if (i % 20 == 0 && i != displayAbsorption) {
                left = width / 2 + (renderOnRight == false ? -91 : 82);
                top -= 10;
                if (!renderOnRight.booleanValue()) {
                    gui.leftHeight += 10;
                } else {
                    gui.rightHeight += 10;
                }
            } else if (i % 2 == 0) {
                left += renderOnRight != false ? -8 : 8;
            }
            if (i <= absorption) continue;
            ClientUtils.resetRenderColor();
        }
        if (displayAbsorption > 0) {
            if (!renderOnRight.booleanValue()) {
                gui.leftHeight += 10;
            } else {
                gui.rightHeight += 10;
            }
        }
        RenderSystem.disableBlend();
        mc.m_91307_().m_7238_();
    }
}

