/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience.anvils;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

@JsonAdapter(value=Serializer.class)
public class AnvilRepair {
    public final IdTagMatcher itemToRepair;
    public final List<RepairData> repairData;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<AnvilRepair>>(){}.getType();

    public AnvilRepair(IdTagMatcher itemToRepair, List<RepairData> repairData) {
        this.itemToRepair = itemToRepair;
        this.repairData = repairData;
    }

    public AnvilRepair(IdTagMatcher itemToRepair, RepairData ... repairData) {
        this.itemToRepair = itemToRepair;
        this.repairData = List.of(repairData);
    }

    public boolean isItemToRepair(ItemStack stack) {
        return this.itemToRepair.matchesItem(stack.m_41720_());
    }

    public Optional<RepairData> getRepairDataFromMaterial(ItemStack stack) {
        for (RepairData repairData : this.repairData) {
            if (!repairData.repairMaterial.matchesItem(stack.m_41720_())) continue;
            return Optional.of(repairData);
        }
        return Optional.empty();
    }

    public static AnvilRepair fromNetwork(FriendlyByteBuf byteBuf) {
        IdTagMatcher idTagMatcher = IdTagMatcher.parseLine((String)byteBuf.m_130277_());
        int size = byteBuf.readInt();
        ArrayList<RepairData> repairData = new ArrayList<RepairData>();
        for (int i = 0; i < size; ++i) {
            repairData.add(RepairData.fromNetwork(byteBuf));
        }
        return new AnvilRepair(idTagMatcher, repairData);
    }

    public void toNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.m_130070_(this.itemToRepair.m_7912_());
        byteBuf.writeInt(this.repairData.size());
        for (RepairData repairData : this.repairData) {
            repairData.toNetwork(byteBuf);
        }
    }

    public record RepairData(@SerializedName(value="repair_material") IdTagMatcher repairMaterial, @SerializedName(value="amount") float amountRequired, @SerializedName(value="max_repair") float maxRepair, @SerializedName(value="cost_multiplier") float costMultiplier) {
        public static RepairData fromNetwork(FriendlyByteBuf byteBuf) {
            IdTagMatcher idTagMatcher = IdTagMatcher.parseLine((String)byteBuf.m_130277_());
            float amount = byteBuf.readFloat();
            float maxRepair = byteBuf.readFloat();
            float costMultiplier = byteBuf.readFloat();
            return new RepairData(idTagMatcher, amount, maxRepair, costMultiplier);
        }

        public void toNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.m_130070_(this.repairMaterial.m_7912_());
            byteBuf.writeFloat(this.amountRequired);
            byteBuf.writeFloat(this.maxRepair);
            byteBuf.writeFloat(this.costMultiplier);
        }
    }

    public static class Serializer
    implements JsonDeserializer<AnvilRepair>,
    JsonSerializer<AnvilRepair> {
        public AnvilRepair deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            IdTagMatcher itemToRepair = (IdTagMatcher)context.deserialize(json.getAsJsonObject().get("item_to_repair"), IdTagMatcher.class);
            ArrayList<RepairData> repairData = new ArrayList<RepairData>();
            JsonArray array = GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"repair");
            for (JsonElement element : array) {
                IdTagMatcher repairMaterial = (IdTagMatcher)context.deserialize(element.getAsJsonObject().get("repair_material"), IdTagMatcher.class);
                float amount = GsonHelper.m_13915_((JsonObject)element.getAsJsonObject(), (String)"amount");
                if (amount <= 0.0f) {
                    throw new JsonParseException("amount must be greater than 0");
                }
                float maxRepair = GsonHelper.m_13820_((JsonObject)element.getAsJsonObject(), (String)"max_repair", (float)1.0f);
                if (maxRepair > 1.0f || maxRepair < 0.0f) {
                    throw new JsonParseException("max_repair must be between 0 and 1");
                }
                float costMultiplier = GsonHelper.m_13820_((JsonObject)element.getAsJsonObject(), (String)"cost_multiplier", (float)1.0f);
                if (costMultiplier < 0.0f) {
                    throw new JsonParseException("cost_multiplier must be greater than or equal to 0");
                }
                repairData.add(new RepairData(repairMaterial, amount, maxRepair, costMultiplier));
            }
            return new AnvilRepair(itemToRepair, repairData);
        }

        public JsonElement serialize(AnvilRepair src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            JsonElement itemToRepair = context.serialize((Object)src.itemToRepair, IdTagMatcher.class);
            jsonObject.add("item_to_repair", itemToRepair);
            JsonArray repair = new JsonArray();
            for (RepairData repairData : src.repairData) {
                JsonObject r = new JsonObject();
                r.add("repair_material", context.serialize((Object)repairData.repairMaterial, IdTagMatcher.class));
                r.addProperty("amount", (Number)Float.valueOf(repairData.amountRequired));
                if (repairData.maxRepair < 1.0f) {
                    r.addProperty("max_repair", (Number)Float.valueOf(repairData.maxRepair));
                }
                if (repairData.costMultiplier != 1.0f) {
                    r.addProperty("cost_multiplier", (Number)Float.valueOf(repairData.costMultiplier));
                }
                r.add("repair_material", context.serialize((Object)repairData.repairMaterial, IdTagMatcher.class));
                repair.add((JsonElement)r);
            }
            jsonObject.add("repair", (JsonElement)repair);
            return jsonObject;
        }
    }
}

