/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience.anvils;

import insane96mcp.iguanatweaksreborn.module.experience.anvils.AnvilRepair;
import insane96mcp.iguanatweaksreborn.module.experience.anvils.AnvilRepairReloadListener;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Anvils", description="Better repair, free rename and merge. With this feature enabled, EMI's repairs and enchanting in anvil recipes are removed.")
@LoadFeature(module="iguanatweaksreborn:experience")
public class Anvils
extends Feature {
    public static final String CAN_BE_REPAIRED_WITH_LANG = "iguanatweaksreborn.can_be_repaired_with";
    @Config
    @Label(name="Renaming.No cost", description="Removes the cost for renaming items in Anvil")
    public static Boolean renamingNoCost = true;
    @Config
    @Label(name="Renaming.No break", description="If true, anvils don't wear down when only used for renaming")
    public static Boolean renamingNoBreak = true;
    @Config(min=0.0)
    @Label(name="XP Cost.Repair cap", description="Set the cap for repairing items in the anvil (vanilla is 40)")
    public static Integer anvilRepairCap = 1024;
    @Config(min=0.0)
    @Label(name="XP Cost.Multiplier", description="Multiplier for the levels required to repair or merge an item.")
    public static Double repairCostMultiplier = 1.0;
    @Config
    @Label(name="XP Cost.Merging cost is based off result", description="The cost when merging two items is calculated from the final item, no longer from a strange calculations between the two items merging.")
    public static Boolean mergingCostBasedOffResult = true;
    @Config
    @Label(name="XP Cost.No cost", description="Repairing items in an anvil doesn't cost xp")
    public static Boolean noXpRepairCost = true;
    @Config
    @Label(name="XP Cost.Different repair cost", description="XP cost when repairing an item in an anvil is based of the levels of the enchantments. This is not affected by 'Repair cost multiplier'")
    public static Boolean differentXpRepairCost = false;
    @Config(min=0.0)
    @Label(name="XP Cost.Enchantments cost by rarity.Common", description="Vanilla: 1")
    public static Integer enchantmentCostCommon = 1;
    @Config(min=0.0)
    @Label(name="XP Cost.Enchantments cost by rarity.Uncommon", description="Vanilla: 2")
    public static Integer enchantmentCostUncommon = 2;
    @Config(min=0.0)
    @Label(name="XP Cost.Enchantments cost by rarity.Rare", description="Vanilla: 4")
    public static Integer enchantmentCostRare = 3;
    @Config(min=0.0)
    @Label(name="XP Cost.Enchantments cost by rarity.Very Rare", description="Vanilla: 8")
    public static Integer enchantmentCostVeryRare = 6;
    @Config
    @Label(name="Material Cost.Increase materials required with enchantments", description="Repairing items in an anvil costs more materials if the item is enchanted. This is the percentage increase for each level of enchantment on the item")
    public static Double moreMaterialIfEnchanted = 0.05;
    @Config
    @Label(name="Material Cost.Increase materials required with enchantments (Flat)", description="Repairing items in an anvil costs more materials if the item is enchanted. This is the flat increase for each level of enchantment on the item")
    public static Double moreMaterialIfEnchantedFlat = 0.5;
    @Config
    @Label(name="Merge Repair.Decrease repair amount with enchantments", description="Merging items in an anvil will reduce the repair amount if the left is enchanted. This is the multiplicative percentage decrease for each level of enchantment on the item. This is applied to the right item durability before the bonus repair.")
    public static Double mergeRepairIfEnchanted = 0.05;
    @Config
    @Label(name="Allow Merging Items", description="If true you can merge items in the anvil and get a repair bonus")
    public static Boolean allowMergingItems = true;
    @Config(min=0.0, max=100.0)
    @Label(name="Merging Repair bonus", description="Vanilla is 12%")
    public static Integer mergingRepairBonus = 10;
    @Config(min=0.0)
    @Label(name="Degradation chance", description="Chance for an anvil to become chipped/damaged/break. Vanilla is 12%")
    public static Double degradationChance = 0.01;
    @Config
    @Label(name="Fix with Iron blocks")
    public static Boolean allowFixingAnvils = true;

    public Anvils(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static Optional<AnvilRepair> getCustomAnvilRepair(ItemStack left) {
        if (!Feature.isEnabled(Anvils.class)) {
            return Optional.empty();
        }
        for (AnvilRepair anvilRepair : AnvilRepairReloadListener.REPAIRS.values()) {
            if (!anvilRepair.isItemToRepair(left)) continue;
            return Optional.of(anvilRepair);
        }
        return Optional.empty();
    }

    public static Optional<AnvilRepair.RepairData> getCustomAnvilRepair(ItemStack left, ItemStack right) {
        if (!Feature.isEnabled(Anvils.class)) {
            return Optional.empty();
        }
        for (AnvilRepair anvilRepair : AnvilRepairReloadListener.REPAIRS.values()) {
            Optional<AnvilRepair.RepairData> repairData;
            if (!anvilRepair.isItemToRepair(left) || !(repairData = anvilRepair.getRepairDataFromMaterial(right)).isPresent()) continue;
            return repairData;
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public void onRightClickAnvil(PlayerInteractEvent.RightClickBlock event) {
        if (!(this.isEnabled() && allowFixingAnvils.booleanValue() && event.getItemStack().m_150930_(Items.f_41913_))) {
            return;
        }
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (!state.m_204336_(BlockTags.f_13033_)) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)AnvilBlock.f_48764_);
        boolean isChipped = state.m_60713_(Blocks.f_50323_);
        boolean isDamaged = state.m_60713_(Blocks.f_50324_);
        if (!isChipped && !isDamaged) {
            return;
        }
        event.setResult(Event.Result.DENY);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        if (!event.getEntity().m_150110_().f_35937_) {
            event.getItemStack().m_41774_(1);
        }
        event.getLevel().m_46597_(event.getPos(), isChipped ? (BlockState)Blocks.f_50322_.m_49966_().m_61124_((Property)AnvilBlock.f_48764_, (Comparable)direction) : (BlockState)Blocks.f_50323_.m_49966_().m_61124_((Property)AnvilBlock.f_48764_, (Comparable)direction));
        event.getLevel().m_5594_(event.getEntity(), event.getPos(), SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.5f);
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, event.getPos(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        event.setBreakChance(degradationChance.floatValue());
        if (renamingNoBreak.booleanValue() && ItemStack.m_41656_((ItemStack)event.getLeft(), (ItemStack)event.getOutput()) && event.getRight().m_41619_()) {
            event.setBreakChance(0.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.f_91080_ instanceof AnvilScreen)) {
            return;
        }
        ArrayList itemsDescriptions = new ArrayList();
        Optional<AnvilRepair> oCustomAnvilRepair = Anvils.getCustomAnvilRepair(event.getItemStack());
        oCustomAnvilRepair.ifPresent(anvilRepair -> {
            for (AnvilRepair.RepairData repairData : anvilRepair.repairData) {
                if (repairData.repairMaterial().type == IdTagMatcher.Type.TAG) {
                    MutableComponent component = Component.m_237113_((String)"#").m_130946_(repairData.repairMaterial().location.toString());
                    if (repairData.maxRepair() < 1.0f) {
                        component.m_7220_((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237115_((String)"iguanatweaksreborn.partial_repair")));
                    }
                    itemsDescriptions.add(component);
                    continue;
                }
                Optional oItem = repairData.repairMaterial().getAllItems().stream().findAny();
                if (!oItem.isPresent()) continue;
                MutableComponent component = ((Item)oItem.get()).m_41466_().m_6881_();
                if (repairData.maxRepair() < 1.0f) {
                    component.m_7220_((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237115_((String)"iguanatweaksreborn.partial_repair")));
                }
                itemsDescriptions.add(component);
            }
        });
        if (!itemsDescriptions.isEmpty()) {
            String joined = itemsDescriptions.stream().map(Component::getString).collect(Collectors.joining(", "));
            event.getToolTip().add(Component.m_237119_());
            event.getToolTip().add(Component.m_237110_((String)CAN_BE_REPAIRED_WITH_LANG, (Object[])new Object[]{joined}).m_130940_(ChatFormatting.GREEN));
        }
    }

    public static int getRarityCost(Enchantment enchantment) {
        return switch (enchantment.m_44699_()) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> enchantmentCostCommon;
            case Enchantment.Rarity.UNCOMMON -> enchantmentCostUncommon;
            case Enchantment.Rarity.RARE -> enchantmentCostRare;
            case Enchantment.Rarity.VERY_RARE -> enchantmentCostVeryRare;
        };
    }
}

