/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.bonemeal;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.criterion.ISOTriggers;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.farming.bonemeal.FarmersDelightIntegration;
import insane96mcp.iguanatweaksreborn.module.farming.bonemeal.RichFarmlandBlock;
import insane96mcp.iguanatweaksreborn.module.farming.bonemeal.SupplementariesIntegration;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinition;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinitionReloadListener;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

@Label(name="Bone meal", description="Increase uses for bone meal and nerf its use on some plants")
@LoadFeature(module="iguanatweaksreborn:farming")
public class BoneMeal
extends Feature {
    public static final SimpleBlockWithItem RICH_FARMLAND = SimpleBlockWithItem.register("rich_farmland", () -> new RichFarmlandBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56739_).m_60971_((state, blockGetter, pos) -> true).m_60960_((state, blockGetter, pos) -> true)));
    public static final TagKey<Item> ITEM_BLACKLIST = ISOItemTagsProvider.create("bone_meal_blacklist");
    public static final TagKey<Block> BLOCK_BLACKLIST = ISOBlockTagsProvider.create("bone_meal_blacklist");
    @Config
    @Label(name="Rich Farmland", description="Bone meal used on Farmland (or shift right clicked on crops) transforms it into Rich Farmland.")
    public static Boolean richFarmland = true;
    @Config(min=1.0)
    @Label(name="Rich Farmland Extra Ticks", description="How many extra random ticks does Rich Farmland give to the crop sitting on top?")
    public static Integer richFarmlandExtraTicks = 3;
    @Config(min=0.0, max=1.0)
    @Label(name="Rich Farmland Chance to Decay", description="Chance for a Rich farmland to decay back to farmland")
    public static Double richFarmlandChanceToDecay = 0.4;
    @Config(min=0.0, max=25.0)
    @Label(name="Stage growth", description="How many stages will bone meal make stuff grow?")
    public static MinMax stageGrowth = new MinMax(1.0, 1.0);
    @Config
    @Label(name="Compostable Rotten Flesh")
    public static Boolean compostableRottenFlesh = true;
    @Config
    @Label(name="Season fail chance", description="Chance for a bone meal to fail to grow something. Empty this string to disable. Accepts a list of seasons and chances separated by a ;")
    public static String seasonFailChance = "WINTER,0.65";
    @Config
    @Label(name="Bone meal dirt to grass", description="If true, you can bone meal dirt that's near a grass block to get grass block.")
    public static Boolean boneMealDirtToGrass = true;
    @Config(min=0.0)
    @Label(name="Bone meal canes and cactus", description="How many stages will cactus and sugar canes grow with one bone meal")
    public static MinMax boneMealCanesAndCactus = new MinMax(1.0, 4.0);
    private static final Map<IntegerProperty, Integer> AGE_PROPERTIES = Map.of(BlockStateProperties.f_61405_, 1, BlockStateProperties.f_61406_, 2, BlockStateProperties.f_61407_, 3, BlockStateProperties.f_222999_, 4, BlockStateProperties.f_61408_, 5, BlockStateProperties.f_61409_, 7, BlockStateProperties.f_61410_, 15, BlockStateProperties.f_61411_, 25);

    public BoneMeal(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (compostableRottenFlesh.booleanValue()) {
            ComposterBlock.f_51914_.put((Object)Items.f_42583_, 0.5f);
        } else {
            ComposterBlock.f_51914_.removeFloat((Object)Items.f_42583_);
        }
    }

    @SubscribeEvent
    public void onBoneMeal(BonemealEvent event) {
        if (event.isCanceled() || event.getResult() != Event.Result.DEFAULT || !this.isEnabled() || event.getLevel().f_46443_ || event.getStack().m_204117_(ITEM_BLACKLIST) || event.getBlock().m_204336_(BLOCK_BLACKLIST)) {
            return;
        }
        this.tryMakeRichFarmland(event);
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        this.tryConsumeWithFail(event);
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        this.applyNerfedBoneMeal(event);
        if (event.getResult() != Event.Result.ALLOW) {
            if (boneMealDirtToGrass.booleanValue()) {
                this.tryBoneMealDirt(event, event.getLevel(), event.getBlock(), event.getPos());
            }
            this.tryBoneMealCanesAndCactus(event, event.getLevel(), event.getBlock(), event.getPos());
        }
    }

    private void tryMakeRichFarmland(BonemealEvent event) {
        if (!richFarmland.booleanValue()) {
            return;
        }
        BlockPos farmlandPos = null;
        if (event.getBlock().m_60713_(Blocks.f_50093_)) {
            farmlandPos = event.getPos();
        } else if (event.getLevel().m_8055_(event.getPos().m_7495_()).m_60713_(Blocks.f_50093_) && event.getEntity().m_6047_()) {
            farmlandPos = event.getPos().m_7495_();
        }
        if (farmlandPos != null) {
            event.getLevel().m_46597_(farmlandPos, (BlockState)((Block)RICH_FARMLAND.block().get()).m_49966_().m_61124_((Property)FarmBlock.f_53243_, (Comparable)((Integer)event.getLevel().m_8055_(farmlandPos).m_61143_((Property)FarmBlock.f_53243_))));
            event.getEntity().m_21011_(event.getEntity().m_21205_().m_41720_() == event.getStack().m_41720_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
            event.setResult(Event.Result.ALLOW);
            ISOTriggers.MAKE_RICH_FARMLAND.trigger((ServerPlayer)event.getEntity());
        }
    }

    private void tryConsumeWithFail(BonemealEvent event) {
        this.failFromBlockDefinitions(event);
        if (event.getResult() != Event.Result.ALLOW) {
            this.failFromSeason(event);
        }
    }

    private void failFromBlockDefinitions(BonemealEvent event) {
        for (BlockDefinition blockDefinition : BlockDefinitionReloadListener.DEFINITIONS) {
            if (!blockDefinition.matches(event.getBlock()) || blockDefinition.boneMealFailChance == null || !(event.getLevel().f_46441_.m_188501_() < blockDefinition.boneMealFailChance.floatValue())) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    private void failFromSeason(BonemealEvent event) {
        String[] seasonSplit;
        if (seasonFailChance.isEmpty() || !ModList.get().isLoaded("sereneseasons") || BoneMeal.isFullyGrown(event.getBlock())) {
            return;
        }
        for (String seasonChance : seasonSplit = seasonFailChance.split(";")) {
            String[] chanceSplit = seasonChance.split(",");
            if (chanceSplit.length != 2) continue;
            Season season = Season.valueOf((String)chanceSplit[0]);
            float chance = Float.parseFloat(chanceSplit[1]);
            if (!SeasonHelper.getSeasonState((Level)event.getLevel()).getSeason().equals((Object)season) || !(event.getLevel().f_46441_.m_188501_() < chance)) continue;
            event.setResult(Event.Result.ALLOW);
            break;
        }
    }

    private void applyNerfedBoneMeal(BonemealEvent event) {
        BlockState state = event.getBlock();
        Block block = state.m_60734_();
        if (block instanceof BushBlock) {
            BushBlock bushBlock = (BushBlock)block;
            Optional<IntegerProperty> oAgeProperty = BoneMeal.getAgeProperty(state);
            if (oAgeProperty.isEmpty()) {
                InsaneSurvivalOverhaul.LOGGER.debug("No vanilla age property found for state %s".formatted(state));
                return;
            }
            int age = (Integer)state.m_61143_((Property)oAgeProperty.get());
            int maxAge = AGE_PROPERTIES.get(oAgeProperty.get());
            if (ModList.get().isLoaded("supplementaries") && !SupplementariesIntegration.shouldBoneMeal(event.getLevel(), event.getPos(), event.getBlock())) {
                event.setCanceled(true);
                return;
            }
            if (ModList.get().isLoaded("farmersdelight") && !FarmersDelightIntegration.shouldBoneMeal(event.getLevel(), event.getPos(), event.getBlock())) {
                event.setCanceled(true);
                return;
            }
            if (age == maxAge) {
                return;
            }
            age = Mth.m_14045_((int)(age + stageGrowth.getIntRandBetween(event.getLevel().f_46441_)), (int)0, (int)maxAge);
            event.getLevel().m_46597_(event.getPos(), (BlockState)state.m_61124_((Property)oAgeProperty.get(), (Comparable)Integer.valueOf(age)));
            if (state.m_60734_() instanceof StemBlock && age == maxAge) {
                state.m_222972_((ServerLevel)event.getLevel(), event.getPos(), event.getLevel().f_46441_);
            }
            if (ModList.get().isLoaded("farmersdelight")) {
                FarmersDelightIntegration.onBoneMeal(event.getLevel(), event.getPos(), state, oAgeProperty.get(), age);
            }
            if (ModList.get().isLoaded("supplementaries")) {
                SupplementariesIntegration.onBoneMeal(event.getLevel(), event.getPos(), state, oAgeProperty.get(), age);
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    private void tryBoneMealDirt(BonemealEvent event, Level level, BlockState state, BlockPos pos) {
        if (!state.m_60713_(Blocks.f_50493_) || !level.m_8055_(pos.m_7494_()).m_60795_()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || direction == Direction.DOWN || !level.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_50440_)) continue;
            level.m_46597_(pos, Blocks.f_50440_.m_49966_());
            event.getEntity().m_21011_(event.getEntity().m_21205_().m_41720_() == event.getStack().m_41720_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
            event.setResult(Event.Result.ALLOW);
            break;
        }
    }

    private void tryBoneMealCanesAndCactus(BonemealEvent event, Level level, BlockState state, BlockPos pos) {
        if (!state.m_60713_(Blocks.f_50130_) && !state.m_60713_(Blocks.f_50128_)) {
            return;
        }
        if (!level.m_46859_(pos.m_7494_())) {
            return;
        }
        int growthAmount = boneMealCanesAndCactus.getIntRandBetween(level.f_46441_);
        if (growthAmount == 0) {
            return;
        }
        IntegerProperty ageProperty = state.m_60713_(Blocks.f_50130_) ? SugarCaneBlock.f_57164_ : CactusBlock.f_51131_;
        int height = 1;
        while (level.m_8055_(pos.m_6625_(height)).m_60713_(Blocks.f_50130_) || level.m_8055_(pos.m_6625_(height)).m_60713_(Blocks.f_50128_)) {
            ++height;
        }
        if (height >= 3) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)ageProperty);
        if ((age += growthAmount) >= 15) {
            level.m_46597_(pos.m_7494_(), state.m_60734_().m_49966_());
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(age - 15)), 4);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(age)), 4);
        }
        event.getEntity().m_21011_(event.getEntity().m_21205_().m_41720_() == event.getStack().m_41720_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
        event.setResult(Event.Result.ALLOW);
    }

    public static Optional<IntegerProperty> getAgeProperty(BlockState state) {
        Optional<IntegerProperty> oAgeProperty;
        for (Map.Entry<IntegerProperty, Integer> ageProperty : AGE_PROPERTIES.entrySet()) {
            if (!state.m_61138_((Property)ageProperty.getKey())) continue;
            return Optional.of(ageProperty.getKey());
        }
        if (ModList.get().isLoaded("farmersdelight") && (oAgeProperty = FarmersDelightIntegration.getAgeProperty(state)).isPresent()) {
            return oAgeProperty;
        }
        return Optional.empty();
    }

    public static boolean isFullyGrown(BlockState state) {
        for (Map.Entry<IntegerProperty, Integer> ageProperty : AGE_PROPERTIES.entrySet()) {
            if (!state.m_61138_((Property)ageProperty.getKey()) || !((Integer)state.m_61143_((Property)ageProperty.getKey())).equals(ageProperty.getValue())) continue;
            return true;
        }
        return false;
    }
}

