/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.bonemeal;

import insane96mcp.iguanatweaksreborn.module.farming.bonemeal.BoneMeal;
import insane96mcp.iguanatweaksreborn.module.farming.crops.Crops;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class RichFarmlandBlock
extends FarmBlock {
    public static final IntegerProperty RICHNESS = IntegerProperty.m_61631_((String)"richness", (int)0, (int)7);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_RICHNESS = 7;

    public RichFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0))).m_61124_((Property)RICHNESS, (Comparable)Integer.valueOf(7)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            RichFarmlandBlock.m_269406_(null, (BlockState)state, (Level)level, (BlockPos)pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.m_61143_((Property)f_53243_);
        boolean isUnderCrops = RichFarmlandBlock.isUnderCrops((BlockGetter)level, pos);
        if (!RichFarmlandBlock.m_53258_((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (moisture > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else {
                RichFarmlandBlock.turnToFarmland(null, state, (Level)level, pos);
            }
        } else if (moisture < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
        if (moisture == 7 && isUnderCrops) {
            for (int e = 0; e < BoneMeal.richFarmlandExtraTicks; ++e) {
                level.m_8055_(pos.m_7494_()).m_222972_(level, pos.m_7494_(), random);
            }
            level.m_46796_(2005, pos.m_7494_(), 0);
        }
        if (random.m_188500_() < BoneMeal.richFarmlandChanceToDecay) {
            RichFarmlandBlock.loseRichness(null, state, (Level)level, pos);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_121945_(facing));
        return type == PlantType.CROP || type == PlantType.PLAINS;
    }

    public static void turnToFarmland(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState farmland = (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)f_53243_, (Comparable)((Integer)state.m_61143_((Property)f_53243_)));
        level.m_46597_(pos, farmland);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)farmland));
    }

    public static void loseRichness(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        int richness = (Integer)state.m_61143_((Property)RICHNESS);
        if (richness == 0) {
            RichFarmlandBlock.turnToFarmland(entity, state, level, pos);
        } else {
            BlockState newState = (BlockState)((BlockState)((Block)BoneMeal.RICH_FARMLAND.block().get()).m_49966_().m_61124_((Property)f_53243_, (Comparable)((Integer)state.m_61143_((Property)f_53243_)))).m_61124_((Property)RICHNESS, (Comparable)Integer.valueOf(richness - 1));
            level.m_46597_(pos, newState);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)newState));
        }
    }

    private static boolean isUnderCrops(BlockGetter p_53251_, BlockPos p_53252_) {
        BlockState plant = p_53251_.m_8055_(p_53252_.m_7494_());
        BlockState state = p_53251_.m_8055_(p_53252_);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(p_53251_, p_53252_, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean m_53258_(LevelReader p_53259_, BlockPos p_53260_) {
        BlockState state = p_53259_.m_8055_(p_53260_);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_53260_.m_7918_(-Crops.getWaterHydrationRadius(), 0, -Crops.getWaterHydrationRadius()), (BlockPos)p_53260_.m_7918_(Crops.getWaterHydrationRadius(), 1, Crops.getWaterHydrationRadius()))) {
            if (!state.canBeHydrated((BlockGetter)p_53259_, p_53260_, p_53259_.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_53259_, (BlockPos)p_53260_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_53243_, RICHNESS});
    }
}

