/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.crops;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.iguanatweaksreborn.module.farming.crops.SeedsBlockItem;
import insane96mcp.iguanatweaksreborn.module.farming.crops.WildCropBlock;
import insane96mcp.iguanatweaksreborn.module.farming.crops.integration.FarmersDelightIntegration;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Crops", description="Crops tweaks and less yield from crops")
@LoadFeature(module="iguanatweaksreborn:farming")
public class Crops
extends Feature {
    public static final TagKey<Item> CHICKEN_FOOD_ITEMS = ISOItemTagsProvider.create("chicken_food_items");
    public static final TagKey<Block> HARDER_CROPS_TAG = ISOBlockTagsProvider.create("harder_crops");
    public static final RegistryObject<BlockItem> ROOTED_POTATO = ISORegistries.ITEMS.register("rooted_potato", () -> new SeedsBlockItem(Blocks.f_50250_, new Item.Properties()));
    public static final RegistryObject<BlockItem> CARROT_SEEDS = ISORegistries.ITEMS.register("carrot_seeds", () -> new SeedsBlockItem(Blocks.f_50249_, new Item.Properties()));
    public static final RegistryObject<BlockItem> ROOTED_ONION = ISORegistries.ITEMS.register("rooted_onion", () -> new SeedsBlockItem(ModList.get().isLoaded("farmersdelight") ? FarmersDelightIntegration.getOnion() : Blocks.f_50250_, new Item.Properties()));
    public static final RegistryObject<BlockItem> RICE_SEEDS = ISORegistries.ITEMS.register("rice_seeds", () -> new SeedsBlockItem(ModList.get().isLoaded("farmersdelight") ? FarmersDelightIntegration.getRice() : Blocks.f_50250_, new Item.Properties()));
    public static final RegistryObject<WildCropBlock> WILD_WHEAT = ISORegistries.BLOCKS.register("wild_wheat", () -> new WildCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60913_(0.8f, 0.0f)));
    public static final RegistryObject<WildCropBlock> WILD_CARROTS = ISORegistries.BLOCKS.register("wild_carrots", () -> new WildCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60913_(0.8f, 0.0f)));
    public static final RegistryObject<WildCropBlock> WILD_POTATOES = ISORegistries.BLOCKS.register("wild_potatoes", () -> new WildCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60913_(0.8f, 0.0f)));
    public static final RegistryObject<WildCropBlock> WILD_BEETROOTS = ISORegistries.BLOCKS.register("wild_beetroots", () -> new WildCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60913_(0.8f, 0.0f)));
    public static final SimpleBlockWithItem SOLANUM_NEOROSSII = SimpleBlockWithItem.register("solanum_neorossii", () -> new FlowerBlock(() -> MobEffects.f_19596_, 10, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ)));
    public static final RegistryObject<Block> POTTED_SOLANUM_NEOROSSII = ISORegistries.BLOCKS.register("potted_solanum_neorossii", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> (Block)SOLANUM_NEOROSSII.block().get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50235_)));
    @Config
    @Label(name="Crops Require Water", description="Set if crops require wet farmland to grow.\nValid Values:\nNO: Crops will not require water to grow\nBONE_MEAL_ONLY: Crops will grow on dry farmland by only using bone meal\nANY_CASE: Will make Crops not grow in any case when on dry farmland")
    public static CropsRequireWater cropsRequireWater = CropsRequireWater.ANY_CASE;
    @Config(min=1.0)
    @Label(name="Water Hydration Radius", description="Radius where water hydrates farmland, vanilla is 4.")
    public static Integer waterHydrationRadius = 2;
    @Config
    @Label(name="Crops data pack", description="Makes potatoes and carrots not plantable and also enables a data pack that makes the following changes:\n* Makes all vanilla crops drop only one seed (and makes carrots and potatoes drop the new seed item)\n* Makes melon seeds and pumpkin seeds harder to obtain\n* Removes carrots and potato drops from zombies\n* Removes wheat seeds from tall grass\n* Makes wild crops generate in the world")
    public static Boolean dataPack = true;

    public Crops(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("crops", "Insane's Survival Overhaul Crops", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && dataPack != false);
    }

    @SubscribeEvent
    public void cropsRequireWater(BlockEvent.CropGrowEvent.Pre event) {
        if (!this.isEnabled() || cropsRequireWater.equals((Object)CropsRequireWater.NO) || event.getResult().equals((Object)Event.Result.DENY) || !Crops.isAffectedByFarmland(event.getLevel(), event.getPos())) {
            return;
        }
        if (Crops.isCropOnFarmland(event.getLevel(), event.getPos()) && !Crops.isCropOnWetFarmland(event.getLevel(), event.getPos())) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static boolean requiresWetFarmland(Level level, BlockPos blockPos) {
        return Crops.isEnabled(Crops.class) && !cropsRequireWater.equals((Object)CropsRequireWater.NO) && Crops.isAffectedByFarmland((LevelAccessor)level, blockPos);
    }

    public static boolean hasWetFarmland(Level level, BlockPos blockPos) {
        return Crops.isCropOnFarmland((LevelAccessor)level, blockPos) && Crops.isCropOnWetFarmland((LevelAccessor)level, blockPos);
    }

    public static boolean isAffectedByFarmland(LevelAccessor levelAccessor, BlockPos cropPos) {
        BlockState state = levelAccessor.m_8055_(cropPos);
        Block block = state.m_60734_();
        return block instanceof CropBlock || block instanceof StemBlock;
    }

    public static boolean isCropOnWetFarmland(LevelAccessor levelAccessor, BlockPos cropPos) {
        BlockState sustainState = levelAccessor.m_8055_(cropPos.m_7495_());
        if (!(sustainState.m_60734_() instanceof FarmBlock)) {
            return false;
        }
        int moisture = (Integer)sustainState.m_61143_((Property)FarmBlock.f_53243_);
        return moisture >= 7;
    }

    public static boolean isCropOnFarmland(LevelAccessor levelAccessor, BlockPos cropPos) {
        BlockState sustainState = levelAccessor.m_8055_(cropPos.m_7495_());
        return sustainState.m_60734_() instanceof FarmBlock;
    }

    @SubscribeEvent
    public void onTryToPlant(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersDelightIntegration.tryAlertRice(event);
        }
        if (!(event.getLevel().m_8055_(event.getHitVec().m_82425_()).m_60734_() instanceof FarmBlock) || !dataPack.booleanValue()) {
            return;
        }
        if (event.getItemStack().m_150930_(Items.f_42620_) || event.getItemStack().m_150930_(Items.f_42619_)) {
            event.setCanceled(true);
        }
        if (ModList.get().isLoaded("farmersdelight") && FarmersDelightIntegration.preventPlanting(event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChickenJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Chicken)) {
            return;
        }
        Chicken chicken = (Chicken)entity;
        chicken.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)chicken, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CARROT_SEEDS.get()}), false));
    }

    @SubscribeEvent
    public void onTryToSeedChickens(PlayerInteractEvent.EntityInteract event) {
        Chicken chicken;
        Entity entity;
        if (!(this.isEnabled() && dataPack.booleanValue() && (entity = event.getTarget()) instanceof Chicken && (chicken = (Chicken)entity).m_6898_(event.getItemStack()) && !event.getItemStack().m_204117_(CHICKEN_FOOD_ITEMS))) {
            return;
        }
        event.setCanceled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPickBlock(InputEvent.InteractionKeyMappingTriggered event) {
        if (!this.isEnabled() || !event.getKeyMapping().m_90850_(Minecraft.m_91087_().f_91066_.f_92097_) || Minecraft.m_91087_().f_91077_ == null || Minecraft.m_91087_().f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean isCreative = mc.f_91074_.m_150110_().f_35937_;
        HitResult hitResult = mc.f_91077_;
        BlockPos blockpos = ((BlockHitResult)hitResult).m_82425_();
        BlockState blockstate = mc.f_91073_.m_8055_(blockpos);
        if (blockstate.m_60795_()) {
            return;
        }
        Block block = blockstate.m_60734_();
        ItemStack stack = null;
        if (block == Blocks.f_50249_) {
            stack = new ItemStack((ItemLike)CARROT_SEEDS.get());
        } else if (block == Blocks.f_50250_) {
            stack = new ItemStack((ItemLike)ROOTED_POTATO.get());
        } else if (ModList.get().isLoaded("farmersdelight")) {
            stack = FarmersDelightIntegration.tryPickBlock(block);
        }
        if (stack == null) {
            return;
        }
        Inventory inventory = mc.f_91074_.m_150109_();
        int i = inventory.m_36030_(stack);
        if (isCreative) {
            inventory.m_36012_(stack);
            mc.f_91072_.m_105241_(mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND), 36 + inventory.f_35977_);
        } else if (i != -1) {
            if (Inventory.m_36045_((int)i)) {
                inventory.f_35977_ = i;
            } else {
                mc.f_91072_.m_105206_(i);
            }
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCropBreaking(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || event.getState().f_60599_ == 0.0f || !event.getState().m_204336_(HARDER_CROPS_TAG)) {
            return;
        }
        ItemStack heldStack = event.getEntity().m_21205_();
        Item item = heldStack.m_41720_();
        if (!(item instanceof DiggerItem)) {
            return;
        }
        DiggerItem diggerItem = (DiggerItem)item;
        if (!diggerItem.canPerformAction(heldStack, ToolActions.HOE_DIG) && !diggerItem.canPerformAction(heldStack, ToolActions.AXE_DIG)) {
            return;
        }
        float miningSpeed = diggerItem.f_40980_;
        if (miningSpeed > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.m_44926_((LivingEntity)event.getEntity());
            ItemStack itemstack = event.getEntity().m_21205_();
            if (efficiencyLevel > 0 && !itemstack.m_41619_()) {
                miningSpeed += EnchantmentsFeature.getEfficiencyBonus(miningSpeed, efficiencyLevel);
            }
        }
        if (diggerItem.canPerformAction(heldStack, ToolActions.HOE_DIG)) {
            event.setNewSpeed(event.getNewSpeed() * miningSpeed);
        } else {
            event.setNewSpeed(event.getNewSpeed() / 5.0f);
        }
    }

    public static int getWaterHydrationRadius() {
        return Crops.isEnabled(Crops.class) ? waterHydrationRadius : 4;
    }

    public static enum CropsRequireWater {
        NO,
        BONE_MEAL_ONLY,
        ANY_CASE;

    }
}

