/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.hoes;

import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinition;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinitionsReloadListener;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Hoes", description="Hoes can now scythe grass and flowers. Also makes them break faster when tilling farmland")
@LoadFeature(module="iguanatweaksreborn:farming")
public class Hoes
extends Feature {
    public static final String TOO_WEAK = "iguanatweaksreborn.weak_hoe";
    public static final String SCYTHE_RADIUS = "iguanatweaksreborn.scythe_radius";
    public static final TagKey<Block> CAN_SCYTHE = ISOBlockTagsProvider.create("can_scythe");
    public static final TagKey<Item> DISABLED_HOES = ISOItemTagsProvider.create("disabled_hoes");
    @Config(min=1.0)
    @Label(name="Durability used on right-click")
    public static Integer durabilityOnRightClick = 4;
    @Config
    @Label(name="Extra durability only for tilling", description="'Durability used on right-click' is only applied for farmland, and not e.g. when using hoes on rooted dirt")
    public static Boolean extraDurabilityOnlyForTilling = true;

    public Hoes(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onHoeUse(BlockEvent.BlockToolModificationEvent event) {
        if (!this.isEnabled() || event.getPlayer() == null || event.isSimulated() || event.getToolAction() != ToolActions.HOE_TILL) {
            return;
        }
        boolean isHoeDisabled = this.disabledHoes(event);
        if (event.getPlayer() != null && event.getPlayer().m_9236_().f_46443_) {
            return;
        }
        BlockState finalState = event.getState().m_60734_().getToolModifiedState(event.getState(), event.getContext(), event.getToolAction(), true);
        if (finalState == null || !finalState.m_60713_(Blocks.f_50093_) && extraDurabilityOnlyForTilling.booleanValue()) {
            return;
        }
        if (!isHoeDisabled && durabilityOnRightClick > 1) {
            event.getHeldItemStack().m_41622_(durabilityOnRightClick - 1, (LivingEntity)event.getPlayer(), livingEntity -> livingEntity.m_21190_(livingEntity.m_7655_()));
        }
    }

    public boolean disabledHoes(BlockEvent.BlockToolModificationEvent event) {
        if (!event.getHeldItemStack().m_204117_(DISABLED_HOES)) {
            return false;
        }
        event.getPlayer().m_5661_((Component)Component.m_237115_((String)TOO_WEAK), true);
        event.setCanceled(true);
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!this.isEnabled() || event.getState().f_60599_ > 0.0f || !event.getState().m_204336_(CAN_SCYTHE)) {
            return;
        }
        for (ItemDefinition itemDefinition : ItemDefinitionsReloadListener.getDefinitions()) {
            int radius;
            if (!itemDefinition.matches(event.getPlayer().m_21205_()) || itemDefinition.scytheRadius() == null || (radius = itemDefinition.scytheRadius().intValue()) == 0) continue;
            BlockPos.m_121990_((BlockPos)event.getPos().m_7918_(-radius, -(radius - 1), -radius), (BlockPos)event.getPos().m_7918_(radius, radius - 1, radius)).forEach(pos -> {
                BlockState state = event.getPlayer().m_9236_().m_8055_(pos);
                if (!state.m_204336_(CAN_SCYTHE) || state.f_60599_ > 0.0f || pos.equals((Object)event.getPos())) {
                    return;
                }
                state.m_60734_().m_5707_(event.getPlayer().m_9236_(), pos, state, event.getPlayer());
                if (state.m_60734_().canHarvestBlock(state, (BlockGetter)event.getPlayer().m_9236_(), pos, event.getPlayer())) {
                    state.m_60734_().m_6240_(event.getPlayer().m_9236_(), event.getPlayer(), pos, state, null, event.getPlayer().m_21205_());
                }
                event.getLevel().m_46961_(pos, false);
                event.getLevel().m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getItemStack().m_204117_(DISABLED_HOES)) {
            event.getToolTip().add(Component.m_237115_((String)TOO_WEAK).m_130940_(ChatFormatting.RED));
        } else {
            for (ItemDefinition itemDefinition : ItemDefinitionsReloadListener.getDefinitions()) {
                int radius;
                if (!itemDefinition.matches(event.getItemStack().m_41720_())) continue;
                int n = radius = itemDefinition.scytheRadius() == null ? 0 : itemDefinition.scytheRadius();
                if (radius == 0) continue;
                event.getToolTip().add(CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)SCYTHE_RADIUS, (Object[])new Object[]{radius}).m_130940_(ChatFormatting.DARK_GREEN)));
                break;
            }
        }
    }
}

