/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.livestock;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.modifier.Modifier;
import insane96mcp.iguanatweaksreborn.module.experience.DroppedExperience;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.ISOEatBlock;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.LivestockData;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.LivestockDataReloadListener;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.PehkuiIntegration;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.network.message.ForgeDataIntSync;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.ModList;

@Label(name="Livestock", description="Slower breeding, Growing, Egging and Milking. Lower yield.")
@LoadFeature(module="iguanatweaksreborn:farming")
public class Livestock
extends Feature {
    public static final TagKey<EntityType<?>> MILKABLE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("iguanatweaksreborn", "milkable"));
    public static final TagKey<EntityType<?>> PREVENT_BREEDING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("iguanatweaksreborn", "prevent_breeding"));
    public static final String MILK_COOLDOWN_LANG = "iguanatweaksreborn.milk_cooldown";
    public static final String MILK_COOLDOWN = "iguanatweaksreborn:milk_cooldown";
    public static final String LAST_FED = "iguanatweaksreborn:last_fed";
    public static ResourceKey<DamageType> OLD_AGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("iguanatweaksreborn", "old_age"));
    @Config
    @Label(name="Chicken from egg chance", description="Changes the chance for a chicken to come out from an egg (1 in this value). Vanilla is 8")
    public static Integer chickenFromEggChance = 8;
    @Config
    @Label(name="Milk Cooldown", description="Seconds until you can milk cows (or stew mooshrooms)")
    public static Integer milkingCooldown = 1200;
    @Config
    @Label(description="If true, animals will no longer be able to be bred manually. Only animals in iguanatweaksreborn:prevent_breeding will be affected by this.")
    public static Boolean preventBreeding = true;
    @Config
    @Label(name="Aging.Enable", description="If true, animals will age and die of old age. Configurable via data packs. With the data pack enabled, adult will drop more goodies. With pehkui installed, animals will also be smaller/bigger.")
    public static Boolean agingEnable = true;
    @Config
    @Label(name="Aging.Die of old age", description="If true, animals die of old age.")
    public static Boolean agingDieOfOldAge = true;
    @Config
    @Label(name="Aging.Stop at", description="If Die of old age is disabled you can still make animals grow up to this age")
    public static Age agingStopAt = Age.ELDER;
    @Config(min=0.0)
    @Label(name="Aging.Starvation death", description="If true, animals will die if not young and haven't been fed in a while.")
    public static Boolean agingStarvationDeath = false;
    @Config(min=0.0)
    @Label(name="Aging.Last fed duration", description="How long (in minutes) will an animal remain marked as fed after eating?")
    public static Integer agingLastFedDuration = 60;
    @Config
    @Label(name="Data Pack", description="Enables a data pack that changes animal loot (reduced food drops) and slows down growing, breeding, egging etc")
    public static Boolean dataPack = true;

    public Livestock(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("livestock_changes", "Livestock Changes", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && dataPack != false);
    }

    @SubscribeEvent
    public void onSheepJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)entity;
        sheep.f_21345_.m_25363_((Goal)sheep.f_29803_);
        sheep.f_29803_ = new ISOEatBlock((Mob)sheep);
        sheep.f_21345_.m_25352_(5, (Goal)sheep.f_29803_);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            Livestock.slowdownAnimalGrowth(event);
            Livestock.slowdownBreeding(event);
            Livestock.aging(event);
            Livestock.eggLay(event);
            Livestock.tryAutoBreed(event);
            if (Livestock.hasBeenFedRecently(event.getEntity()) && event.getEntity().m_217043_().m_188503_(200) == 0) {
                ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)(event.getEntity().m_20206_() / 1.5f), event.getEntity().m_20189_(), 5, 0.25, 0.25, 0.25, (double)0.2f);
            }
        }
        this.cowMilkTick(event);
    }

    public static double getRandomXWithin(LivingEntity entity, double delta) {
        return Livestock.getRandomValueInWidth(entity, delta) + entity.m_20185_();
    }

    public static double getRandomZWithin(LivingEntity entity, double delta) {
        return Livestock.getRandomValueInWidth(entity, delta) + entity.m_20189_();
    }

    public static double getRandomValueInWidth(LivingEntity entity, double delta) {
        return Mth.m_216263_((RandomSource)entity.m_217043_(), (double)((double)(-entity.m_20205_()) - delta), (double)((double)entity.m_20205_() + delta));
    }

    public static void tryAutoBreed(LivingEvent.LivingTickEvent event) {
        Animal animal;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Animal) || !(animal = (Animal)livingEntity).m_5957_() || animal.m_146764_() != 0) {
            return;
        }
        if ((event.getEntity().f_19797_ + event.getEntity().m_19879_()) % 600 != 0) {
            return;
        }
        if (event.getEntity().m_9236_().m_6249_((Entity)event.getEntity(), animal.m_20191_().m_82400_(16.0), entity -> entity.m_6095_() == animal.m_6095_()).size() > 16) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)animal)).forEach(data -> modifiersToApply.addAll(data.autoBreedChanceModifiers));
        float chance = Modifier.applyModifiers(0.0f, modifiersToApply, animal.m_9236_(), animal.m_20183_(), (LivingEntity)animal);
        if ((double)chance <= 0.0 || animal.m_217043_().m_188501_() >= chance) {
            return;
        }
        animal.m_27595_(null);
    }

    public static boolean canSheepRegrowWool(Mob mob) {
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)mob)).forEach(data -> modifiersToApply.addAll(data.sheepWoolGrowthChanceModifiers));
        float chance = Modifier.applyModifiers(1.0f, modifiersToApply, mob.m_9236_(), mob.m_20183_(), (LivingEntity)mob);
        if ((double)chance >= 1.0) {
            return true;
        }
        return mob.m_217043_().m_188501_() < chance;
    }

    public static void aging(LivingEvent.LivingTickEvent event) {
        Age prevAge;
        AgeableMob ageableMob;
        LivingEntity livingEntity;
        if (!agingEnable.booleanValue() || !((livingEntity = event.getEntity()) instanceof AgeableMob) || ((ageableMob = (AgeableMob)livingEntity).m_9236_().m_7654_().m_129921_() + ageableMob.m_19879_()) % 20 != 0 || ageableMob.m_6162_()) {
            return;
        }
        boolean forceUpdateScale = false;
        int age = ageableMob.getPersistentData().m_128451_("iguanatweaksreborn:age");
        int maxAge = ageableMob.getPersistentData().m_128451_("iguanatweaksreborn:max_age");
        if (maxAge == 0) {
            for (LivestockData data : LivestockDataReloadListener.LIVESTOCK_DATA) {
                if (!data.matches((Entity)ageableMob) || data.livingDays == null) continue;
                maxAge = (int)(data.getLivingDays((LivingEntity)ageableMob) * 20.0f * 60.0f);
                ageableMob.getPersistentData().m_128405_("iguanatweaksreborn:max_age", maxAge);
                break;
            }
            if (maxAge == 0) {
                return;
            }
            forceUpdateScale = true;
        }
        if ((prevAge = Livestock.getAge(ageableMob)) == agingStopAt && !agingDieOfOldAge.booleanValue()) {
            return;
        }
        ++age;
        Age newAge = Livestock.getAge(ageableMob);
        if (agingStarvationDeath.booleanValue() && newAge != Age.YOUNG && !Livestock.hasBeenFedRecently((LivingEntity)ageableMob)) {
            ageableMob.m_6469_(ageableMob.m_269291_().m_269064_(), Float.MAX_VALUE);
        }
        if (newAge == Age.ELDER) {
            MCUtils.applyModifier((LivingEntity)ageableMob, (Attribute)Attributes.f_22279_, (UUID)UUID.fromString("e2083ae7-e37a-47c4-ab3e-84cf14fe6b6c"), (String)"Old animal modifier", (double)-0.35, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
        if (age >= maxAge) {
            if (agingDieOfOldAge.booleanValue()) {
                ageableMob.m_6469_(ageableMob.m_269291_().m_269298_(OLD_AGE, null), Float.MAX_VALUE);
            }
            return;
        }
        if (ModList.get().isLoaded("pehkui") && ((ageableMob.m_9236_().m_7654_().m_129921_() + ageableMob.m_19879_()) % 100 == 0 || forceUpdateScale)) {
            PehkuiIntegration.setSize((LivingEntity)ageableMob, newAge);
        }
        ageableMob.getPersistentData().m_128405_("iguanatweaksreborn:age", age);
    }

    public static float getAgeRatio(AgeableMob mob) {
        return (float)mob.getPersistentData().m_128451_("iguanatweaksreborn:age") / (float)mob.getPersistentData().m_128451_("iguanatweaksreborn:max_age");
    }

    public static Age getAge(AgeableMob mob) {
        float ratio = Livestock.getAgeRatio(mob);
        if (ratio < 0.3f) {
            return Age.YOUNG;
        }
        if (ratio < 0.7f) {
            return Age.ADULT;
        }
        return Age.ELDER;
    }

    public static void slowdownAnimalGrowth(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AgeableMob)) {
            return;
        }
        AgeableMob mob = (AgeableMob)livingEntity;
        int growingAge = mob.m_146764_();
        if (growingAge >= 0) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)mob)).forEach(data -> modifiersToApply.addAll(data.growthSpeedModifiers));
        float chanceToSlowDown = Modifier.applyModifiers(0.0f, modifiersToApply, mob.m_9236_(), mob.m_20183_(), (LivingEntity)mob);
        if ((double)chanceToSlowDown <= 1.0) {
            return;
        }
        double chance = 1.0 / (double)chanceToSlowDown;
        if ((double)mob.m_217043_().m_188501_() > chance) {
            mob.m_146762_(growingAge - 1);
        }
    }

    public static void slowdownBreeding(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AgeableMob)) {
            return;
        }
        AgeableMob mob = (AgeableMob)livingEntity;
        int growingAge = mob.m_146764_();
        if (growingAge <= 0) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)mob)).forEach(data -> modifiersToApply.addAll(data.breedingCooldownModifiers));
        float chanceToSlowDown = Modifier.applyModifiers(0.0f, modifiersToApply, mob.m_9236_(), mob.m_20183_(), (LivingEntity)mob);
        if ((double)chanceToSlowDown <= 1.0) {
            return;
        }
        double chance = 1.0 / (double)chanceToSlowDown;
        if ((double)mob.m_217043_().m_188501_() > chance) {
            mob.m_146762_(growingAge + 1);
        }
    }

    public static void eggLay(LivingEvent.LivingTickEvent event) {
        Chicken chicken;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Chicken) || (chicken = (Chicken)livingEntity).m_6162_()) {
            return;
        }
        if (chicken.f_28231_ < 0) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)chicken)).forEach(data -> modifiersToApply.addAll(data.eggLayCooldownModifiers));
        float chanceToSlowDown = Modifier.applyModifiers(0.0f, modifiersToApply, chicken.m_9236_(), chicken.m_20183_(), (LivingEntity)chicken);
        if ((double)chanceToSlowDown <= 1.0) {
            return;
        }
        double chance = 1.0 / (double)chanceToSlowDown;
        if ((double)chicken.m_217043_().m_188501_() > chance) {
            ++chicken.f_28231_;
        }
    }

    public void cowMilkTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().f_19797_ % 20 != 0 || !((livingEntity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)livingEntity;
        CompoundTag cowNBT = animal.getPersistentData();
        int milkCooldown = cowNBT.m_128451_(MILK_COOLDOWN);
        if (milkCooldown > 0) {
            milkCooldown -= 20;
        }
        cowNBT.m_128405_(MILK_COOLDOWN, milkCooldown);
    }

    @SubscribeEvent
    public void onAnimalFeed(PlayerInteractEvent.EntityInteract event) {
        Animal animal;
        Entity entity;
        if (!(!event.isCanceled() && this.isEnabled() && (entity = event.getTarget()) instanceof Animal && (animal = (Animal)entity).m_6095_().m_204039_(PREVENT_BREEDING) && animal.m_6898_(event.getItemStack()))) {
            return;
        }
        if (!Livestock.canBeFed((LivingEntity)animal)) {
            event.setCanceled(true);
            return;
        }
        int age = animal.m_146764_();
        if (!animal.m_9236_().f_46443_ && age == 0 && animal.m_5957_()) {
            Livestock.setLastEat((LivingEntity)animal);
        }
    }

    public static void setLastEat(LivingEntity living) {
        living.getPersistentData().m_128356_(LAST_FED, living.m_9236_().m_46467_());
    }

    public static boolean hasBeenFedRecently(LivingEntity living) {
        long lastFed = living.getPersistentData().m_128454_(LAST_FED);
        return lastFed > 0L && living.m_9236_().m_46467_() - lastFed < (long)(agingLastFedDuration * 60 * 20);
    }

    public static boolean canBeFed(LivingEntity living) {
        long lastFed = living.getPersistentData().m_128454_(LAST_FED);
        if (lastFed == 0L) {
            return true;
        }
        return (float)(living.m_9236_().m_46467_() - lastFed) > (float)agingLastFedDuration.intValue() / 2.0f * 60.0f * 20.0f;
    }

    public static void consumeFeed(LivingEntity living) {
        long lastFed = living.getPersistentData().m_128454_(LAST_FED);
        if (lastFed > 0L) {
            lastFed -= (long)((float)agingLastFedDuration.intValue() / 3.0f * 60.0f * 20.0f);
        }
        living.getPersistentData().m_128356_(LAST_FED, lastFed);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAnimalMilk(PlayerInteractEvent.EntityInteract event) {
        Animal animal;
        Entity entity;
        if (!this.isEnabled() || !event.getTarget().m_6095_().m_204039_(MILKABLE) || (entity = event.getTarget()) instanceof Animal && (animal = (Animal)entity).m_146764_() < 0 || !((entity = event.getTarget()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack equipped = player.m_21120_(hand);
        if (equipped.m_41619_() || equipped.m_41720_() == Items.f_41852_) {
            return;
        }
        Item item = equipped.m_41720_();
        if (!(FluidUtil.getFluidHandler((ItemStack)equipped).isPresent() && FluidStack.loadFluidStackFromNBT((CompoundTag)equipped.m_41783_()).isEmpty() || living instanceof MushroomCow && item == Items.f_42399_)) {
            return;
        }
        CompoundTag cowNBT = living.getPersistentData();
        int milkCooldown = cowNBT.m_128451_(MILK_COOLDOWN);
        if (milkCooldown > 0) {
            event.setCanceled(true);
            if (!player.m_9236_().f_46443_) {
                living.m_5496_(SoundEvents.f_11832_, 0.4f, (event.getEntity().m_9236_().f_46441_.m_188501_() - event.getEntity().m_9236_().f_46441_.m_188501_()) * 0.2f + 1.2f);
                MutableComponent message = Component.m_237110_((String)MILK_COOLDOWN_LANG, (Object[])new Object[]{living.m_5446_()});
                player.m_5661_((Component)message, true);
            } else {
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        } else if (!living.m_9236_().f_46443_) {
            ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
            LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)living)).forEach(data -> modifiersToApply.addAll(data.cowFluidCooldownModifiers));
            float cooldown = Modifier.applyModifiers(milkingCooldown.intValue(), modifiersToApply, living.m_9236_(), living.m_20183_(), living);
            DroppedExperience.tryGenerateMilkXp((Entity)living);
            if (cooldown <= 0.0f) {
                return;
            }
            milkCooldown = (int)(cooldown * 20.0f);
            cowNBT.m_128405_(MILK_COOLDOWN, milkCooldown);
            ForgeDataIntSync.sync(living, MILK_COOLDOWN, milkCooldown);
        }
    }

    @SubscribeEvent
    public void onEntityLoad(EntityJoinLevelEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).getPersistentData().m_128441_(MILK_COOLDOWN)) {
            return;
        }
        ForgeDataIntSync.sync(livingEntity, MILK_COOLDOWN, livingEntity.getPersistentData().m_128451_(MILK_COOLDOWN));
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        for (Entity entity : ((ServerLevel)event.getEntity().m_9236_()).m_142646_().m_142273_()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).getPersistentData().m_128441_(MILK_COOLDOWN)) continue;
            ForgeDataIntSync.sync((ServerPlayer)event.getEntity(), livingEntity, MILK_COOLDOWN, livingEntity.getPersistentData().m_128451_(MILK_COOLDOWN));
        }
    }

    @SubscribeEvent
    public void onBreed(BabyEntitySpawnEvent event) {
        Mob mob;
        if (!this.isEnabled() || !((mob = event.getParentA()) instanceof Animal)) {
            return;
        }
        Animal parentA = (Animal)mob;
        if (this.failBreeding(event, parentA)) {
            return;
        }
        this.twins(event, parentA);
        Livestock.consumeFeed((LivingEntity)parentA);
        Livestock.consumeFeed((LivingEntity)event.getParentB());
    }

    private boolean failBreeding(BabyEntitySpawnEvent event, Animal parentA) {
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)parentA)).forEach(data -> modifiersToApply.addAll(data.breedingFailChanceModifiers));
        float failChance = Modifier.applyModifiers(0.0f, modifiersToApply, parentA.m_9236_(), parentA.m_20183_(), (LivingEntity)parentA);
        if (failChance <= 0.0f) {
            return false;
        }
        if (failChance >= 1.0f || parentA.m_217043_().m_188501_() < failChance) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    private void twins(BabyEntitySpawnEvent event, Animal parentA) {
        ArrayList<Modifier> modifiersToApplyTwins = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)parentA)).forEach(data -> modifiersToApplyTwins.addAll(data.twinsChanceModifiers));
        float twinsChance = Modifier.applyModifiers(0.0f, modifiersToApplyTwins, parentA.m_9236_(), parentA.m_20183_(), (LivingEntity)parentA);
        if (parentA.m_217043_().m_188501_() < twinsChance && event.getParentB() instanceof Animal) {
            parentA.m_27563_((ServerLevel)parentA.m_9236_(), (Animal)event.getParentB());
        }
    }

    public static enum Age {
        YOUNG,
        ADULT,
        ELDER;

    }
}

