/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.plantsgrowth;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.module.farming.plantsgrowth.PlantGrowthMultiplier;
import insane96mcp.iguanatweaksreborn.module.farming.plantsgrowth.PlantsGrowthReloadListener;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Plants Growth", description="Slower Plants (non-crops) growing. Plants properties are controlled via json in this feature's folder")
@LoadFeature(module="iguanatweaksreborn:farming")
public class PlantsGrowth
extends Feature {
    @Config
    @Label(name="Huge mushrooms on Mycelium only")
    public static Boolean hugeMushroomsOnMyceliumOnly = true;
    @Config(min=0.0)
    @Label(name="Cave vines underground", description="If != 1, cave vines will grow this slower above sea level or if they can see the sky light")
    public static Double caveVinesUnderground = 3.0;
    @Config
    @Label(name="Plant growth multipliers data pack", description="If true, a data pack is enabled that changes the growth of plants based off various factors, such as sunlight and biome")
    public static Boolean plantGrowthMultipliersDataPack = true;

    public PlantsGrowth(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("plant_growth_modifiers", "Insane's Survival Overhaul Plant Growth modifiers", () -> super.isEnabled() && DataPacks.disableAllDataPacks == false && plantGrowthMultipliersDataPack != false);
    }

    @SubscribeEvent
    public void onCropGrowEvent(BlockEvent.CropGrowEvent.Pre event) {
        if (!this.isEnabled() || PlantsGrowthReloadListener.GROWTH_MULTIPLIERS.isEmpty()) {
            return;
        }
        double multiplier = 1.0;
        for (PlantGrowthMultiplier plantGrowthMultiplier : PlantsGrowthReloadListener.GROWTH_MULTIPLIERS) {
            multiplier *= (double)plantGrowthMultiplier.getMultiplier(event.getState(), (Level)event.getLevel(), event.getPos());
        }
        if (caveVinesUnderground != 1.0 && event.getLevel().m_8055_(event.getPos().m_7494_()).m_204336_(BlockTags.f_144275_) && (event.getLevel().m_5736_() > event.getPos().m_123342_() || event.getLevel().m_45517_(LightLayer.SKY, event.getPos()) > 0)) {
            multiplier *= caveVinesUnderground.doubleValue();
        }
        if (multiplier == 0.0) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (multiplier == 1.0) {
            return;
        }
        double chance = 1.0 / multiplier;
        if (event.getLevel().m_213780_().m_188500_() > chance) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onMushroomGrow(SaplingGrowTreeEvent event) {
        if (!this.isEnabled() || !hugeMushroomsOnMyceliumOnly.booleanValue() || event.getFeature() == null) {
            return;
        }
        if ((event.getFeature().m_203565_(TreeFeatures.f_195121_) || event.getFeature().m_203565_(TreeFeatures.f_195122_)) && !event.getLevel().m_8055_(event.getPos().m_7495_()).m_60713_(Blocks.f_50195_)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onMushroomGrow(BonemealEvent event) {
        if (!this.isEnabled() || !hugeMushroomsOnMyceliumOnly.booleanValue() || !event.getBlock().m_60713_(Blocks.f_50072_) && !event.getBlock().m_60713_(Blocks.f_50073_)) {
            return;
        }
        if (!event.getLevel().m_8055_(event.getPos().m_7495_()).m_60713_(Blocks.f_50195_)) {
            event.setCanceled(true);
        }
    }
}

