/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.hungerhealth.fooddrinks;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.ISOMobEffectInstance;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.combat.RegeneratingAbsorption;
import insane96mcp.iguanatweaksreborn.module.hungerhealth.fooddrinks.CustomFoodProperties;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.event.AddEatEffectEvent;
import insane96mcp.insanelib.event.CakeEatEvent;
import insane96mcp.insanelib.util.MCUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Foods & Drinks", description="Changes to food nourishment and the speed on how food is eaten or how items are consumed. Custom Food Properties are controlled via json in this feature's folder.")
@LoadFeature(module="iguanatweaksreborn:hunger_health")
public class FoodDrinks
extends JsonFeature {
    public static final RegistryObject<Item> BROWN_MUSHROOM_STEW = ISORegistries.ITEMS.register("brown_mushroom_stew", () -> new BowlFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(3).m_38758_(0.6f).m_38767_())));
    public static final RegistryObject<Item> RED_MUSHROOM_STEW = ISORegistries.ITEMS.register("red_mushroom_stew", () -> new BowlFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(3).m_38758_(0.6f).m_38767_())));
    public static final RegistryObject<Item> NETHERIZED_STEW = ISORegistries.ITEMS.register("netherized_stew", () -> new BowlFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(12).m_38758_(1.4f).effect(() -> new MobEffectInstance(MobEffects.f_19614_, 600, 0), 0.8f).m_38767_())));
    public static final RegistryObject<Item> OVER_EASY_EGG = ISORegistries.ITEMS.register("over_easy_egg", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).m_38767_())));
    public static final RegistryObject<Item> PUMPKIN_PULP = ISORegistries.ITEMS.register("pumpkin_pulp", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38767_())));
    public static final TagKey<Item> RAW_FOOD = ISOItemTagsProvider.create("raw_food");
    public static final TagKey<Item> FOOD_BLACKLIST = ISOItemTagsProvider.create("food_drinks_no_hunger_changes");
    public static final ArrayList<CustomFoodProperties> CUSTOM_FOOD_PROPERTIES_DEFAULT = new ArrayList<CustomFoodProperties>(List.of(new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:rotten_flesh")).nutrition(2).setEatingTime(55).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:spider_eye")).nutrition(1).setEatingTime(40).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:honey_bottle")).nutrition(2).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:cooked_beef")).nutrition(6).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:cooked_porkchop")).nutrition(7).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:pumpkin_pie")).nutrition(6).setEatingTime(40).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:rabbit_stew")).nutrition(12).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:glow_berries")).alwaysEat(true).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:cookie")).nutrition(1).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:golden_apple")).addEffect(new ISOMobEffectInstance.Builder(MobEffects.f_19605_, 100).setAmplifier(1).build()).addEffect(new ISOMobEffectInstance.Builder((Supplier<MobEffect>)RegeneratingAbsorption.EFFECT, 2400).build()).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"minecraft:enchanted_golden_apple")).addEffect(new ISOMobEffectInstance.Builder(MobEffects.f_19605_, 400).setAmplifier(1).build()).addEffect(new ISOMobEffectInstance.Builder(MobEffects.f_19606_, 6000).build()).addEffect(new ISOMobEffectInstance.Builder(MobEffects.f_19607_, 6000).build()).addEffect(new ISOMobEffectInstance.Builder((Supplier<MobEffect>)RegeneratingAbsorption.EFFECT, 2400).setAmplifier(3).build()).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"berry_good:sweet_berry_meatballs")).nutrition(9).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"berry_good:glowgurt")).nutrition(8).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"farmersdelight:bone_broth")).nutrition(6).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"autumnity:pumpkin_bread")).nutrition(5).build(), new CustomFoodProperties.Builder(IdTagMatcher.newId((String)"buzzier_bees:honey_bread")).nutrition(5).build()));
    public static final ArrayList<CustomFoodProperties> customFoodProperties = new ArrayList();
    @Config
    @Label(name="Food Hunger Formula", description="Food's hunger restored will be calculated from this formula. Variables as hunger, saturation_modifier, effectiveness as numbers and fast_food as boolean can be used. This is evaluated with EvalEx https://ezylang.github.io/EvalEx/concepts/parsing_evaluation.html. Setting this to an empty string disables the feature. Can be re-applied with /reload")
    public static String foodHungerFormula = "";
    @Config
    @Label(name="Food Saturation Modifier Formula", description="Food's saturation multiplier will be calculated from this formula. This is not a flat value: https://minecraft.wiki/w/Hunger#Food_level_and_saturation_level_restoration. Variables as hunger, saturation_modifier, effectiveness as numbers and fast_food as boolean can be used. This is evaluated with EvalEx https://ezylang.github.io/EvalEx/concepts/parsing_evaluation.html. Setting this to an empty string disables the feature. Can be re-applied with /reload")
    public static String foodSaturationModifierFormula = "saturation_modifier * 1.2";
    @Config
    @Label(name="Faster Drink Consuming", description="Makes potion, milk and honey faster to drink, 1 second instead of 1.6.")
    public static Boolean fasterDrinkConsuming = true;
    @Config
    @Label(name="Eating Speed Based Off Food Restored", description="Makes the speed for eating food based off the hunger and saturation they provide.")
    public static Boolean eatingSpeedBasedOffFood = true;
    @Config
    @Label(name="Eating Speed Formula", description="The formula to calculate the ticks required to eat a food. Variables as hunger, saturation_modifier, effectiveness as numbers and fast_food as boolean can be used. This is evaluated with EvalEx https://ezylang.github.io/EvalEx/concepts/parsing_evaluation.html. The default formula increases the time to eat exponentially when higher effectiveness.")
    public static String eatingSpeedFormula = "MIN(MAX((IF(fast_food, 16, 32) * effectiveness) * 0.075, IF(fast_food, 12, 20)), 75)";
    @Config
    @Label(name="Stop consuming on hit", description="If true, eating/drinking stops when the player's hit.")
    public static Boolean stopConsumingOnHit = true;
    @Config
    @Label(description="If true, eating will always be possible, even with full hunger.")
    public static Boolean alwaysEat = false;
    @Config(min=0.0, max=1.0)
    @Label(name="Raw food Poison Chance", description="Raw food has this chance to poison the player. Raw food is defined in the iguanatweaksreborn:raw_food tag")
    public static Double rawFoodPoisonChance = 0.7;
    @Config(min=0.0, max=255.0)
    @Label(name="Raw food Poison Amplifier", description="Raw food will give this level of poison to the player.")
    public static Integer rawFoodPoisonAmplifier = 1;
    @Config(min=0.0)
    @Label(name="Raw food Poison Duration Multiplier", description="Raw food's poison duration will be multiplied by this value. With this set to 1, raw food will give 1 second of poison per nutrition + saturation given.")
    public static Double rawFoodPoisonDurationMultiplier = 2.0;
    @Config
    @Label(name="Combat Snapshot eating saturation", description="If enabled, when eating food the saturation will not sum, instead will just be set to the food's saturation (if higher than the current). If AppleSkin is installed it also adds compatibility for saturation restored overlay")
    public static Boolean combatSnapshotEatingSaturation = true;
    @Config
    @Label(name="Buff cakes", description="If enabled, eating cakes will give 30 seconds of Speed and Haste")
    public static Boolean buffCake = true;
    @Config
    @Label(name="No Furnace food and smoker recipe", description="Food can no longer be smelted in furnaces and change smokers recipe to require soul sand.\nThis also enables a change to the smelt_item_function in loot tables to use smoker recipes instead of furnaces (otherwise, mobs wouldn't drop cooked food). Might have unintended side effects.")
    public static Boolean noFurnaceFoodAndSmokerRecipe = true;
    private static CustomFoodProperties customFoodPropertiesCache;
    private static FoodProperties lastFoodEatenCache;
    private static int lastFoodEatenTime;
    public static final Map<Item, FoodProperties> originalFoodProperties;

    public FoodDrinks(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("no_food_in_furnace", "Insane's Survival Overhaul No Food in Furnace", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && noFurnaceFoodAndSmokerRecipe != false);
        FoodDrinks.addSyncType((ResourceLocation)new ResourceLocation("iguanatweaksreborn", "food_properties"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> FoodDrinks.loadAndReadJson((String)json, customFoodProperties, CUSTOM_FOOD_PROPERTIES_DEFAULT, (Type)CustomFoodProperties.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("food_properties.json", customFoodProperties, CUSTOM_FOOD_PROPERTIES_DEFAULT, CustomFoodProperties.LIST_TYPE, FoodDrinks::processCustomFoodValues, true, new ResourceLocation("iguanatweaksreborn", "food_properties")));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public void loadJsonConfigs() {
        if (!this.isEnabled()) {
            return;
        }
        super.loadJsonConfigs();
    }

    @SubscribeEvent
    public void onPlayerEat(LivingEntityUseItemEvent.Finish event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || event.getItem().m_41720_().m_41473_() == null || !((livingEntity = event.getEntity()) instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!event.getEntity().m_9236_().f_46443_) break block5;
            }
            return;
        }
        Item item = event.getItem().m_41720_();
        if (player.m_217043_().m_188500_() < rawFoodPoisonChance && FoodDrinks.isRawFood(item)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, (int)((double)(MCUtils.getFoodEffectiveness((FoodProperties)item.getFoodProperties(event.getItem(), (LivingEntity)player)) * 20.0f) * rawFoodPoisonDurationMultiplier), rawFoodPoisonAmplifier.intValue()));
        }
    }

    @SubscribeEvent
    public void onCakeEat(CakeEatEvent event) {
        if (!this.isEnabled() || !buffCake.booleanValue()) {
            return;
        }
        event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 0, false, false, true));
        event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19598_, 600, 0, false, false, true));
    }

    public static int getFoodConsumingTime(ItemStack stack) {
        if (customFoodPropertiesCache != null && FoodDrinks.customFoodPropertiesCache.food.matchesItem(stack.m_41720_())) {
            return FoodDrinks.customFoodPropertiesCache.eatingTime;
        }
        for (CustomFoodProperties cfp : customFoodProperties) {
            if (!cfp.food.matchesItem(stack.m_41720_()) || cfp.eatingTime < 0) continue;
            customFoodPropertiesCache = cfp;
            return cfp.eatingTime;
        }
        FoodProperties food = stack.m_41720_().getFoodProperties(stack, null);
        if (food == lastFoodEatenCache) {
            return lastFoodEatenTime;
        }
        int ticks = (int)insane96mcp.iguanatweaksreborn.utils.MCUtils.computeFoodFormula(food, eatingSpeedFormula);
        lastFoodEatenCache = food;
        lastFoodEatenTime = ticks >= 0 ? ticks : (food.m_38748_() ? 16 : 32);
        return lastFoodEatenTime;
    }

    @SubscribeEvent
    public void onPlayerHit(LivingDamageEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (!(this.isEnabled() && stopConsumingOnHit.booleanValue() && event.getSource().m_7639_() instanceof LivingEntity && (livingEntity = event.getEntity()) instanceof Player && ((player = (Player)livingEntity).m_21211_().m_41780_().equals((Object)UseAnim.EAT) || player.m_21211_().m_41780_().equals((Object)UseAnim.DRINK)))) {
            return;
        }
        player.m_5810_();
    }

    @SubscribeEvent
    public void onEffectApply(AddEatEffectEvent event) {
        for (CustomFoodProperties foodValue : customFoodProperties) {
            if (foodValue.effects == null || !foodValue.food.matchesItem(event.getStack().m_41720_())) continue;
            foodValue.getEffects().forEach(pair -> {
                if (!event.getLevel().f_46443_ && pair.getFirst() != null && event.getLevel().f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue()) {
                    event.getEntity().m_7292_(new MobEffectInstance(((ISOMobEffectInstance)pair.getFirst()).getMobEffectInstance()));
                }
            });
            event.setCanceled(true);
            break;
        }
    }

    public static void processFoodMultipliers(boolean isClientSide) {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (item.m_41473_() == null || FoodDrinks.isItemInTag((Item)item, FOOD_BLACKLIST, (boolean)isClientSide)) continue;
            FoodProperties food = item.m_41473_();
            if (!foodHungerFormula.isEmpty()) {
                food.f_38723_ = (int)insane96mcp.iguanatweaksreborn.utils.MCUtils.computeFoodFormula(food, foodHungerFormula);
            }
            if (!foodSaturationModifierFormula.isEmpty()) {
                food.f_38724_ = insane96mcp.iguanatweaksreborn.utils.MCUtils.computeFoodFormula(food, foodSaturationModifierFormula);
            }
            if (FMLLoader.isProduction()) continue;
            ISOLogHelper.debug("Food multiplier applied to item " + item.m_5524_() + ": hunger: " + food.f_38723_ + ", saturationMod: " + food.f_38724_ + ", saturation: " + MCUtils.getFoodSaturationRestored((FoodProperties)food), new Object[0]);
        }
    }

    public static void processCustomFoodValues(List<CustomFoodProperties> list, boolean isClientSide) {
        if (!originalFoodProperties.isEmpty()) {
            originalFoodProperties.forEach((item, food) -> {
                item.m_41473_().f_38723_ = food.f_38723_;
                item.m_41473_().f_38724_ = food.f_38724_;
            });
        }
        if (originalFoodProperties.isEmpty()) {
            originalFoodProperties.putAll(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_41473_() != null && !FoodDrinks.isItemInTag((Item)item, FOOD_BLACKLIST, (boolean)isClientSide)).collect(Collectors.toMap(Function.identity(), item -> {
                FoodProperties properties = item.m_41473_();
                if (!FMLLoader.isProduction()) {
                    ISOLogHelper.debug("Storing original food properties for item " + item.m_5524_() + ": hunger: " + properties.f_38723_ + ", saturationMod: " + properties.f_38724_ + ", saturation: " + MCUtils.getFoodSaturationRestored((FoodProperties)properties), new Object[0]);
                }
                return new FoodProperties.Builder().m_38760_(properties.f_38723_).m_38758_(properties.f_38724_).m_38767_();
            })));
        }
        if (!list.isEmpty()) {
            for (CustomFoodProperties foodValue : list) {
                foodValue.apply();
            }
        }
        customFoodPropertiesCache = null;
        FoodDrinks.processFoodMultipliers(isClientSide);
    }

    public static boolean isRawFood(Item item) {
        return item.m_204114_().m_203656_(RAW_FOOD);
    }

    static {
        originalFoodProperties = new HashMap<Item, FoodProperties>();
    }
}

