/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.HurtItemStackEvent;
import insane96mcp.insanelib.util.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Ecologic Wood", description="Wooden items have a lower chance to break in sunlight.")
@LoadFeature(module="iguanatweaksreborn:items")
public class EcologicWood
extends Feature {
    public static final TagKey<Item> WOODEN_HAND_EQUIPMENT = ISOItemTagsProvider.create("equipment/hand/wooden");
    @Config(min=0.0, max=1.0)
    @Label(name="Chance at 'Max sunlight'", description="Chance for the wooden item to not consume durability at 'Max sunlight'.")
    public static Double chanceAtMaxSunlight = 0.75;
    @Config(min=0.0, max=15.0)
    @Label(name="Max sunlight")
    public static Integer maxSunlight = 12;

    public EcologicWood(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void processItemDamaging(HurtItemStackEvent event) {
        if (!this.isEnabled() || event.getPlayer() == null || !event.getStack().m_204117_(WOODEN_HAND_EQUIPMENT)) {
            return;
        }
        float skyLightRatio = EcologicWood.getCalculatedSkyLightRatio((Entity)event.getPlayer());
        float ratio = 1.0f - chanceAtMaxSunlight.floatValue() * skyLightRatio;
        float amount = (float)event.getAmount() * ratio;
        event.setAmount(MathHelper.getAmountWithDecimalChance((RandomSource)event.getRandom(), (float)amount));
    }

    public static float getCalculatedSkyLight(Entity entity) {
        return EcologicWood.getCalculatedSkyLight(entity.m_9236_(), entity.m_20183_());
    }

    public static float getCalculatedSkyLight(Level level, BlockPos pos) {
        if (!level.m_46461_() || level.m_46470_()) {
            return 0.0f;
        }
        float skyLight = level.m_45517_(LightLayer.SKY, pos) - level.m_7445_();
        if (level.m_46471_()) {
            skyLight /= 3.0f;
        }
        return skyLight;
    }

    public static float getCalculatedSkyLightRatio(Entity entity) {
        return EcologicWood.getCalculatedSkyLightRatio(entity.m_9236_(), entity.m_20183_());
    }

    public static float getCalculatedSkyLightRatio(Level level, BlockPos pos) {
        return Math.min(EcologicWood.getCalculatedSkyLight(level, pos), (float)maxSunlight.intValue()) / (float)maxSunlight.intValue();
    }
}

