/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.misc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.mixin.TieredItemAccessor;
import insane96mcp.iguanatweaksreborn.module.combat.RegeneratingAbsorption;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinitionsReloadListener;
import insane96mcp.iguanatweaksreborn.module.items.unbreakableitems.UnbreakableItems;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.data.SerializableAttributeModifier;
import insane96mcp.insanelib.util.json.ILGsonHelper;
import insane96mcp.insanelib.util.json.validator.DoubleMinMaxValidator;
import insane96mcp.insanelib.util.json.validator.FloatMinMaxValidator;
import insane96mcp.insanelib.util.json.validator.IntMinMaxValidator;
import insane96mcp.insanelib.util.json.validator.Validator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import org.jetbrains.annotations.NotNull;

@JsonAdapter(value=Serializer.class)
public final class ItemDefinition {
    private final IdTagMatcher item;
    @Nullable
    private final Integer maxStackSize;
    private final Durability durability;
    @Nullable
    private final String harvestLevel;
    @Nullable
    private final Double efficiency;
    @Nullable
    private final Integer enchantability;
    @Nullable
    private final Double knockbackMultiplier;
    @Nullable
    private final Integer scytheRadius;
    @Nullable
    private final Double baseAttackDamage;
    @Nullable
    private final Double baseAttackSpeed;
    @Nullable
    private final Double baseArmor;
    @Nullable
    private final Double baseArmorToughness;
    @Nullable
    private final Double baseKnockbackResistance;
    @Nullable
    private final Double baseRegeneratingAbsorption;
    @Nullable
    private final Double baseRegenAbsorptionSpeed;
    @Nullable
    private final Double movementSpeedPenalty;
    @Nullable
    private final List<SerializableAttributeModifier> modifiers;
    public static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        enumMap.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        enumMap.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        enumMap.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    public static final Type LIST_TYPE = new TypeToken<ArrayList<ItemDefinition>>(){}.getType();

    public ItemDefinition(@NotNull IdTagMatcher item, @Nullable Integer maxStackSize, @Nullable Integer durability, @Nullable Integer durabilityBonus, @Nullable Float durabilityMultiplier, @Nullable String harvestLevel, @Nullable Double efficiency, @Nullable Integer enchantability, @Nullable Double knockbackMultiplier, @Nullable Integer scytheRadius, @Nullable Double baseAttackDamage, @Nullable Double baseAttackSpeed, @Nullable Double baseArmor, @Nullable Double baseArmorToughness, @Nullable Double baseKnockbackResistance, @Nullable Double baseRegeneratingAbsorption, @Nullable Double baseRegenAbsorptionSpeed, @Nullable Double movementSpeedPenalty, @Nullable List<SerializableAttributeModifier> modifiers) {
        this.item = item;
        this.maxStackSize = maxStackSize;
        this.durability = new Durability(durability, durabilityBonus, durabilityMultiplier);
        this.harvestLevel = harvestLevel;
        this.efficiency = efficiency;
        this.enchantability = enchantability;
        this.knockbackMultiplier = knockbackMultiplier;
        this.scytheRadius = scytheRadius;
        this.baseAttackDamage = baseAttackDamage;
        this.baseAttackSpeed = baseAttackSpeed;
        this.baseArmor = baseArmor;
        this.baseArmorToughness = baseArmorToughness;
        this.baseKnockbackResistance = baseKnockbackResistance;
        this.baseRegeneratingAbsorption = baseRegeneratingAbsorption;
        this.baseRegenAbsorptionSpeed = baseRegenAbsorptionSpeed;
        this.movementSpeedPenalty = movementSpeedPenalty;
        this.modifiers = modifiers;
    }

    public void applyStats(boolean isClientSide) {
        List items = JsonFeature.getAllItems((IdTagMatcher)this.item, (boolean)isClientSide);
        for (Item item : items) {
            Durability durability = new Durability(null, null, null);
            if (!ItemDefinitionsReloadListener.DURABILITY_MAP.containsKey(item)) {
                ItemDefinitionsReloadListener.DURABILITY_MAP.put(item, durability);
            } else {
                durability = ItemDefinitionsReloadListener.DURABILITY_MAP.get(item);
            }
            if (this.durability.durability != null) {
                durability.durability = this.durability.durability;
            }
            if (this.durability.durabilityBonus != null) {
                durability.durabilityBonus = this.durability.durabilityBonus;
            }
            if (this.durability.durabilityMultiplier != null) {
                durability.durabilityMultiplier = this.durability.durabilityMultiplier;
            }
            if (item instanceof DiggerItem) {
                DiggerItem diggerItem = (DiggerItem)item;
                if (this.efficiency != null) {
                    diggerItem.f_40980_ = this.efficiency.floatValue();
                }
                if (this.harvestLevel != null) {
                    Tier tier = TierSortingRegistry.byName((ResourceLocation)ResourceLocation.m_135820_((String)this.harvestLevel));
                    if (tier != null) {
                        ((TieredItemAccessor)diggerItem).setTier(tier);
                    } else {
                        ISOLogHelper.warn("Failed to parse harvest level %s", this.harvestLevel);
                    }
                }
            }
            if (this.maxStackSize == null) continue;
            item.f_41370_ = this.maxStackSize;
        }
    }

    public void applyAttributes(ItemAttributeModifierEvent event, ItemStack stack, Multimap<Attribute, AttributeModifier> modifiers) {
        if (!this.item.matchesItem(stack)) {
            return;
        }
        HashMultimap toAdd = HashMultimap.create();
        HashMultimap toRemove = HashMultimap.create();
        for (Map.Entry entry : modifiers.entries()) {
            Item item;
            if (this.baseAttackDamage != null && event.getSlotType() == EquipmentSlot.MAINHAND) {
                double materialAd = 0.0;
                Item item2 = stack.m_41720_();
                if (item2 instanceof TieredItem) {
                    TieredItem tieredItem = (TieredItem)item2;
                    materialAd = tieredItem.m_43314_().m_6631_();
                }
                if (this.baseAttackDamage + materialAd > 0.0) {
                    toAdd.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", this.baseAttackDamage + materialAd, AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(BASE_ATTACK_DAMAGE_UUID) && ((Attribute)entry.getKey()).equals(Attributes.f_22281_)) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.baseAttackSpeed != null && event.getSlotType() == EquipmentSlot.MAINHAND) {
                if (this.baseAttackSpeed > 0.0) {
                    toAdd.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", -(4.0 - this.baseAttackSpeed), AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(BASE_ATTACK_SPEED_UUID) && ((Attribute)entry.getKey()).equals(Attributes.f_22283_)) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.baseArmor != null && (item = stack.m_41720_()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.baseArmor > 0.0) {
                    toAdd.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_()), "Armor modifier", this.baseArmor.doubleValue(), AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_())) && ((Attribute)entry.getKey()).equals(Attributes.f_22284_)) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.baseArmorToughness != null && (item = stack.m_41720_()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.baseArmorToughness > 0.0) {
                    toAdd.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_()), "Armor toughness", this.baseArmorToughness.doubleValue(), AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_())) && ((Attribute)entry.getKey()).equals(Attributes.f_22285_)) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.baseKnockbackResistance != null && (item = stack.m_41720_()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.baseKnockbackResistance > 0.0) {
                    toAdd.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_()), "Armor knockback resistance", this.baseKnockbackResistance.doubleValue(), AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_())) && ((Attribute)entry.getKey()).equals(Attributes.f_22278_)) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.baseRegeneratingAbsorption != null && (item = stack.m_41720_()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.baseRegeneratingAbsorption > 0.0) {
                    toAdd.put((Object)((Attribute)RegeneratingAbsorption.ATTRIBUTE.get()), (Object)new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_()), "Armor Regenerating Absorption", this.baseRegeneratingAbsorption.doubleValue(), AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_())) && ((Attribute)entry.getKey()).equals(RegeneratingAbsorption.ATTRIBUTE.get())) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.baseRegenAbsorptionSpeed != null && (item = stack.m_41720_()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.baseRegenAbsorptionSpeed > 0.0) {
                    toAdd.put((Object)((Attribute)RegeneratingAbsorption.SPEED_ATTRIBUTE.get()), (Object)new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_()), "Armor Regenerating Absorption Speed", this.baseRegenAbsorptionSpeed.doubleValue(), AttributeModifier.Operation.ADDITION));
                }
                if (((AttributeModifier)entry.getValue()).m_22209_().equals(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_())) && ((Attribute)entry.getKey()).equals(RegeneratingAbsorption.SPEED_ATTRIBUTE.get())) {
                    toRemove.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
                }
            }
            if (this.movementSpeedPenalty == null || !((item = stack.m_41720_()) instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            if (!(this.movementSpeedPenalty > 0.0)) continue;
            toAdd.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID_PER_TYPE.get(armorItem.m_266204_()), "Armor Movement Speed Reduction", ItemDefinition.getSpeedReductionPerArmor(-this.movementSpeedPenalty.doubleValue(), armorItem), AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (event.getItemStack().m_204117_(UnbreakableItems.REMOVE_ORIGINAL_MODIFIERS_TAG)) {
            Multimap originalModifiers = event.getOriginalModifiers();
            toRemove.putAll(originalModifiers);
        }
        if (this.modifiers != null) {
            for (SerializableAttributeModifier attributeModifier : this.modifiers) {
                if (!attributeModifier.slots().isEmpty() && !attributeModifier.slots().contains(event.getSlotType()) || LivingEntity.m_147233_((ItemStack)stack) != event.getSlotType()) continue;
                AttributeModifier modifier = attributeModifier.getModifier();
                toAdd.put((Object)((Attribute)attributeModifier.attribute().get()), (Object)modifier);
            }
        }
        toRemove.forEach((arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).removeModifier(arg_0, arg_1));
        toAdd.forEach((arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).addModifier(arg_0, arg_1));
    }

    public boolean matches(ItemStack stack) {
        return this.item.matchesItem(stack);
    }

    public boolean matches(Item stack) {
        return this.item.matchesItem(stack);
    }

    private static double getSpeedReductionPerArmor(double totalReduction, ArmorItem item) {
        return switch (item.m_40402_()) {
            case EquipmentSlot.HEAD -> totalReduction * 0.2;
            case EquipmentSlot.CHEST -> totalReduction * 0.35;
            case EquipmentSlot.LEGS -> totalReduction * 0.3;
            default -> totalReduction * 0.15;
        };
    }

    public static ItemDefinition fromNetwork(FriendlyByteBuf byteBuf) {
        String utf = byteBuf.m_130277_();
        IdTagMatcher item = IdTagMatcher.parseLine((String)utf);
        if (item == null) {
            throw new NullPointerException("Parsing item from %s for Item Statistics returned null".formatted(utf));
        }
        Integer maxStackSize = (Integer)byteBuf.m_236868_(FriendlyByteBuf::readInt);
        Integer durability = (Integer)byteBuf.m_236868_(FriendlyByteBuf::readInt);
        Integer durabilityBonus = (Integer)byteBuf.m_236868_(FriendlyByteBuf::readInt);
        Float durabilityMultiplier = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        String harvestLevel = (String)byteBuf.m_236868_(FriendlyByteBuf::m_130277_);
        Double efficiency = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Integer enchantability = (Integer)byteBuf.m_236868_(FriendlyByteBuf::readInt);
        Double knockbackMultiplier = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Integer scytheRadius = (Integer)byteBuf.m_236868_(FriendlyByteBuf::readInt);
        Double baseAttackDamage = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double baseAttackSpeed = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double baseArmor = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double baseToughness = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double baseKnockbackResistance = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double baseRegeneratingAbsorption = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double baseRegeneratingAbsorptionSpeed = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        Double movementSpeedPenalty = (Double)byteBuf.m_236868_(FriendlyByteBuf::readDouble);
        boolean hasModifiers = byteBuf.readBoolean();
        ArrayList<SerializableAttributeModifier> modifiers = null;
        if (hasModifiers) {
            int size = byteBuf.readInt();
            modifiers = new ArrayList<SerializableAttributeModifier>();
            for (int i = 0; i < size; ++i) {
                modifiers.add(SerializableAttributeModifier.fromNetwork((FriendlyByteBuf)byteBuf));
            }
        }
        return new ItemDefinition(item, maxStackSize, durability, durabilityBonus, durabilityMultiplier, harvestLevel, efficiency, enchantability, knockbackMultiplier, scytheRadius, baseAttackDamage, baseAttackSpeed, baseArmor, baseToughness, baseKnockbackResistance, baseRegeneratingAbsorption, baseRegeneratingAbsorptionSpeed, movementSpeedPenalty, modifiers);
    }

    public void toNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.m_130070_(this.item.m_7912_());
        byteBuf.m_236821_((Object)this.maxStackSize, FriendlyByteBuf::writeInt);
        byteBuf.m_236821_((Object)this.durability.durability, FriendlyByteBuf::writeInt);
        byteBuf.m_236821_((Object)this.durability.durabilityBonus, FriendlyByteBuf::writeInt);
        byteBuf.m_236821_((Object)this.durability.durabilityMultiplier, FriendlyByteBuf::writeFloat);
        byteBuf.m_236821_((Object)this.harvestLevel, FriendlyByteBuf::m_130070_);
        byteBuf.m_236821_((Object)this.efficiency, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.enchantability, FriendlyByteBuf::writeInt);
        byteBuf.m_236821_((Object)this.knockbackMultiplier, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.scytheRadius, FriendlyByteBuf::writeInt);
        byteBuf.m_236821_((Object)this.baseAttackDamage, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.baseAttackSpeed, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.baseArmor, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.baseArmorToughness, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.baseKnockbackResistance, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.baseRegeneratingAbsorption, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.baseRegenAbsorptionSpeed, FriendlyByteBuf::writeDouble);
        byteBuf.m_236821_((Object)this.movementSpeedPenalty, FriendlyByteBuf::writeDouble);
        if (this.modifiers != null) {
            byteBuf.writeBoolean(true);
            byteBuf.writeInt(this.modifiers.size());
            for (SerializableAttributeModifier attributeModifier : this.modifiers) {
                attributeModifier.toNetwork(byteBuf);
            }
        } else {
            byteBuf.writeBoolean(false);
        }
    }

    public IdTagMatcher item() {
        return this.item;
    }

    public Durability durability() {
        return this.durability;
    }

    @Nullable
    public Double efficiency() {
        return this.efficiency;
    }

    @Nullable
    public Integer enchantability() {
        return this.enchantability;
    }

    @Nullable
    public Double knockbackMultiplier() {
        return this.knockbackMultiplier;
    }

    @Nullable
    public Integer scytheRadius() {
        return this.scytheRadius;
    }

    @Nullable
    public List<SerializableAttributeModifier> modifiers() {
        return this.modifiers;
    }

    public static final class Durability {
        @Nullable
        public Integer durability;
        @Nullable
        public Integer durabilityBonus;
        @Nullable
        public Float durabilityMultiplier;

        public Durability(@Nullable Integer durability, @Nullable Integer durabilityBonus, @Nullable Float durabilityMultiplier) {
            this.durability = durability;
            this.durabilityBonus = durabilityBonus;
            this.durabilityMultiplier = durabilityMultiplier;
        }

        public void apply(Item item) {
            if (ItemDefinitionsReloadListener.ORIGINAL_DURABILITY.containsKey(item)) {
                item.f_41371_ = ItemDefinitionsReloadListener.ORIGINAL_DURABILITY.get(item);
            } else {
                ItemDefinitionsReloadListener.ORIGINAL_DURABILITY.put(item, item.f_41371_);
            }
            if (this.durability != null) {
                item.f_41371_ = this.durability;
            }
            if (this.durabilityBonus != null) {
                item.f_41371_ += this.durabilityBonus.intValue();
            }
            if (this.durabilityMultiplier != null) {
                item.f_41371_ = (int)((float)item.f_41371_ * this.durabilityMultiplier.floatValue());
            }
        }
    }

    public static class Serializer
    implements JsonDeserializer<ItemDefinition>,
    JsonSerializer<ItemDefinition> {
        public ItemDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            IdTagMatcher item = (IdTagMatcher)context.deserialize(jObject.get("item"), IdTagMatcher.class);
            Integer maxStackSize = ILGsonHelper.getAsNullableInt((JsonObject)jObject, (String)"max_stack", (Validator)IntMinMaxValidator.between((int)1, (int)64));
            Integer durability = ILGsonHelper.getAsNullableInt((JsonObject)jObject, (String)"durability", (Validator)IntMinMaxValidator.atLeast((int)1));
            Integer durabilityBonus = ILGsonHelper.getAsNullableInt((JsonObject)jObject, (String)"durability_bonus", (Validator)IntMinMaxValidator.atLeast((int)1));
            Float durabilityMultiplier = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"durability_multiplier", (Validator)FloatMinMaxValidator.atLeast((float)0.0f));
            String harvestLevel = GsonHelper.m_13851_((JsonObject)jObject, (String)"harvest_level", null);
            Double efficiency = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"efficiency", (Validator)DoubleMinMaxValidator.atLeast((double)0.0));
            Integer enchantability = ILGsonHelper.getAsNullableInt((JsonObject)jObject, (String)"enchantability", (Validator)IntMinMaxValidator.atLeast((int)0));
            Double knockbackMultiplier = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"knockback_multiplier", (Validator)DoubleMinMaxValidator.between((double)0.0, (double)1.0));
            Integer scytheRadius = ILGsonHelper.getAsNullableInt((JsonObject)jObject, (String)"scythe_radius", (Validator)IntMinMaxValidator.atLeast((int)0));
            Double baseAttackDamage = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"attack_damage");
            Double baseAttackSpeed = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"attack_speed");
            Double baseArmor = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"armor");
            Double baseToughness = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"armor_toughness");
            Double regeneratingAbsorption = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"regenerating_absorption");
            Double regeneratingAbsorptionSpeed = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"regenerating_absorption_speed");
            Double baseKnockbackResistance = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"knockback_resistance");
            Double movementSpeedPenalty = ILGsonHelper.getAsNullableDouble((JsonObject)jObject, (String)"movement_speed_penalty");
            List modifiers = null;
            if (jObject.has("modifiers")) {
                modifiers = (List)context.deserialize(jObject.get("modifiers"), SerializableAttributeModifier.LIST_TYPE);
            }
            return new ItemDefinition(item, maxStackSize, durability, durabilityBonus, durabilityMultiplier, harvestLevel, efficiency, enchantability, knockbackMultiplier, scytheRadius, baseAttackDamage, baseAttackSpeed, baseArmor, baseToughness, baseKnockbackResistance, regeneratingAbsorption, regeneratingAbsorptionSpeed, movementSpeedPenalty, modifiers);
        }

        public JsonElement serialize(ItemDefinition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            ILGsonHelper.add((JsonObject)jObject, (JsonSerializationContext)context, (String)"item", (Object)src.item);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"max_stack", (Object)src.maxStackSize);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"durability", (Object)src.durability.durability);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"durability_bonus", (Object)src.durability.durabilityBonus);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"durability_multiplier", (Object)src.durability.durabilityMultiplier);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"harvest_level", (Object)src.harvestLevel);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"efficiency", (Object)src.efficiency);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"enchantability", (Object)src.enchantability);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"knockback_multiplier", (Object)src.knockbackMultiplier);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"scythe_radius", (Object)src.scytheRadius);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"attack_damage", (Object)src.baseAttackDamage);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"attack_speed", (Object)src.baseAttackSpeed);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"armor", (Object)src.baseArmor);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"armor_toughness", (Object)src.baseArmorToughness);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"knockback_resistance", (Object)src.baseKnockbackResistance);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"regenerating_absorption", (Object)src.baseRegeneratingAbsorption);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"regenerating_absorption_speed", (Object)src.baseRegenAbsorptionSpeed);
            ILGsonHelper.addProperty((JsonObject)jObject, (String)"movement_speed_penalty", (Object)src.movementSpeedPenalty);
            ILGsonHelper.add((JsonObject)jObject, (JsonSerializationContext)context, (String)"modifiers", src.modifiers, (Type)SerializableAttributeModifier.LIST_TYPE);
            return jObject;
        }
    }
}

