/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinition;
import insane96mcp.iguanatweaksreborn.network.message.ItemDefinitionsSync;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iguanatweaksreborn")
public class ItemDefinitionsReloadListener
extends SimpleJsonResourceReloadListener {
    private static final List<ItemDefinition> DEFINITIONS = new ArrayList<ItemDefinition>();
    public static final Map<Item, ItemDefinition.Durability> DURABILITY_MAP = new HashMap<Item, ItemDefinition.Durability>();
    public static final Map<Item, Integer> ORIGINAL_DURABILITY = new HashMap<Item, Integer>();
    public static final ItemDefinitionsReloadListener INSTANCE;
    private static final Gson GSON;

    public ItemDefinitionsReloadListener() {
        super(GSON, "item_definitions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ItemDefinitionsReloadListener.getDefinitions().clear();
        DURABILITY_MAP.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                ResourceLocation name = entry.getKey();
                String[] split = name.m_135815_().split("/");
                if (split[split.length - 1].startsWith("_")) continue;
                ItemDefinition itemDefinition = (ItemDefinition)GSON.fromJson(entry.getValue(), ItemDefinition.class);
                ItemDefinitionsReloadListener.getDefinitions().add(itemDefinition);
            }
            catch (JsonSyntaxException e) {
                ISOLogHelper.error("Parsing error loading Item Definition %s: %s", entry.getKey(), e.getMessage());
            }
            catch (Exception e) {
                ISOLogHelper.error("Failed loading Item Definition %s: %s", entry.getKey(), e.getMessage());
            }
        }
        ISOLogHelper.info("Loaded %s Item Definition", ItemDefinitionsReloadListener.getDefinitions().size());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(player -> ItemDefinitionsSync.sync(DEFINITIONS, player));
        } else {
            ItemDefinitionsSync.sync(DEFINITIONS, event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent event) {
        for (ItemDefinition itemDefinition : DEFINITIONS) {
            itemDefinition.applyStats(event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED);
        }
        ISOLogHelper.info("Applied %s Item Definitions (Client side: %s)", DEFINITIONS.size(), event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED);
        for (Map.Entry entry : DURABILITY_MAP.entrySet()) {
            ((ItemDefinition.Durability)entry.getValue()).apply((Item)entry.getKey());
        }
    }

    public static synchronized List<ItemDefinition> getDefinitions() {
        return DEFINITIONS;
    }

    public String m_7812_() {
        return "Item Definitions Reload Listener";
    }

    static {
        GSON = new GsonBuilder().create();
        INSTANCE = new ItemDefinitionsReloadListener();
    }
}

