/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.unbreakableitems;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.items.unbreakableitems.ShieldsPlusIntegration;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.HurtItemStackEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@Label(name="Unbreakable Items", description="Less durable items and efficient tools. Items Durability and Efficiency are controlled via data packs")
@LoadFeature(module="iguanatweaksreborn:items")
public class UnbreakableItems
extends Feature {
    public static final String TOOL_DURABILITY_LANG = "iguanatweaksreborn.tool_durability";
    public static final String BROKEN_DURABILITY_LANG = "iguanatweaksreborn.broken_durability";
    public static final String BROKEN_ITEM_LANG = "iguanatweaksreborn.broken_item";
    public static final TagKey<Item> NOT_UNBREAKABLE = ISOItemTagsProvider.create("not_unbreakable");
    public static final TagKey<Item> REMOVE_ORIGINAL_MODIFIERS_TAG = ISOItemTagsProvider.create("remove_original_modifiers");
    @Config
    @Label(name="Durability Tooltip", description="Items with durability get a durability tooltip.")
    public static Boolean durabilityTooltip = true;
    @Config
    @Label(name="Any enchanted item", description="If set to true items will no longer break if enchanted. Ignores the iguanatweaksreborn:not_unbreakable item tag.")
    public static Boolean unbreakableEnchantedItems = true;

    public UnbreakableItems(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        if (ModList.get().isLoaded("shieldsplus")) {
            MinecraftForge.EVENT_BUS.addListener(ShieldsPlusIntegration::onBlockWithCrouch);
        }
    }

    public static boolean isUnbreakable(ItemStack stack) {
        return !stack.m_204117_(NOT_UNBREAKABLE) || unbreakableEnchantedItems != false && stack.m_41793_();
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41763_() && UnbreakableItems.isUnbreakable(stack) && stack.m_41773_() >= stack.m_41776_() - 1;
    }

    @SubscribeEvent
    public void processAttackDamage(LivingHurtEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getSource().m_7640_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21205_();
        if (stack.m_41776_() == 0) {
            return;
        }
        if (UnbreakableItems.isBroken(stack) && event.getAmount() > 1.0f) {
            event.setAmount(1.0f);
            player.m_5661_((Component)Component.m_237115_((String)BROKEN_ITEM_LANG), true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.player.m_9236_().f_46443_ || event.phase == TickEvent.Phase.START || event.player.f_19797_ % 20 != event.player.m_19879_() % 20) {
            return;
        }
        for (ItemStack stack : event.player.m_6168_()) {
            if (stack.m_41619_() || !UnbreakableItems.isBroken(stack)) continue;
            event.player.m_9236_().m_6269_(null, (Entity)event.player, SoundEvents.f_215675_, SoundSource.PLAYERS, 0.7f, 2.0f);
            EquipmentSlot equipmentSlot = Player.m_147233_((ItemStack)stack);
            if (!(stack.m_41720_() instanceof Equipable)) continue;
            event.player.m_8061_(equipmentSlot, ItemStack.f_41583_);
            if (event.player.m_36356_(stack)) continue;
            event.player.m_36176_(stack, true);
        }
    }

    @SubscribeEvent
    public void processEfficiencyMultipliers(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (stack.m_41776_() == 0) {
            return;
        }
        if (UnbreakableItems.isBroken(stack)) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)BROKEN_ITEM_LANG), true);
        }
    }

    @SubscribeEvent
    public void onEmptyRightClick(PlayerInteractEvent.RightClickEmpty event) {
        if (!this.isEnabled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41776_() == 0) {
            return;
        }
        if (UnbreakableItems.isBroken(stack)) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)BROKEN_ITEM_LANG), true);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!this.isEnabled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41776_() == 0) {
            return;
        }
        if (UnbreakableItems.isBroken(stack)) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)BROKEN_ITEM_LANG), true);
        }
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41776_() == 0) {
            return;
        }
        if (UnbreakableItems.isBroken(stack)) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)BROKEN_ITEM_LANG), true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!this.isEnabled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41776_() == 0) {
            return;
        }
        if (UnbreakableItems.isBroken(stack)) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)BROKEN_ITEM_LANG), true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void processItemDamaging(HurtItemStackEvent event) {
        if (!this.isEnabled() || event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getStack();
        if (!UnbreakableItems.isUnbreakable(stack)) {
            return;
        }
        if (UnbreakableItems.isBroken(stack)) {
            event.setAmount(0);
            return;
        }
        if (event.getAmount() >= stack.m_41776_() - stack.m_41773_() - 1) {
            event.getStack().m_41721_(event.getStack().m_41776_() - 1);
            event.setAmount(0);
            EquipmentSlot equipmentSlot = Player.m_147233_((ItemStack)stack);
            if (stack.m_41720_() instanceof Equipable) {
                event.getPlayer().m_8061_(equipmentSlot, ItemStack.f_41583_);
                if (!event.getPlayer().m_36356_(stack)) {
                    event.getPlayer().m_36176_(stack, true);
                }
            }
            event.getPlayer().m_21166_(equipmentSlot);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41763_()) {
            int durability = stack.m_41776_();
            if (UnbreakableItems.isUnbreakable(stack)) {
                --durability;
            }
            int durabilityLeft = durability - stack.m_41773_();
            MutableComponent component = null;
            if (UnbreakableItems.isBroken(stack)) {
                component = (float)durabilityLeft < (float)(-stack.m_41773_()) * 0.05f ? Component.m_237115_((String)"iguanatweaksreborn.heavily_broken_durability").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD) : Component.m_237115_((String)BROKEN_DURABILITY_LANG).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);
            } else if (durabilityTooltip.booleanValue()) {
                component = Component.m_237110_((String)TOOL_DURABILITY_LANG, (Object[])new Object[]{durabilityLeft, durability}).m_130940_(ChatFormatting.GRAY);
            }
            if (component != null) {
                event.getToolTip().add(event.getToolTip().size(), component);
            }
        }
    }
}

