/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mining;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Gold", description="Changes Gold tools to have an innate Fortune/Looting I")
@LoadFeature(module="iguanatweaksreborn:mining")
public class Gold
extends Feature {
    public static final String LUCKY_GOLD_TOOLTIP = "iguanatweaksreborn.innate_luck";
    @Config(min=0.0, max=255.0)
    @Label(name="Looting Level", description="Set the innate looting level of gold tools.")
    public static Integer lootingLevel = 1;
    @Config(min=0.0, max=255.0)
    @Label(name="Fortune Level", description="Set the innate fortune level of gold tools.")
    public static Integer fortuneLevel = 1;

    public Gold(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
    }

    @SubscribeEvent
    public void onLootingCheck(LootingLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getDamageSource() == null || !((entity = event.getDamageSource().m_7639_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.m_21205_();
        if (stack.m_204117_(ISOItemTagsProvider.GOLDEN_HAND_EQUIPMENT) && event.getLootingLevel() < lootingLevel) {
            event.setLootingLevel(lootingLevel.intValue());
        }
    }

    public static int getFortuneLevel(ItemStack stack, int original) {
        if (!Gold.shouldApply(stack)) {
            return original;
        }
        int luckLvl = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)EnchantmentsFeature.LUCK.get()), (ItemStack)stack);
        if (original >= luckLvl) {
            return Math.max(original, fortuneLevel);
        }
        return Math.max(luckLvl, fortuneLevel);
    }

    public static boolean shouldApply(ItemStack stack) {
        return Gold.isEnabled(Gold.class) && stack.m_204117_(ISOItemTagsProvider.GOLDEN_HAND_EQUIPMENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled() || !event.getItemStack().m_204117_(ISOItemTagsProvider.GOLDEN_HAND_EQUIPMENT) || event.getItemStack().getEnchantmentLevel(Enchantments.f_44987_) > 0 || event.getItemStack().getEnchantmentLevel(Enchantments.f_44985_) > 0 || event.getItemStack().getEnchantmentLevel(Enchantments.f_44982_) > 0) {
            return;
        }
        event.getToolTip().add(Component.m_237119_());
        event.getToolTip().add(Component.m_237115_((String)LUCKY_GOLD_TOOLTIP).m_130940_(ChatFormatting.GOLD));
    }
}

