/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mining.blockdefinition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinitionReloadListener;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.json.ILGsonHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.apache.commons.lang3.NotImplementedException;

@JsonAdapter(value=Serializer.class)
public class BlockDefinition {
    public Block block;
    public TagKey<Block> blockTag;
    private List<BlockState> blockStates = new ArrayList<BlockState>();
    @Nullable
    private Float stateHardness;
    @Nullable
    private Boolean stateRequiresCorrectToolForDrops;
    @Nullable
    private NoteBlockInstrument stateNoteBlockInstrument;
    @Nullable
    private MinMax stateExperienceDropped;
    @Nullable
    public Float explosionResistance;
    @Nullable
    public Float friction;
    @Nullable
    public Float speedFactor;
    @Nullable
    public Float jumpFactor;
    @Nullable
    public Float boneMealFailChance;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<BlockDefinition>>(){}.getType();

    public BlockDefinition(Block block, List<BlockState> blockStates, @Nullable Float stateHardness, @Nullable Boolean stateRequiresCorrectToolForDrops, @Nullable NoteBlockInstrument stateNoteBlockInstrument, @Nullable MinMax stateExperienceDropped, @Nullable Float explosionResistance, @Nullable Float friction, @Nullable Float speedFactor, @Nullable Float jumpFactor, @Nullable Float boneMealFailChance) {
        this.block = block;
        this.blockStates = blockStates;
        this.stateHardness = stateHardness;
        this.stateRequiresCorrectToolForDrops = stateRequiresCorrectToolForDrops;
        this.stateNoteBlockInstrument = stateNoteBlockInstrument;
        this.stateExperienceDropped = stateExperienceDropped;
        this.explosionResistance = explosionResistance;
        this.friction = friction;
        this.speedFactor = speedFactor;
        this.jumpFactor = jumpFactor;
        this.boneMealFailChance = boneMealFailChance;
    }

    public BlockDefinition(TagKey<Block> blockTag, @Nullable Float stateHardness, @Nullable Boolean stateRequiresCorrectToolForDrops, @Nullable NoteBlockInstrument stateNoteBlockInstrument, @Nullable MinMax stateExperienceDropped, @Nullable Float explosionResistance, @Nullable Float friction, @Nullable Float speedFactor, @Nullable Float jumpFactor, @Nullable Float boneMealFailChance) {
        this.blockTag = blockTag;
        this.stateHardness = stateHardness;
        this.stateRequiresCorrectToolForDrops = stateRequiresCorrectToolForDrops;
        this.stateNoteBlockInstrument = stateNoteBlockInstrument;
        this.stateExperienceDropped = stateExperienceDropped;
        this.explosionResistance = explosionResistance;
        this.friction = friction;
        this.speedFactor = speedFactor;
        this.jumpFactor = jumpFactor;
        this.boneMealFailChance = boneMealFailChance;
    }

    public BlockDefinition(Block block) {
        this.block = block;
    }

    public BlockDefinition(TagKey<Block> blockTag) {
        this.blockTag = blockTag;
    }

    public boolean matches(BlockState state) {
        if (this.block != null) {
            if (!state.m_60713_(this.block)) {
                return false;
            }
            if (this.blockStates.isEmpty()) {
                return true;
            }
            for (BlockState blockState : this.blockStates) {
                if (blockState != state) continue;
                return true;
            }
            return false;
        }
        return state.m_204336_(this.blockTag);
    }

    public int getStateExperienceDropped(RandomSource random) {
        return this.stateExperienceDropped == null ? -1 : this.stateExperienceDropped.getIntRandBetween(random);
    }

    public void apply(boolean applyingOriginal) {
        BlockDefinition originalDefinition;
        if (this.block != null) {
            originalDefinition = new BlockDefinition(this.block);
            this.block.m_49965_().m_61056_().forEach(blockState -> {
                if (this.blockStates.isEmpty() || this.blockStates.contains(blockState)) {
                    originalDefinition.blockStates.add((BlockState)blockState);
                    if (this.stateHardness != null) {
                        originalDefinition.stateHardness = Float.valueOf(blockState.f_60599_);
                        blockState.f_60599_ = this.stateHardness.floatValue();
                    }
                    if (this.stateRequiresCorrectToolForDrops != null) {
                        originalDefinition.stateRequiresCorrectToolForDrops = blockState.f_60600_;
                        blockState.f_60600_ = this.stateRequiresCorrectToolForDrops;
                    }
                    if (this.stateNoteBlockInstrument != null) {
                        originalDefinition.stateNoteBlockInstrument = blockState.f_279617_;
                        blockState.f_279617_ = this.stateNoteBlockInstrument;
                    }
                }
            });
            if (this.explosionResistance != null) {
                originalDefinition.explosionResistance = Float.valueOf(this.block.f_60444_);
                this.block.f_60444_ = this.explosionResistance.floatValue();
            }
            if (this.friction != null) {
                originalDefinition.friction = Float.valueOf(this.block.f_60447_);
                this.block.f_60447_ = this.friction.floatValue();
            }
            if (this.speedFactor != null) {
                originalDefinition.speedFactor = Float.valueOf(this.block.f_60448_);
                this.block.f_60448_ = this.speedFactor.floatValue();
            }
            if (this.jumpFactor != null) {
                originalDefinition.jumpFactor = Float.valueOf(this.block.f_60449_);
                this.block.f_60449_ = this.jumpFactor.floatValue();
            }
        } else {
            originalDefinition = new BlockDefinition(this.blockTag);
            ITag blockTag = ForgeRegistries.BLOCKS.tags().getTag(this.blockTag);
            blockTag.stream().forEach(block -> {
                block.m_49965_().m_61056_().forEach(blockState -> {
                    if (this.stateHardness != null) {
                        originalDefinition.stateHardness = Float.valueOf(blockState.f_60599_);
                        blockState.f_60599_ = this.stateHardness.floatValue();
                    }
                    if (this.stateRequiresCorrectToolForDrops != null) {
                        originalDefinition.stateRequiresCorrectToolForDrops = blockState.f_60600_;
                        blockState.f_60600_ = this.stateRequiresCorrectToolForDrops;
                    }
                    if (this.stateNoteBlockInstrument != null) {
                        originalDefinition.stateNoteBlockInstrument = blockState.f_279617_;
                        blockState.f_279617_ = this.stateNoteBlockInstrument;
                    }
                });
                if (this.explosionResistance != null) {
                    originalDefinition.explosionResistance = Float.valueOf(block.f_60444_);
                    block.f_60444_ = this.explosionResistance.floatValue();
                }
                if (this.friction != null) {
                    originalDefinition.friction = Float.valueOf(block.f_60447_);
                    block.f_60447_ = this.friction.floatValue();
                }
                if (this.speedFactor != null) {
                    originalDefinition.speedFactor = Float.valueOf(block.f_60448_);
                    block.f_60448_ = this.speedFactor.floatValue();
                }
                if (this.jumpFactor != null) {
                    originalDefinition.jumpFactor = Float.valueOf(block.f_60449_);
                    block.f_60449_ = this.jumpFactor.floatValue();
                }
            });
        }
        if (!applyingOriginal) {
            BlockDefinitionReloadListener.ORIGINAL_DEFINITIONS.add(originalDefinition);
        }
    }

    public static BlockDefinition fromNetwork(FriendlyByteBuf byteBuf) {
        Block block = (Block)byteBuf.m_236868_(b -> (Block)b.m_236816_((IdMap)BuiltInRegistries.f_256975_));
        ResourceLocation blockTagId = (ResourceLocation)byteBuf.m_236868_(FriendlyByteBuf::m_130281_);
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        TagKey blockTag = null;
        if (block != null) {
            int stateCount = byteBuf.readByte();
            for (int i = 0; i < stateCount; ++i) {
                PropertiesAndValues propertiesAndValues = PropertiesAndValues.of(block.m_49965_(), byteBuf.m_130277_());
                block.m_49965_().m_61056_().forEach(blockState -> {
                    if (propertiesAndValues.match((BlockState)blockState)) {
                        blockStates.add((BlockState)blockState);
                    }
                });
            }
        } else {
            blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)blockTagId);
        }
        Float hardness = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        Boolean requiresCorrectToolForDrops = (Boolean)byteBuf.m_236868_(FriendlyByteBuf::readBoolean);
        NoteBlockInstrument noteBlockInstrument = (NoteBlockInstrument)byteBuf.m_236868_(buf -> (NoteBlockInstrument)buf.m_130066_(NoteBlockInstrument.class));
        MinMax experienceDropped = (MinMax)byteBuf.m_236868_(b -> new MinMax(b.readDouble(), b.readDouble()));
        Float explosionResistance = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        Float friction = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        Float speedFactor = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        Float jumpFactor = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        Float boneMealFailChance = (Float)byteBuf.m_236868_(FriendlyByteBuf::readFloat);
        if (block != null) {
            return new BlockDefinition(block, blockStates, hardness, requiresCorrectToolForDrops, noteBlockInstrument, experienceDropped, explosionResistance, friction, speedFactor, jumpFactor, boneMealFailChance);
        }
        return new BlockDefinition((TagKey<Block>)blockTag, hardness, requiresCorrectToolForDrops, noteBlockInstrument, experienceDropped, explosionResistance, friction, speedFactor, jumpFactor, boneMealFailChance);
    }

    public void toNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.m_236821_((Object)this.block, (b, value) -> b.m_236818_((IdMap)BuiltInRegistries.f_256975_, value));
        byteBuf.m_236821_(this.blockTag, (b, value) -> b.m_130085_(value.f_203868_()));
        if (this.block != null) {
            byteBuf.writeByte(this.blockStates.size());
            for (BlockState state : this.blockStates) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Property property : state.m_61147_()) {
                    if (!stringBuilder.isEmpty()) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(property.m_61708_()).append("=").append(state.m_61143_(property));
                }
                byteBuf.m_130070_(stringBuilder.toString());
            }
        }
        byteBuf.m_236821_((Object)this.stateHardness, FriendlyByteBuf::writeFloat);
        byteBuf.m_236821_((Object)this.stateRequiresCorrectToolForDrops, FriendlyByteBuf::writeBoolean);
        byteBuf.m_236821_((Object)this.stateNoteBlockInstrument, FriendlyByteBuf::m_130068_);
        byteBuf.m_236821_((Object)this.stateExperienceDropped, (b, minMax) -> {
            b.writeDouble(minMax.min);
            b.writeDouble(minMax.max);
        });
        byteBuf.m_236821_((Object)this.explosionResistance, FriendlyByteBuf::writeFloat);
        byteBuf.m_236821_((Object)this.friction, FriendlyByteBuf::writeFloat);
        byteBuf.m_236821_((Object)this.speedFactor, FriendlyByteBuf::writeFloat);
        byteBuf.m_236821_((Object)this.jumpFactor, FriendlyByteBuf::writeFloat);
        byteBuf.m_236821_((Object)this.boneMealFailChance, FriendlyByteBuf::writeFloat);
    }

    public static class PropertiesAndValues
    extends ArrayList<PropertyAndValue<?>> {
        public static PropertiesAndValues of(StateDefinition definition, String string) {
            String[] split;
            PropertiesAndValues propertiesAndValues = new PropertiesAndValues();
            for (String s : split = string.split(",")) {
                propertiesAndValues.add(PropertyAndValue.of(definition, s));
            }
            return propertiesAndValues;
        }

        public boolean match(BlockState state) {
            for (PropertyAndValue propertyAndValue : this) {
                if (propertyAndValue.match(state)) continue;
                return false;
            }
            return true;
        }
    }

    public record PropertyAndValue<T extends Comparable<T>>(Property<T> property, T value) {
        static <T extends Comparable<T>> PropertyAndValue<?> of(StateDefinition definition, String string) {
            String[] split = string.split("=", 2);
            Property prop = definition.m_61081_(split[0]);
            if (prop == null) {
                throw new NullPointerException("Property %s doesn't belong to %s".formatted(split[0], definition));
            }
            Comparable value = (Comparable)prop.m_6215_(split[1]).orElseThrow();
            return new PropertyAndValue<Comparable>(prop, value);
        }

        boolean match(BlockState state) {
            return state.m_61143_(this.property) == this.value;
        }
    }

    public static class Serializer
    implements JsonDeserializer<BlockDefinition>,
    JsonSerializer<BlockDefinition> {
        public BlockDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            Float hardness = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"state_hardness");
            Boolean requiresCorrectToolForDrops = ILGsonHelper.getAsNullableBoolean((JsonObject)jObject, (String)"state_requires_correct_tool_for_drops");
            NoteBlockInstrument instrument = null;
            if (jObject.has("state_instrument")) {
                String stringInstrument = GsonHelper.m_13906_((JsonObject)jObject, (String)"state_instrument");
                instrument = Arrays.stream(NoteBlockInstrument.values()).filter(noteBlockInstrument -> noteBlockInstrument.m_7912_().equals(stringInstrument)).findFirst().orElseThrow();
            }
            MinMax experienceDropped = (MinMax)context.deserialize(jObject.get("state_experience_dropped"), MinMax.class);
            Float explosionResistance = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"explosion_resistance");
            Float friction = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"friction");
            Float speedFactor = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"speed_factor");
            Float jumpFactor = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"jump_factor");
            Float boneMealFailChance = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"bone_meal_fail_chance");
            if (jObject.has("block_tag") && jObject.has("states")) {
                throw new JsonParseException("`block_tag` and `states` cannot be used together");
            }
            if (!jObject.has("block") && !jObject.has("block_tag")) {
                throw new JsonParseException("Either `block` or `block_tag` must be present");
            }
            boolean required = GsonHelper.m_13855_((JsonObject)jObject, (String)"required", (boolean)true);
            if (jObject.has("block")) {
                String sBlockId = jObject.get("block").getAsString();
                ResourceLocation blockId = ResourceLocation.m_135820_((String)sBlockId);
                if (blockId == null) {
                    throw new JsonParseException("Failed to parse block id for %s".formatted(sBlockId));
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
                if (block == Blocks.f_50016_) {
                    if (!required) {
                        return null;
                    }
                    throw new JsonParseException("Failed to get block for %s".formatted(sBlockId));
                }
                ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
                if (jObject.has("states")) {
                    JsonArray array = jObject.getAsJsonArray("states");
                    for (JsonElement element : array) {
                        PropertiesAndValues propertyAndValues = PropertiesAndValues.of(block.m_49965_(), element.getAsString());
                        block.m_49965_().m_61056_().forEach(blockState -> {
                            if (propertyAndValues.match((BlockState)blockState)) {
                                blockStates.add((BlockState)blockState);
                            }
                        });
                    }
                }
                return new BlockDefinition(block, blockStates, hardness, requiresCorrectToolForDrops, instrument, experienceDropped, explosionResistance, friction, speedFactor, jumpFactor, boneMealFailChance);
            }
            ResourceLocation blockTagId = ResourceLocation.m_135820_((String)jObject.get("block_tag").getAsString());
            if (blockTagId == null) {
                throw new JsonParseException("Failed to parse block tag id for %s".formatted(jObject.get("block_tag").getAsString()));
            }
            TagKey blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)blockTagId);
            return new BlockDefinition((TagKey<Block>)blockTag, hardness, requiresCorrectToolForDrops, instrument, experienceDropped, explosionResistance, friction, speedFactor, jumpFactor, boneMealFailChance);
        }

        public JsonElement serialize(BlockDefinition src, Type typeOfSrc, JsonSerializationContext context) {
            throw new NotImplementedException();
        }
    }
}

