/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLLoader;

@Label(name="Nerfs", description="Various Nerfs")
@LoadFeature(module="iguanatweaksreborn:misc")
public class Nerfs
extends Feature {
    static final String LAST_FISHING_POS_TAG = "iguanatweaksreborn:last_fishing_pos";
    static final String LAST_FISHING_COUNT_TAG = "iguanatweaksreborn:last_fishing_count";
    @Config
    @Label(name="Iron from Golems only when killed by Players", description="If true, Iron golems will only drop Iron when killed by the player.")
    public static Boolean ironRequiresPlayer = true;
    @Config
    @Label(name="No Coordinates", description="If true, renderDebugInfo is enabled by default. Requires a world restart. This also changes Caverns and Chasms from displaying coordinates with compasses.")
    public static Boolean noCoordinates = true;
    @Config
    @Label(name="Reduced mob cramming", description="If true, maxEntityCramming game rule is set to 6 from 24")
    public static Boolean reducedMobCramming = true;
    @Config
    @Label(name="Less burn time for Kelp block", description="Kelp blocks smelt 16 items instead of 20")
    public static Boolean lessBurnTimeForKelpBlock = true;
    @Config
    @Label(name="Remove Falling Block Dupe across dimensions", description="Prevents duping falling blocks when they travel across dimensions. (If quark is present this is disabled)")
    public static Boolean removeFallingBlockDupe = true;
    @Config
    @Label(name="Remove piston physics exploit", description="Fixes several piston physics exploits like TNT duping. (If quark is present this is disabled)")
    public static Boolean removePistonPhysicsExploit = true;
    @Config(min=0.0, max=1.0)
    @Label(name="Fishing has a chance to fish a guardian")
    public static Double fishingCreatureChance = 0.0;
    @Config
    @Label(name="No fish if fishing in the same spot", description="If enabled after fishing for a few times in the same spot you won't be able to fish again unless you move in another spot")
    public static Boolean antiFishingFarms = true;
    @Config(min=0.0, max=1.0)
    @Label(description="When an entity is hit and on a mount they have this chance to fall")
    public static Double fallFromMountChance = 0.2;
    @Config
    @Label(description="If true, only players are affected by 'Fall from mount chance'")
    public static Boolean fallFromMountPlayerOnly = true;
    @Config(min=0.0)
    @Label(name="Prone mining speed multiplier", description="When prone your mining speed is multiplied by this")
    public static Double proneMiningSpeedMultiplier = 0.5;

    public Nerfs(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (!noCoordinates.booleanValue() || ModList.get().isLoaded("caverns_and_chasms")) {
            // empty if block
        }
    }

    public static boolean isFallingBlockDupeRemoved() {
        return Nerfs.isEnabled(Nerfs.class) && removeFallingBlockDupe != false;
    }

    public static boolean isPistonPhysicsExploitEnabled() {
        return Nerfs.isEnabled(Nerfs.class) && removePistonPhysicsExploit != false;
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ironRequiresPlayer.booleanValue() && event.getEntity() instanceof IronGolem && !(event.getSource().m_7640_() instanceof Player)) {
            event.getDrops().removeIf(itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42416_));
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || proneMiningSpeedMultiplier == 0.0 || event.getEntity().m_20089_() != Pose.SWIMMING) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * proneMiningSpeedMultiplier.floatValue());
    }

    @SubscribeEvent
    public void onPlayerHit(LivingDamageEvent event) {
        if (!this.isEnabled() || !event.getEntity().m_20159_() || !(event.getSource().m_7639_() instanceof LivingEntity) && !event.getEntity().m_9236_().f_46443_ || fallFromMountChance == 0.0) {
            return;
        }
        if (fallFromMountPlayerOnly.booleanValue() && !(event.getEntity() instanceof Player)) {
            return;
        }
        if ((double)event.getEntity().m_217043_().m_188501_() < fallFromMountChance) {
            event.getEntity().m_8127_();
            event.getEntity().m_9236_().m_6269_(null, (Entity)event.getEntity(), SoundEvents.f_11675_, event.getEntity().m_5720_(), 1.0f, 0.5f);
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (noCoordinates.booleanValue() && FMLLoader.isProduction()) {
            ((GameRules.BooleanValue)event.getServer().m_129900_().m_46170_(GameRules.f_46145_)).m_46246_(true, event.getServer());
        }
        if (reducedMobCramming.booleanValue()) {
            ((GameRules.IntegerValue)event.getServer().m_129900_().m_46170_(GameRules.f_46149_)).m_151489_(6, event.getServer());
        }
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (!(this.isEnabled() && lessBurnTimeForKelpBlock.booleanValue() && event.getItemStack().m_150930_(Items.f_42515_))) {
            return;
        }
        event.setBurnTime(3200);
    }

    @SubscribeEvent
    public void onRetrieveBobber(ItemFishedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Nerfs.trySummonGuardian(event);
        Nerfs.nerfAutoFishFarm(event);
    }

    public static void nerfAutoFishFarm(ItemFishedEvent event) {
        if (!antiFishingFarms.booleanValue() || event.getHookEntity().m_37168_() == null) {
            return;
        }
        CompoundTag persistentData = event.getHookEntity().m_37168_().getPersistentData();
        if (persistentData.m_128441_(LAST_FISHING_POS_TAG)) {
            BlockPos lastFishingPos = new BlockPos(persistentData.m_128465_(LAST_FISHING_POS_TAG)[0], persistentData.m_128465_(LAST_FISHING_POS_TAG)[1], persistentData.m_128465_(LAST_FISHING_POS_TAG)[2]);
            int distance = lastFishingPos.m_123333_((Vec3i)event.getHookEntity().m_20183_());
            int lastFishingCount = persistentData.m_128451_(LAST_FISHING_COUNT_TAG);
            if (distance <= 6) {
                if (++lastFishingCount >= 10) {
                    event.setCanceled(true);
                    event.getHookEntity().m_37168_().m_5661_((Component)Component.m_237115_((String)"iguanatweaksreborn.too_much_fishing_in_this_spot"), true);
                }
                persistentData.m_128405_(LAST_FISHING_COUNT_TAG, lastFishingCount);
            } else {
                persistentData.m_128385_(LAST_FISHING_POS_TAG, new int[]{event.getHookEntity().m_146903_(), event.getHookEntity().m_146904_(), event.getHookEntity().m_146907_()});
                persistentData.m_128405_(LAST_FISHING_COUNT_TAG, 0);
            }
        } else {
            persistentData.m_128385_(LAST_FISHING_POS_TAG, new int[]{event.getHookEntity().m_146903_(), event.getHookEntity().m_146904_(), event.getHookEntity().m_146907_()});
        }
    }

    public static void trySummonGuardian(ItemFishedEvent event) {
        if (fishingCreatureChance == 0.0 || (double)event.getHookEntity().m_9236_().f_46441_.m_188501_() > fishingCreatureChance) {
            return;
        }
        LivingEntity guardian = (LivingEntity)EntityType.f_20455_.m_20615_(event.getHookEntity().m_9236_());
        guardian.m_146884_(event.getHookEntity().m_20182_().m_82520_(0.0, (double)guardian.m_20206_(), 0.0));
        Player player = event.getHookEntity().m_37168_();
        double d0 = player.m_20185_() - event.getHookEntity().m_20185_();
        double d1 = player.m_20186_() - event.getHookEntity().m_20186_();
        double d2 = player.m_20189_() - event.getHookEntity().m_20189_();
        guardian.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
        event.getHookEntity().m_9236_().m_7967_((Entity)guardian);
        event.setCanceled(true);
    }
}

