/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.beaconconduit;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconBlock;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconBlockEntity;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconMenu;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.world.effect.ILMobEffect;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Beacon & Conduit", description="Beacon has been redesigned to have more effects and range based off blocks used for pyramid. Effects and blocks ranges are controlled via json config in this feature's folder.")
@LoadFeature(module="iguanatweaksreborn:misc")
public class BeaconConduit
extends JsonFeature {
    public static final SimpleBlockWithItem BEACON = SimpleBlockWithItem.register("beacon", () -> new ISOBeaconBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50273_)));
    public static final RegistryObject<BlockEntityType<ISOBeaconBlockEntity>> BEACON_BLOCK_ENTITY_TYPE = ISORegistries.BLOCK_ENTITY_TYPES.register("beacon", () -> BlockEntityType.Builder.m_155273_(ISOBeaconBlockEntity::new, (Block[])new Block[]{(Block)BEACON.block().get()}).m_58966_(null));
    public static final RegistryObject<MenuType<ISOBeaconMenu>> BEACON_MENU_TYPE = ISORegistries.MENU_TYPES.register("beacon", () -> new MenuType(ISOBeaconMenu::new, FeatureFlags.f_244377_));
    public static final RegistryObject<MobEffect> BLOCK_REACH = ISORegistries.MOB_EFFECTS.register("block_reach", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8489108).m_19472_((Attribute)ForgeMod.BLOCK_REACH.get(), "bd0c6709-4b67-43d5-ae51-c6180d848978", 0.5, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<MobEffect> ENTITY_REACH = ISORegistries.MOB_EFFECTS.register("entity_reach", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8489108).m_19472_((Attribute)ForgeMod.ENTITY_REACH.get(), "fb23063a-c676-4da0-8d75-574ab8f3ee30", (double)0.075f, AttributeModifier.Operation.MULTIPLY_BASE));
    public static final ArrayList<IdTagValue> BLOCKS_LIST_DEFAULT = new ArrayList<IdTagValue>(List.of(new IdTagValue(IdTagMatcher.Type.ID, "minecraft:iron_block", 1.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:emerald_block", 3.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:gold_block", 1.8), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:diamond_block", 2.5), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:netherite_block", 4.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:durium_block", 3.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:soul_steel_block", 1.5), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:quaron_block", 1.5), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:sanguine_block", 1.5), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:keego_block", 3.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:silver_block", 1.8), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:necromium_block", 4.0)));
    public static final ArrayList<IdTagValue> blocksList = new ArrayList();
    public static final ArrayList<IdTagValue> PAYMENT_TIMES_DEFAULT = new ArrayList<IdTagValue>(List.of(new IdTagValue(IdTagMatcher.Type.ID, "minecraft:iron_ingot", 6000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:gold_ingot", 18000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:diamond", 72000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:emerald", 72000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:netherite_ingot", 115200.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:durium_ingot", 12000.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:keego", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:quaron_ingot", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:living_flesh", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:soul_steel_ingot", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:silver_ingot", 18000.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:necromium_ingot", 115200.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:nether_star", 576000.0)));
    public static final ArrayList<IdTagValue> paymentTimes = new ArrayList();
    public static final ArrayList<BeaconEffect> EFFECTS_DEFAULT = new ArrayList<BeaconEffect>(List.of(new BeaconEffect(MobEffects.f_19596_, new int[]{1, 2, 4}), new BeaconEffect(MobEffects.f_19603_, new int[]{1, 2, 3}), new BeaconEffect("iguanatweaksreborn:block_reach", new int[]{1, 3, 9}), new BeaconEffect(MobEffects.f_19598_, new int[]{1, 2, 4}, 2), new BeaconEffect(MobEffects.f_19607_, new int[]{3}, 2), new BeaconEffect("stamina:vigour", new int[]{2, 5}, 2), new BeaconEffect(MobEffects.f_19609_, new int[]{2}, 2), new BeaconEffect(MobEffects.f_19620_, new int[]{1, 2, 3}, 2), new BeaconEffect(MobEffects.f_19600_, new int[]{1, 3, 9}, 3), new BeaconEffect(MobEffects.f_19606_, new int[]{1, 3, 9}, 3), new BeaconEffect(MobEffects.f_19611_, new int[]{3}, 3), new BeaconEffect(MobEffects.f_19591_, new int[]{2}, 3), new BeaconEffect(MobEffects.f_19605_, new int[]{8}, 4), new BeaconEffect("iguanatweaksreborn:regenerating_absorption", new int[]{2, 4}, 4), new BeaconEffect("iguanatweaksreborn:entity_reach", new int[]{1, 3, 9}, 4)));
    public static final ArrayList<BeaconEffect> effects = new ArrayList();
    @Config
    @Label(name="Conduit.Better Protection", description="Greatly increases the range and damage of the conduit")
    public static Boolean betterConduitProtection = true;
    @Config(min=0.0, max=64.0)
    @Label(name="Conduit.Protection Distance Multiplier", description="Distance multiplier (formula is `blocks_around / 7 * this_multiplier`) from the conduit at which it will deal damage to enemies.")
    public static Double conduitProtectionDistanceMultiplier = 8.0;
    @Config(min=0.0, max=96.0)
    @Label(name="Conduit.Protection Max Damage Distance", description="If a mob is within this radius from the conduit, it will be dealt the maximum amount of damage.")
    public static Double conduitProtectionMaxDamageDistance = 8.0;
    @Nullable
    static BeaconEffect cachedBeaconEffect;
    static float MIN_DAMAGE;
    static float MAX_DAMAGE;

    public BeaconConduit(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("beacon_blocks_ranges.json", blocksList, BLOCKS_LIST_DEFAULT, IdTagValue.LIST_TYPE));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("beacon_payment_times.json", paymentTimes, PAYMENT_TIMES_DEFAULT, IdTagValue.LIST_TYPE));
        BeaconConduit.addSyncType((ResourceLocation)new ResourceLocation("iguanatweaksreborn", "beacon_effects"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> BeaconConduit.loadAndReadJson((String)json, effects, EFFECTS_DEFAULT, (Type)BeaconEffect.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("beacon_effects.json", effects, EFFECTS_DEFAULT, BeaconEffect.LIST_TYPE, (list, isClientSide) -> list.removeIf(beaconEffect -> beaconEffect.getEffect() == null), true, new ResourceLocation("iguanatweaksreborn", "beacon_effects")));
        InsaneSurvivalOverhaul.addServerPack("better_beacon", "Insane's Survival Overhaul Better Beacon", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false);
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public static int getPaymentTime(ItemStack stack) {
        for (IdTagValue idTagValue : paymentTimes) {
            if (!idTagValue.id.matchesItem(stack.m_41720_())) continue;
            return (int)idTagValue.value;
        }
        return 0;
    }

    public static int getEffectTimeScale(@Nullable MobEffect mobEffect, int amplifier) {
        if (cachedBeaconEffect != null && Objects.equals(mobEffect, cachedBeaconEffect.getEffect())) {
            return cachedBeaconEffect.getTimeCostForAmplifier(amplifier);
        }
        for (BeaconEffect beaconEffect : effects) {
            if (!beaconEffect.location.equals((Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect))) continue;
            cachedBeaconEffect = beaconEffect;
            return beaconEffect.getTimeCostForAmplifier(amplifier);
        }
        return 1;
    }

    public static boolean isValidEffect(MobEffect mobEffect) {
        for (BeaconEffect beaconEffect : effects) {
            if (!beaconEffect.location.equals((Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect))) continue;
            return true;
        }
        return false;
    }

    public static boolean conduitUpdateDestroyEnemies(Level level, BlockPos blockPos, List<BlockPos> blocks) {
        if (!BeaconConduit.isEnabled(BeaconConduit.class) || !betterConduitProtection.booleanValue()) {
            return false;
        }
        LivingEntity nearestEntity = level.m_45963_(LivingEntity.class, TargetingConditions.m_148353_().m_26888_(livingEntity -> livingEntity instanceof Enemy && livingEntity.m_20070_()), null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), BeaconConduit.getDamageAABB(blockPos, blocks));
        if (nearestEntity == null) {
            return true;
        }
        level.m_6263_(null, nearestEntity.m_20185_(), nearestEntity.m_20186_(), nearestEntity.m_20189_(), SoundEvents.f_11823_, SoundSource.BLOCKS, 1.0f, 1.0f);
        double distance = nearestEntity.m_20182_().m_82554_(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
        float damage = distance < conduitProtectionMaxDamageDistance ? MAX_DAMAGE : (float)(1.0 - (distance - conduitProtectionMaxDamageDistance) / (BeaconConduit.maxRangeRadius() - conduitProtectionMaxDamageDistance)) * (MAX_DAMAGE - MIN_DAMAGE) + MIN_DAMAGE;
        nearestEntity.m_6469_(nearestEntity.m_269291_().m_269425_(), damage);
        return true;
    }

    private static AABB getDamageAABB(BlockPos blockPos, List<BlockPos> blocks) {
        double range = (double)blocks.size() / 7.0 * conduitProtectionDistanceMultiplier;
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        return new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).m_82400_(range);
    }

    private static double maxRange() {
        return 6.0 * conduitProtectionDistanceMultiplier;
    }

    private static double maxRangeRadius() {
        return Math.sqrt(BeaconConduit.maxRange() * BeaconConduit.maxRange() + BeaconConduit.maxRange() * BeaconConduit.maxRange());
    }

    static {
        MIN_DAMAGE = 2.0f;
        MAX_DAMAGE = 6.0f;
    }

    @JsonAdapter(value=Serializer.class)
    public static class BeaconEffect
    extends IdTagMatcher {
        int[] timeCost;
        int heightRequired;
        public static final Type LIST_TYPE = new TypeToken<ArrayList<BeaconEffect>>(){}.getType();

        public BeaconEffect(String location, int[] timeCost, int heightRequired) {
            super(IdTagMatcher.Type.ID, new ResourceLocation(location), null);
            this.timeCost = timeCost;
            this.heightRequired = heightRequired;
        }

        public BeaconEffect(MobEffect mobEffect, int[] timeCost, int heightRequired) {
            super(IdTagMatcher.Type.ID, ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect), null);
            this.timeCost = timeCost;
            this.heightRequired = heightRequired;
        }

        public BeaconEffect(String location, int[] timeCost) {
            this(location, timeCost, 1);
        }

        public BeaconEffect(MobEffect mobEffect, int[] timeCost) {
            this(mobEffect, timeCost, 1);
        }

        @Nullable
        public MobEffect getEffect() {
            if (!ForgeRegistries.MOB_EFFECTS.containsKey(this.location)) {
                LogHelper.warn((String)"No mob effect found with id %s", (Object[])new Object[]{this.location});
                return null;
            }
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.location);
        }

        public int getMaxAmplifier() {
            return this.timeCost.length - 1;
        }

        public int getHeightRequired() {
            return this.heightRequired;
        }

        public int getTimeCostForAmplifier(int amplifier) {
            if (this.timeCost.length <= amplifier) {
                return 1;
            }
            return this.timeCost[amplifier];
        }

        private static class Serializer
        implements JsonSerializer<BeaconEffect>,
        JsonDeserializer<BeaconEffect> {
            private Serializer() {
            }

            public BeaconEffect deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jObject = json.getAsJsonObject();
                int heightRequired = GsonHelper.m_13824_((JsonObject)jObject, (String)"height_required", (int)1);
                JsonArray jArray = jObject.getAsJsonArray("time_cost");
                if (jArray.size() > 8) {
                    throw new JsonParseException("time_cost size cannot be greater than 8");
                }
                ArrayList timeCost = new ArrayList();
                jArray.forEach(jsonElement -> timeCost.add(jsonElement.getAsInt()));
                return new BeaconEffect(GsonHelper.m_13906_((JsonObject)jObject, (String)"id"), timeCost.stream().mapToInt(i -> i).toArray(), heightRequired);
            }

            public JsonElement serialize(BeaconEffect src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jObject = new JsonObject();
                jObject.addProperty("id", src.location.toString());
                if (src.heightRequired > 1) {
                    jObject.addProperty("height_required", (Number)src.heightRequired);
                }
                jObject.addProperty("id", src.location.toString());
                JsonArray jArray = new JsonArray();
                for (int i = 0; i < src.timeCost.length; ++i) {
                    jArray.add((Number)src.timeCost[i]);
                }
                jObject.add("time_cost", (JsonElement)jArray);
                return jObject;
            }
        }
    }
}

