/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.beaconconduit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.BeaconConduit;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconMenu;
import insane96mcp.insanelib.data.IdTagValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class ISOBeaconBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
Nameable,
StackedContentsCompatible {
    private static final int MAX_LEVELS = 8;
    public static final int DATA_EFFECT = 0;
    public static final int DATA_AMPLIFIER = 1;
    public static final int DATA_TIME_LEFT = 2;
    public static final int DATA_LAYERS = 3;
    public static final int DATA_COUNT = 4;
    public static final int SLOT_COUNT = 1;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final Component DEFAULT_NAME = Component.m_237115_((String)"container.beacon");
    List<BeaconBeamSection> beamSections = Lists.newArrayList();
    private List<BeaconBeamSection> checkingBeamSections = Lists.newArrayList();
    int layers;
    private int lastCheckY;
    @Nullable
    MobEffect effect;
    int amplifier;
    int timeLeft;
    static final int MAX_TIME_LEFT = 576000;
    @Nullable
    private Component name;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            switch (id) {
                case 0: {
                    return MobEffect.m_216882_((MobEffect)ISOBeaconBlockEntity.this.effect);
                }
                case 1: {
                    return ISOBeaconBlockEntity.this.amplifier;
                }
                case 2: {
                    return ISOBeaconBlockEntity.this.timeLeft;
                }
                case 3: {
                    return ISOBeaconBlockEntity.this.layers;
                }
            }
            return 0;
        }

        public void m_8050_(int id, int value) {
            switch (id) {
                case 0: {
                    if (!((ISOBeaconBlockEntity)ISOBeaconBlockEntity.this).f_58857_.f_46443_ && !ISOBeaconBlockEntity.this.beamSections.isEmpty()) {
                        ISOBeaconBlockEntity.playSound(ISOBeaconBlockEntity.this.f_58857_, ISOBeaconBlockEntity.this.f_58858_, SoundEvents.f_11739_);
                    }
                    ISOBeaconBlockEntity.this.effect = MobEffect.m_19453_((int)value);
                    break;
                }
                case 1: {
                    ISOBeaconBlockEntity.this.amplifier = value;
                    break;
                }
                case 2: {
                    ISOBeaconBlockEntity.this.timeLeft = value;
                    break;
                }
                case 3: {
                    ISOBeaconBlockEntity.this.layers = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public ISOBeaconBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BeaconConduit.BEACON_BLOCK_ENTITY_TYPE.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ISOBeaconBlockEntity beacon) {
        BlockPos blockpos;
        int x = pPos.m_123341_();
        int y = pPos.m_123342_();
        int z = pPos.m_123343_();
        if (beacon.lastCheckY < y) {
            blockpos = pPos;
            beacon.checkingBeamSections = Lists.newArrayList();
            beacon.lastCheckY = pPos.m_123342_() - 1;
        } else {
            blockpos = new BlockPos(x, beacon.lastCheckY + 1, z);
        }
        BeaconBeamSection SRBeaconBlockEntity$beaconbeamsection = beacon.checkingBeamSections.isEmpty() ? null : beacon.checkingBeamSections.get(beacon.checkingBeamSections.size() - 1);
        int ySurface = pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        for (int i1 = 0; i1 < 10 && blockpos.m_123342_() <= ySurface; ++i1) {
            BlockState blockstate = pLevel.m_8055_(blockpos);
            float[] afloat = blockstate.getBeaconColorMultiplier((LevelReader)pLevel, blockpos, pPos);
            if (afloat != null) {
                if (beacon.checkingBeamSections.size() <= 1) {
                    SRBeaconBlockEntity$beaconbeamsection = new BeaconBeamSection(afloat);
                    beacon.checkingBeamSections.add(SRBeaconBlockEntity$beaconbeamsection);
                } else if (SRBeaconBlockEntity$beaconbeamsection != null) {
                    if (Arrays.equals(afloat, SRBeaconBlockEntity$beaconbeamsection.color)) {
                        SRBeaconBlockEntity$beaconbeamsection.increaseHeight();
                    } else {
                        SRBeaconBlockEntity$beaconbeamsection = new BeaconBeamSection(new float[]{(SRBeaconBlockEntity$beaconbeamsection.color[0] + afloat[0]) / 2.0f, (SRBeaconBlockEntity$beaconbeamsection.color[1] + afloat[1]) / 2.0f, (SRBeaconBlockEntity$beaconbeamsection.color[2] + afloat[2]) / 2.0f});
                        beacon.checkingBeamSections.add(SRBeaconBlockEntity$beaconbeamsection);
                    }
                }
            } else {
                if (SRBeaconBlockEntity$beaconbeamsection == null || blockstate.m_60739_((BlockGetter)pLevel, blockpos) >= 15 && !blockstate.m_60713_(Blocks.f_50752_)) {
                    beacon.checkingBeamSections.clear();
                    beacon.lastCheckY = ySurface;
                    break;
                }
                SRBeaconBlockEntity$beaconbeamsection.increaseHeight();
            }
            blockpos = blockpos.m_7494_();
            ++beacon.lastCheckY;
        }
        int lvl = beacon.layers;
        if (!BeaconConduit.isValidEffect(beacon.effect)) {
            beacon.effect = null;
        }
        if (lvl > 0 && beacon.effect != null && beacon.timeLeft > 0) {
            beacon.timeLeft -= BeaconConduit.getEffectTimeScale(beacon.effect, beacon.amplifier);
        }
        if (pLevel.m_46467_() % 80L == 0L) {
            if (!beacon.beamSections.isEmpty()) {
                beacon.layers = ISOBeaconBlockEntity.updateBase(pLevel, x, y, z);
            }
            if (beacon.timeLeft > 0 && beacon.layers > 0 && !beacon.beamSections.isEmpty()) {
                ISOBeaconBlockEntity.applyEffects(pLevel, pPos, beacon.layers, beacon.effect, beacon.amplifier);
                ISOBeaconBlockEntity.playSound(pLevel, pPos, SoundEvents.f_11737_);
            }
        }
        if (beacon.effect != null && pLevel.m_46467_() % 10L == 0L && !((ItemStack)beacon.items.get(0)).m_41619_()) {
            int timeLeftAmount = BeaconConduit.getPaymentTime((ItemStack)beacon.items.get(0));
            if (beacon.timeLeft <= 576000) {
                beacon.timeLeft += timeLeftAmount;
                beacon.m_7407_(0, 1);
            }
        }
        if (beacon.lastCheckY >= ySurface) {
            beacon.lastCheckY = pLevel.m_141937_() - 1;
            boolean hasLevels = lvl > 0;
            beacon.beamSections = beacon.checkingBeamSections;
            if (!pLevel.f_46443_) {
                boolean flag1;
                boolean bl = flag1 = beacon.layers > 0;
                if (!hasLevels && flag1) {
                    ISOBeaconBlockEntity.playSound(pLevel, pPos, SoundEvents.f_11736_);
                    pLevel.m_45976_(ServerPlayer.class, new AABB((double)x, (double)y, (double)z, (double)x, (double)(y - 4), (double)z).m_82377_(10.0, 5.0, 10.0)).forEach(serverplayer -> CriteriaTriggers.f_10578_.m_148029_(serverplayer, beacon.layers));
                } else if (hasLevels && !flag1) {
                    ISOBeaconBlockEntity.playSound(pLevel, pPos, SoundEvents.f_11738_);
                }
            }
        }
    }

    private static int updateBase(Level level, int beaconX, int beaconY, int beaconZ) {
        int y;
        int i = 0;
        int yRel = 1;
        while (yRel <= 8 && (y = beaconY - yRel) >= level.m_141937_()) {
            boolean isBeaconBaseBlock = true;
            block1: for (int x = beaconX - yRel; x <= beaconX + yRel && isBeaconBaseBlock; ++x) {
                for (int z = beaconZ - yRel; z <= beaconZ + yRel; ++z) {
                    if (level.m_8055_(new BlockPos(x, y, z)).m_204336_(BlockTags.f_13079_)) continue;
                    isBeaconBaseBlock = false;
                    continue block1;
                }
            }
            if (!isBeaconBaseBlock) break;
            i = yRel++;
        }
        return i;
    }

    public void m_7651_() {
        ISOBeaconBlockEntity.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11738_);
        super.m_7651_();
    }

    private static void applyEffects(Level pLevel, BlockPos pPos, int layers, @Nullable MobEffect effect, int amplifier) {
        if (pLevel.f_46443_ || effect == null) {
            return;
        }
        double d0 = 10.0 + ISOBeaconBlockEntity.getBeaconRange(pLevel, pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_(), layers);
        AABB aabb = new AABB(pPos).m_82400_(d0).m_82363_(0.0, (double)pLevel.m_141928_(), 0.0);
        List list = pLevel.m_6443_(LivingEntity.class, aabb, livingEntity -> {
            OwnableEntity ownableEntity;
            return livingEntity instanceof Player || livingEntity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)livingEntity).m_269323_() != null;
        });
        for (LivingEntity livingEntity2 : list) {
            livingEntity2.m_7292_(new MobEffectInstance(effect, 240, amplifier, true, true));
        }
    }

    private static double getBeaconRange(Level level, int x, int y, int z, int layers) {
        HashMap<Block, Integer> blocksCount = new HashMap<Block, Integer>();
        for (int layer = 1; layer <= layers; ++layer) {
            int relativeY = y - layer;
            for (int relativeX = x - layer; relativeX <= x + layer; ++relativeX) {
                for (int relativeZ = z - layer; relativeZ <= z + layer; ++relativeZ) {
                    if (!level.m_8055_(new BlockPos(relativeX, relativeY, relativeZ)).m_204336_(BlockTags.f_13079_)) continue;
                    Block block = level.m_8055_(new BlockPos(relativeX, relativeY, relativeZ)).m_60734_();
                    blocksCount.merge(block, 1, Integer::sum);
                }
            }
        }
        double range = 1.0;
        for (Map.Entry entry : blocksCount.entrySet()) {
            Optional<IdTagValue> optional = BeaconConduit.blocksList.stream().filter(idTagValue -> idTagValue.id.matchesBlock((Block)entry.getKey())).findFirst();
            if (!optional.isPresent()) continue;
            range += optional.get().value * (double)((Integer)entry.getValue()).intValue() / (double)layers;
        }
        return range;
    }

    public static void playSound(Level pLevel, BlockPos pPos, SoundEvent pSound) {
        pLevel.m_5594_(null, pPos, pSound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public List<BeaconBeamSection> getBeamSections() {
        return this.layers == 0 ? ImmutableList.of() : this.beamSections;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.effect = MobEffect.m_19453_((int)pTag.m_128451_("Effect"));
        this.amplifier = pTag.m_128451_("Amplifier");
        this.timeLeft = pTag.m_128451_("TimeLeft");
        if (pTag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)pTag.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("Effect", MobEffect.m_216882_((MobEffect)this.effect));
        pTag.m_128405_("Amplifier", this.amplifier);
        pTag.m_128405_("TimeLeft", this.timeLeft);
        pTag.m_128405_("Levels", this.layers);
        if (this.name != null) {
            pTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public void m_58638_(@Nullable Component pName) {
        this.name = pName;
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"iguanatweaksreborn.container.beacon");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new ISOBeaconMenu(pContainerId, pInventory, (Container)this, this.dataAccess, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()));
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        this.lastCheckY = pLevel.m_141937_() - 1;
    }

    public int[] m_7071_(Direction side) {
        return new int[0];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction side) {
        return false;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction side) {
        return false;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.items.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_5809_(StackedContents pContents) {
        for (ItemStack itemstack : this.items) {
            pContents.m_36491_(itemstack);
        }
    }

    public static class BeaconBeamSection {
        final float[] color;
        private int height;

        public BeaconBeamSection(float[] pColor) {
            this.color = pColor;
            this.height = 1;
        }

        protected void increaseHeight() {
            ++this.height;
        }

        public float[] getColor() {
            return this.color;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

