/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.beaconconduit;

import com.google.common.collect.Lists;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.BeaconConduit;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconMenu;
import insane96mcp.iguanatweaksreborn.network.message.SetITRBeaconEffects;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class ISOBeaconScreen
extends AbstractContainerScreen<ISOBeaconMenu> {
    static final ResourceLocation BEACON_LOCATION = new ResourceLocation("iguanatweaksreborn:textures/gui/container/beacon.png");
    public final List<BeaconButton> beaconButtons = Lists.newArrayList();
    @Nullable
    MobEffect effect;
    int maxAmplifier;
    int amplifier;

    public ISOBeaconScreen(final ISOBeaconMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 230;
        this.f_97727_ = 219;
        pMenu.m_38893_(new ContainerListener(){

            public void m_7934_(AbstractContainerMenu abstractContainerMenu, int slot, ItemStack stack) {
            }

            public void m_142153_(AbstractContainerMenu abstractContainerMenu, int id, int value) {
                ISOBeaconScreen.this.effect = pMenu.getEffect();
                ISOBeaconScreen.this.updateMaxAmplifier();
                ISOBeaconScreen.this.amplifier = pMenu.getAmplifier();
            }
        });
    }

    private <T extends AbstractWidget> void addBeaconButton(T pBeaconButton) {
        this.m_142416_((GuiEventListener)pBeaconButton);
        this.beaconButtons.add((BeaconButton)pBeaconButton);
    }

    protected void m_7856_() {
        int i;
        super.m_7856_();
        this.beaconButtons.clear();
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        for (i = 0; i < 8; ++i) {
            BeaconAmplifierButton amplifierButton = new BeaconAmplifierButton(topLeftCornerX + 17 + i * 25, topLeftCornerY + 78, i);
            amplifierButton.f_93623_ = true;
            amplifierButton.f_93624_ = false;
            this.addBeaconButton(amplifierButton);
        }
        for (i = 0; i < BeaconConduit.effects.size(); ++i) {
            MobEffect mobeffect = BeaconConduit.effects.get(i).getEffect();
            int heightRequired = BeaconConduit.effects.get(i).getHeightRequired();
            BeaconPowerButton beaconEffectButton = new BeaconPowerButton(topLeftCornerX + 17 + i % 8 * 25, topLeftCornerY + 15 + i / 8 * 25, mobeffect, heightRequired);
            beaconEffectButton.f_93623_ = true;
            if (Objects.equals(this.effect, mobeffect)) {
                beaconEffectButton.setSelected(true);
            }
            this.addBeaconButton(beaconEffectButton);
        }
    }

    private void updateMaxAmplifier() {
        this.maxAmplifier = ((ISOBeaconMenu)this.f_97732_).getMaxAmplifier(this.effect);
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtons();
    }

    void updateButtons() {
        this.beaconButtons.forEach(BeaconButton::updateStatus);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(BEACON_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237113_((String)StringUtil.m_14404_((int)(((ISOBeaconMenu)this.f_97732_).getTimeLeft() / BeaconConduit.getEffectTimeScale(this.effect, this.amplifier)))), topLeftCornerX + 130, topLeftCornerY + 114, 0xFFFFFF);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    public static interface BeaconButton {
        public void updateStatus();
    }

    public class BeaconAmplifierButton
    extends BeaconScreenButton {
        public int amplifier;

        public BeaconAmplifierButton(int pX, int pY, int amplifier) {
            super(pX, pY, 13, 13, 88);
            this.setAmplifier(amplifier);
        }

        protected void setAmplifier(int amplifier) {
            this.amplifier = amplifier;
        }

        protected MutableComponent createEffectDescription(MobEffect effect) {
            MutableComponent component = Component.m_237115_((String)effect.m_19481_()).m_130946_(" ");
            return component.m_7220_(this.getEffectAmplifier()).m_7220_((Component)Component.m_237113_((String)" (Time cost: %s)".formatted(BeaconConduit.getEffectTimeScale(ISOBeaconScreen.this.effect, this.amplifier))));
        }

        private Component getEffectAmplifier() {
            return this.amplifier == 0 ? Component.m_237113_((String)"I") : Component.m_237115_((String)("potion.potency." + this.amplifier));
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                ISOBeaconScreen.this.amplifier = this.amplifier;
                SetITRBeaconEffects.updateServer(((ISOBeaconScreen)ISOBeaconScreen.this).f_96541_.f_91074_, ISOBeaconScreen.this.effect, this.amplifier);
                ISOBeaconScreen.this.updateButtons();
            }
        }

        @Override
        public void updateStatus() {
            this.f_93624_ = this.amplifier <= ISOBeaconScreen.this.maxAmplifier && ISOBeaconScreen.this.effect != null;
            this.f_93623_ = this.amplifier + 1 <= ((ISOBeaconMenu)ISOBeaconScreen.this.f_97732_).getLayers();
            this.setSelected(this.amplifier == ISOBeaconScreen.this.amplifier);
            if (ISOBeaconScreen.this.effect != null) {
                this.m_257544_(Tooltip.m_257563_((Component)this.createEffectDescription(ISOBeaconScreen.this.effect), null));
            }
        }

        @Override
        protected void renderIcon(GuiGraphics pGuiGraphics) {
            pGuiGraphics.m_280653_(((ISOBeaconScreen)ISOBeaconScreen.this).f_96541_.f_91062_, this.getEffectAmplifier(), this.m_252754_() + 7, this.m_252907_() + 3, 0xFFFFFF);
        }
    }

    public class BeaconPowerButton
    extends BeaconScreenButton {
        public MobEffect effect;
        public int heightRequired;
        private TextureAtlasSprite sprite;

        public BeaconPowerButton(int pX, int pY, MobEffect pEffect, int heightRequired) {
            super(pX, pY);
            this.setEffect(pEffect);
            this.heightRequired = heightRequired;
        }

        protected void setEffect(MobEffect pEffect) {
            this.effect = pEffect;
            this.sprite = Minecraft.m_91087_().m_91306_().m_118732_(pEffect);
            this.m_257544_(Tooltip.m_257563_((Component)this.createEffectDescription(pEffect), null));
        }

        protected MutableComponent createEffectDescription(MobEffect pEffect) {
            return Component.m_237115_((String)pEffect.m_19481_());
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                ISOBeaconScreen.this.effect = this.effect;
                ISOBeaconScreen.this.amplifier = 0;
                ISOBeaconScreen.this.updateMaxAmplifier();
                SetITRBeaconEffects.updateServer(((ISOBeaconScreen)ISOBeaconScreen.this).f_96541_.f_91074_, ISOBeaconScreen.this.effect, ISOBeaconScreen.this.amplifier);
                ISOBeaconScreen.this.updateButtons();
            }
        }

        @Override
        protected void renderIcon(GuiGraphics pGuiGraphics) {
            pGuiGraphics.m_280159_(this.m_252754_() + 2, this.m_252907_() + 2, 0, 18, 18, this.sprite);
        }

        @Override
        public void updateStatus() {
            boolean bl = this.f_93623_ = this.heightRequired <= ((ISOBeaconMenu)ISOBeaconScreen.this.f_97732_).getLayers();
            if (this.f_93623_) {
                this.m_257544_(Tooltip.m_257563_((Component)this.createEffectDescription(this.effect), null));
            } else {
                this.m_257544_(Tooltip.m_257563_((Component)Component.m_237115_((String)"iguanatweaksreborn.beacon_conduit.requires_higher_pyramid"), null));
            }
            this.setSelected(this.effect == ISOBeaconScreen.this.effect);
        }

        protected MutableComponent m_5646_() {
            return this.createEffectDescription(this.effect);
        }
    }

    static abstract class BeaconScreenButton
    extends AbstractButton
    implements BeaconButton {
        private boolean selected;
        int u;
        int v;

        protected BeaconScreenButton(int pX, int pY) {
            this(pX, pY, 22, 22, 0);
        }

        protected BeaconScreenButton(int pX, int pY, int width, int height, int u) {
            super(pX, pY, width, height, CommonComponents.f_237098_);
            this.u = u;
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            int i = 219;
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.selected) {
                j += this.f_93618_;
            } else if (this.m_198029_()) {
                j += this.f_93618_ * 3;
            }
            pGuiGraphics.m_280218_(BEACON_LOCATION, this.m_252754_(), this.m_252907_(), j + this.u, 219, this.f_93618_, this.f_93619_);
            this.renderIcon(pGuiGraphics);
        }

        protected abstract void renderIcon(GuiGraphics var1);

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean pSelected) {
            this.selected = pSelected;
        }

        public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
            this.m_168802_(pNarrationElementOutput);
        }
    }
}

