/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.spawning;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;

@Label(name="Season Spawning", description="Changes to mob spawn with Serene Seasons installed")
@LoadFeature(module="iguanatweaksreborn:mobs", requiresMods={"sereneseasons"})
public class SeasonSpawning
extends Feature {
    @Config
    @Label(name="Despawning.Winter", description="Despawn Distance on winter, note that lower values increase the mobs around the player. Vanilla is 128")
    public static Integer despawnDistanceWinter = 112;
    @Config
    @Label(name="Despawning.Spring", description="Despawn Distance on spring, note that lower values increase the mobs around the player. Vanilla is 128")
    public static Integer despawnDistanceSpring = 128;
    @Config
    @Label(name="Despawning.Summer", description="Despawn Distance on summer, note that lower values increase the mobs around the player. Vanilla is 128")
    public static Integer despawnDistanceSummer = 128;
    @Config
    @Label(name="Despawning.Autumn", description="Despawn Distance on autumn, note that lower values increase the mobs around the player. Vanilla is 128")
    public static Integer despawnDistanceAutumn = 128;
    @Config
    @Label(name="Hostile Cap.Winter", description="Hostile Mobs cap on winter.")
    public static Integer hostileCapWinter = 70;
    @Config
    @Label(name="Hostile Cap.Spring", description="Hostile Mobs cap on spring.")
    public static Integer hostileCapSpring = 70;
    @Config
    @Label(name="Hostile Cap.Summer", description="Hostile Mobs cap on summer.")
    public static Integer hostileCapSummer = 55;
    @Config
    @Label(name="Hostile Cap.Autumn", description="Hostile Mobs cap on autumn.")
    public static Integer hostileCapAutumn = 70;
    @Config
    @Label(name="Animals Cap.Winter", description="Animals Mobs cap on winter.")
    public static Integer animalsCapWinter = 0;
    @Config
    @Label(name="Animals Cap.Spring", description="Animals Mobs cap on spring.")
    public static Integer animalsCapSpring = 35;
    @Config
    @Label(name="Animals Cap.Summer", description="Animals Mobs cap on summer.")
    public static Integer animalsCapSummer = 55;
    @Config
    @Label(name="Animals Cap.Autumn", description="Animals Mobs cap on autumn.")
    public static Integer animalsCapAutumn = 15;
    @Config
    @Label(name="No Sea creature in cold seasons", description="Sea Creatures can no longer naturally spawn in Winter and will spawn less in autumn.")
    public static Boolean noSeaCreatureInColdSeasons = true;

    public SeasonSpawning(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public boolean isEnabled() {
        return super.isEnabled() && ModList.get().isLoaded("sereneseasons");
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        SeasonSpawning.update(SeasonHelper.getSeasonState((Level)event.getServer().m_129783_()).getSeason());
    }

    public static void onSeasonChanged(SeasonChangedEvent.Standard event) {
        if (!Feature.isEnabled(SeasonSpawning.class) || !ModConfig.seasons.isDimensionWhitelisted(event.getLevel().m_46472_())) {
            return;
        }
        SeasonSpawning.update(((Season.SubSeason)event.getNewSeason()).getSeason());
    }

    private static void update(Season season) {
        switch (season) {
            case SPRING: {
                MobCategory.MONSTER.f_21591_ = despawnDistanceSpring;
                MobCategory.MONSTER.f_21586_ = hostileCapSpring;
                MobCategory.CREATURE.f_21586_ = animalsCapSpring;
                MobCategory.WATER_AMBIENT.f_21586_ = 20;
                break;
            }
            case SUMMER: {
                MobCategory.MONSTER.f_21591_ = despawnDistanceSummer;
                MobCategory.MONSTER.f_21586_ = hostileCapSummer;
                MobCategory.CREATURE.f_21586_ = animalsCapSummer;
                MobCategory.WATER_AMBIENT.f_21586_ = 20;
                break;
            }
            case AUTUMN: {
                MobCategory.MONSTER.f_21591_ = despawnDistanceAutumn;
                MobCategory.MONSTER.f_21586_ = hostileCapAutumn;
                MobCategory.CREATURE.f_21586_ = animalsCapAutumn;
                if (!noSeaCreatureInColdSeasons.booleanValue()) break;
                MobCategory.WATER_AMBIENT.f_21586_ = 10;
                break;
            }
            case WINTER: {
                MobCategory.MONSTER.f_21591_ = despawnDistanceWinter;
                MobCategory.MONSTER.f_21586_ = hostileCapWinter;
                MobCategory.CREATURE.f_21586_ = animalsCapWinter;
                if (!noSeaCreatureInColdSeasons.booleanValue()) break;
                MobCategory.WATER_AMBIENT.f_21586_ = 0;
            }
        }
    }
}

