/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.spawning;

import com.google.common.collect.ImmutableSet;
import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.module.mobs.spawning.EchoLanternBlock;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Spawning", description="Add a brand new Echo Torch and some changes to mob spawn")
@LoadFeature(module="iguanatweaksreborn:mobs")
public class Spawning
extends Feature {
    public static final UUID GUARDIAN_MODIFIER_UUID = UUID.fromString("93e7f541-3fee-4e79-8b9f-1e75fa71082e");
    public static final SimpleBlockWithItem ECHO_LANTERN = SimpleBlockWithItem.register("echo_lantern", () -> new EchoLanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50682_).m_60953_(state -> 7)));
    public static final RegistryObject<PoiType> ECHO_LANTERN_POI = ISORegistries.POI_TYPES.register("echo_lantern", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)ECHO_LANTERN.block().get()).m_49965_().m_61056_()), 1, 64));
    @Config
    @Label(name="No Zombie Villagers", description="Disables Zombie Villagers")
    public static Boolean noZombieVillagers = false;
    @Config
    @Label(name="Allow world spawn spawn", description="Allows mobs to spawn in the world spawn (in vanilla mobs can't spawn in a 24 blocks radius from world spawn)")
    public static Boolean allowWorldSpawnSpawn = true;
    @Config
    @Label(name="Remove skeletons from Fortresses", description="Disables normal skeletons from spawning in Fortresses.")
    public static Boolean removeSkeletonsFromFortresses = true;
    @Config
    @Label(name="Guardians in Deep Oceans", description="Enables a data pack that makes Guardians spawn in deep oceans. These guardians have half health compared to monument guardians.")
    public static Boolean guardiansInDeepOceans = true;
    public static final List<MobSpawnType> BLOCKED_SPAWN_TYPES = List.of(MobSpawnType.JOCKEY, MobSpawnType.NATURAL);

    public Spawning(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("yung_better_fortresses", "Insane's Survival Overhaul Yung Better Fortresses", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && ModList.get().isLoaded("betterfortresses") && removeSkeletonsFromFortresses != false);
        InsaneSurvivalOverhaul.addServerPack("ocean_guardians", "Insane's Survival Overhaul Ocean Guardians", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && guardiansInDeepOceans != false);
    }

    @SubscribeEvent
    public void onPotentialSpawns(LevelEvent.PotentialSpawns event) {
        if (!this.isEnabled() || !removeSkeletonsFromFortresses.booleanValue() || event.getMobCategory() != MobCategory.MONSTER) {
            return;
        }
        Structure fortress = (Structure)((ServerLevel)event.getLevel()).m_215010_().m_220521_().m_175515_(Registries.f_256944_).m_6246_(BuiltinStructures.f_209859_);
        if (fortress == null) {
            return;
        }
        StructureStart structureStart = ((ServerLevel)event.getLevel()).m_215010_().m_220494_(event.getPos(), fortress);
        if (structureStart.m_73603_()) {
            event.getSpawnerDataList().stream().filter(data -> data.f_48404_ == EntityType.f_20524_).findFirst().ifPresent(arg_0 -> ((LevelEvent.PotentialSpawns)event).removeSpawnerData(arg_0));
        }
    }

    @SubscribeEvent
    public void onZombieVillagerSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!this.isEnabled() || !noZombieVillagers.booleanValue() || event.getEntity().m_6095_() != EntityType.f_20530_ || event.getEntity().isAddedToWorld()) {
            return;
        }
        event.setSpawnCancelled(true);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onGuardianNaturalSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!this.isEnabled() || !guardiansInDeepOceans.booleanValue() || event.getEntity().m_6095_() != EntityType.f_20455_ || event.getSpawnType() != MobSpawnType.NATURAL || event.getEntity().isAddedToWorld()) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)event.getEntity(), (Attribute)Attributes.f_22276_, (UUID)GUARDIAN_MODIFIER_UUID, (String)"Naturally spawned guardians modifier", (double)-0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @SubscribeEvent
    public void onMobSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                ServerLevelAccessor serverLevelAccessor;
                if (!this.isEnabled() || !((serverLevelAccessor = event.getLevel()) instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)serverLevelAccessor;
                if (BLOCKED_SPAWN_TYPES.contains(event.getSpawnType()) && event.getEntityType().m_20674_() == MobCategory.MONSTER) break block5;
            }
            return;
        }
        boolean theresTorch = serverLevel.m_8904_().m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ECHO_LANTERN_POI.getKey()), blockPos -> true, event.getPos(), 64, PoiManager.Occupancy.ANY).findAny().isPresent();
        if (theresTorch) {
            event.setResult(Event.Result.DENY);
        }
    }
}

