/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.villager;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=SerializableTradeSerializer.class)
public class SerializableTrade
implements VillagerTrades.ItemListing {
    public ItemStack itemA;
    public ItemStack itemB;
    public ItemStack result;
    private int maxUses;
    private int xp = 0;
    @Nullable
    private EnchantRandomly enchantRandomly;
    private final List<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
    @Nullable
    private ExplorationMap explorationMap;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<SerializableTrade>>(){}.getType();

    public SerializableTrade() {
    }

    public SerializableTrade(ItemStack itemA, ItemStack result, int maxUses) {
        this(itemA, ItemStack.f_41583_, result, maxUses, 0);
    }

    public SerializableTrade(ItemStack itemA, ItemStack itemB, ItemStack result, int maxUses, int xp) {
        this.itemA = itemA;
        this.itemB = itemB;
        this.result = result;
        this.maxUses = maxUses;
        this.xp = xp;
    }

    public SerializableTrade enchant(Enchantment enchantment, int level) {
        this.enchantments.add(new EnchantmentInstance(enchantment, level));
        return this;
    }

    public SerializableTrade enchantResult(int minLevel, int maxLevel, boolean treasure) {
        this.enchantRandomly = new EnchantRandomly(minLevel, maxLevel, treasure);
        return this;
    }

    public SerializableTrade explorationMap(TagKey<Structure> destination, MapDecoration.Type mapDecoration, byte zoom, int searchRadius, boolean skipKnownStructures) {
        this.explorationMap = new ExplorationMap(destination, mapDecoration, zoom, searchRadius, skipKnownStructures);
        return this;
    }

    @Nullable
    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
        if (this.result.m_41619_() || this.itemA.m_41619_()) {
            return null;
        }
        ItemStack result = this.result.m_41777_();
        if (entity.m_9236_().f_46443_) {
            return null;
        }
        if (this.enchantRandomly != null) {
            result = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)result, (int)random.m_216339_(this.enchantRandomly.minLevel, this.enchantRandomly.maxLevel + 1), (boolean)this.enchantRandomly.treasure);
        }
        for (EnchantmentInstance enchantmentInstance : this.enchantments) {
            if (result.m_150930_(Items.f_42690_)) {
                EnchantedBookItem.m_41153_((ItemStack)result, (EnchantmentInstance)new EnchantmentInstance(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_));
                continue;
            }
            if (result.m_150930_(Items.f_42517_)) {
                CompoundTag tag = result.m_41783_();
                result = new ItemStack((ItemLike)Items.f_42690_, result.m_41613_());
                result.m_41751_(tag);
                EnchantedBookItem.m_41153_((ItemStack)result, (EnchantmentInstance)new EnchantmentInstance(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_));
                continue;
            }
            result.m_41663_(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_);
        }
        if (this.explorationMap != null && result.m_150930_(Items.f_42676_)) {
            Vec3 vec3 = entity.m_20182_();
            ServerLevel serverlevel = (ServerLevel)entity.m_9236_();
            BlockPos blockpos = serverlevel.m_215011_(this.explorationMap.destination, BlockPos.m_274446_((Position)vec3), this.explorationMap.searchRadius, this.explorationMap.skipKnownStructures);
            if (blockpos != null) {
                result = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)this.explorationMap.zoom, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)result);
                MapItemSavedData.m_77925_((ItemStack)result, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.explorationMap.mapDecoration);
                result.m_41714_(this.result.m_41786_());
            }
        }
        return new MerchantOffer(this.itemA, this.itemB, result, this.maxUses, this.xp, 1.0f);
    }

    private static ItemStack stackFromJson(String name, JsonObject jObject, JsonDeserializationContext context) throws JsonParseException {
        if (!jObject.has(name)) {
            return ItemStack.f_41583_;
        }
        String itemString = GsonHelper.m_13906_((JsonObject)jObject, (String)name);
        int count = GsonHelper.m_13824_((JsonObject)jObject, (String)(name + "_count"), (int)1);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString));
        if (item == Items.f_41852_) {
            ISOLogHelper.warn("Item %s for SerializableTrade does not exist, ignoring".formatted(itemString), new Object[0]);
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (!jObject.has(name + "_tag")) {
            return stack;
        }
        String tagString = GsonHelper.m_13906_((JsonObject)jObject, (String)(name + "_tag"));
        try {
            CompoundTag compoundTag = TagParser.m_129359_((String)tagString);
            stack.m_41751_(compoundTag);
        }
        catch (Exception e) {
            throw new JsonParseException("Failed to parse %s_tag %s".formatted(name, e.getMessage()));
        }
        return stack;
    }

    private static void stackToJson(JsonObject jObject, String name, ItemStack stack, JsonSerializationContext context) throws JsonParseException {
        if (stack.m_41619_()) {
            return;
        }
        jObject.addProperty(name, ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            jObject.addProperty(name + "_count", (Number)stack.m_41613_());
        }
        if (stack.m_41783_() != null) {
            jObject.addProperty(name + "_tag", stack.m_41783_().toString());
        }
    }

    private record EnchantRandomly(int minLevel, int maxLevel, boolean treasure) {
    }

    @JsonAdapter(value=ExplorationMapSerializer.class)
    private record ExplorationMap(TagKey<Structure> destination, MapDecoration.Type mapDecoration, byte zoom, int searchRadius, boolean skipKnownStructures) {
        private static TagKey<Structure> readStructure(JsonObject pJson) {
            String s = GsonHelper.m_13906_((JsonObject)pJson, (String)"destination");
            return TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(s));
        }

        public static class ExplorationMapSerializer
        implements JsonDeserializer<ExplorationMap>,
        JsonSerializer<ExplorationMap> {
            public ExplorationMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                TagKey<Structure> tagkey = ExplorationMap.readStructure(json.getAsJsonObject());
                String s = json.getAsJsonObject().has("decoration") ? GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"decoration") : "mansion";
                MapDecoration.Type mapdecoration$type = ExplorationMapFunction.f_80522_;
                try {
                    mapdecoration$type = MapDecoration.Type.valueOf((String)s.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException illegalargumentexception) {
                    ISOLogHelper.error("Error while parsing loot table decoration entry. Found {}. Defaulting to {}", s, ExplorationMapFunction.f_80522_);
                }
                byte b0 = GsonHelper.m_13816_((JsonObject)json.getAsJsonObject(), (String)"zoom", (byte)2);
                int i = GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"search_radius", (int)50);
                boolean flag = GsonHelper.m_13855_((JsonObject)json.getAsJsonObject(), (String)"skip_existing_chunks", (boolean)true);
                return new ExplorationMap(tagkey, mapdecoration$type, b0, i, flag);
            }

            public JsonElement serialize(ExplorationMap src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("destination", src.destination.f_203868_().toString());
                if (src.mapDecoration != ExplorationMapFunction.f_80522_) {
                    jsonObject.add("decoration", context.serialize((Object)src.mapDecoration.toString().toLowerCase(Locale.ROOT)));
                }
                if (src.zoom != 2) {
                    jsonObject.addProperty("zoom", (Number)src.zoom);
                }
                if (src.searchRadius != 50) {
                    jsonObject.addProperty("search_radius", (Number)src.searchRadius);
                }
                if (!src.skipKnownStructures) {
                    jsonObject.addProperty("skip_existing_chunks", Boolean.valueOf(src.skipKnownStructures));
                }
                return jsonObject;
            }
        }
    }

    public static class SerializableTradeSerializer
    implements JsonDeserializer<SerializableTrade>,
    JsonSerializer<SerializableTrade> {
        public SerializableTrade deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray enchantments;
            JsonObject jObject = json.getAsJsonObject();
            SerializableTrade serializableTrade = new SerializableTrade();
            serializableTrade.itemA = SerializableTrade.stackFromJson("item_a", jObject, context);
            serializableTrade.itemB = SerializableTrade.stackFromJson("item_b", jObject, context);
            serializableTrade.result = SerializableTrade.stackFromJson("item_result", jObject, context);
            JsonObject enchantRandomly = GsonHelper.m_13841_((JsonObject)jObject, (String)"enchant_randomly", null);
            if (enchantRandomly != null) {
                serializableTrade.enchantRandomly = new EnchantRandomly(GsonHelper.m_13927_((JsonObject)enchantRandomly, (String)"min_levels"), GsonHelper.m_13927_((JsonObject)enchantRandomly, (String)"max_levels"), GsonHelper.m_13912_((JsonObject)enchantRandomly, (String)"treasure"));
            }
            if ((enchantments = GsonHelper.m_13832_((JsonObject)jObject, (String)"enchantments", null)) != null) {
                enchantments.asList().forEach(jsonElement -> {
                    String id = GsonHelper.m_13906_((JsonObject)jsonElement.getAsJsonObject(), (String)"id");
                    int level = GsonHelper.m_13824_((JsonObject)jsonElement.getAsJsonObject(), (String)"level", (int)1);
                    serializableTrade.enchantments.add(new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)id)), level));
                });
            }
            if (jObject.has("exploration_map")) {
                serializableTrade.explorationMap = (ExplorationMap)context.deserialize(jObject.get("exploration_map"), ExplorationMap.class);
            }
            serializableTrade.maxUses = GsonHelper.m_13927_((JsonObject)jObject, (String)"max_uses");
            serializableTrade.xp = GsonHelper.m_13824_((JsonObject)jObject, (String)"xp", (int)0);
            return serializableTrade;
        }

        public JsonElement serialize(SerializableTrade src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            SerializableTrade.stackToJson(jObject, "item_a", src.itemA, context);
            SerializableTrade.stackToJson(jObject, "item_b", src.itemB, context);
            SerializableTrade.stackToJson(jObject, "item_result", src.result, context);
            if (src.enchantRandomly != null) {
                JsonObject enchantRandomly = new JsonObject();
                enchantRandomly.addProperty("min_levels", (Number)src.enchantRandomly.minLevel);
                enchantRandomly.addProperty("max_levels", (Number)src.enchantRandomly.maxLevel);
                enchantRandomly.addProperty("treasure", Boolean.valueOf(src.enchantRandomly.treasure));
                jObject.add("enchant_randomly", (JsonElement)enchantRandomly);
            }
            if (!src.enchantments.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                src.enchantments.forEach(enchantmentInstance -> {
                    JsonObject enchantmentsObject = new JsonObject();
                    enchantmentsObject.addProperty("id", ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantmentInstance.f_44947_).toString());
                    if (enchantmentInstance.f_44948_ > 1) {
                        enchantmentsObject.addProperty("level", (Number)enchantmentInstance.f_44948_);
                    }
                    jsonArray.add((JsonElement)enchantmentsObject);
                });
                jObject.add("enchantments", (JsonElement)jsonArray);
            }
            if (src.explorationMap != null) {
                jObject.add("exploration_map", context.serialize((Object)src.explorationMap));
            }
            jObject.addProperty("max_uses", (Number)src.maxUses);
            jObject.addProperty("xp", (Number)src.xp);
            return jObject;
        }
    }
}

