/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.villager.villagers;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.module.mobs.villager.villagers.VillagerTrade;
import insane96mcp.iguanatweaksreborn.module.mobs.villager.villagers.VillagerTradesReloadListener;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Villagers", description="Nerfs to villagers + change their trades via json config")
@LoadFeature(module="iguanatweaksreborn:mobs")
public class Villagers
extends Feature {
    private static final String CURE_DISCOUNT_REMOVED = "iguanatweaksreborn:cure_discount_removed";
    @Config
    @Label(name="Lock Trades", description="If true, villagers will be given 1 trading experience as soon as they choose their job to lock the trades.")
    public static Boolean lockTrades = true;
    @Config
    @Label(name="Always convert villager to zombie", description="If true, villagers will always be transformed into Zombies no matter the difficulty.")
    public static Boolean alwaysConvertZombie = true;
    @Config(min=0.0, max=1.0)
    @Label(name="Max Discount Percentage", description="Define a max percentage discount that villagers can give.")
    public static Double maxDiscount = 0.5;
    @Config
    @Label(name="Prevent Cure Discount", description="If true, villagers will no longer get the discount when cured from Zombies to prevent over discounting.")
    public static Boolean preventCureDiscount = true;
    @Config
    @Label(name="Clamp Negative Demand", description="When villagers restock, they update the 'demand'. Demand is a trade modifier that increases the price whenever a trade is done many times, BUT when a trade is not performed, at each restock the 'demand' goes negative, making possible for a trade to never increase it's price due to high negative demand. With this to true, negative demand will be capped at -max_uses of the trade (e.g. Carrot trade from a farmer will have it's minimum demand set to -16).")
    public static Boolean clampNegativeDemand = true;
    @Config(min=0.0, max=1.0)
    @Label(name="Nitwit chance", description="Chance for a nitwit to spawn when two villagers breed")
    public static Double nitwitChance = 0.1;
    @Config
    @Label(name="Remove Bad Omen", description="If true, the effect can no longer be applied to entities")
    public static Boolean removeBadOmen = false;
    @Config
    @Label(name="Trades Data Pack", description="Enables a data pack that changes villagers trades")
    public static Boolean tradesDataPack = true;

    public Villagers(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("villager_trades", "Insane's Survival Overhaul Villager Trades", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && tradesDataPack != false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Int2ObjectMap itemListing = event.getTrades();
        itemListing.forEach((level, value) -> {
            VillagerTrade trades = VillagerTradesReloadListener.INSTANCE.getTradesOfLevel(event.getType(), (int)level);
            if (trades == null) {
                return;
            }
            if (trades.remove) {
                value.clear();
            }
            value.addAll(trades.trades);
        });
    }

    @SubscribeEvent
    public void onEffectAdded(MobEffectEvent.Applicable event) {
        if (!this.isEnabled() || !removeBadOmen.booleanValue() || event.getEffectInstance().m_19544_() != MobEffects.f_19594_) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)livingEntity;
        this.tryRemovingCureDiscount(villager);
    }

    public void tryRemovingCureDiscount(Villager villager) {
        if (!preventCureDiscount.booleanValue() || villager.getPersistentData().m_128471_(CURE_DISCOUNT_REMOVED)) {
            return;
        }
        Map gossips = villager.m_35517_().m_148159_();
        gossips.forEach((uuid, gossipTypeObject2IntMap) -> {
            villager.m_35517_().m_148168_(uuid, GossipType.MAJOR_POSITIVE);
            villager.m_35517_().m_148168_(uuid, GossipType.MINOR_POSITIVE);
        });
        villager.getPersistentData().m_128379_(CURE_DISCOUNT_REMOVED, true);
    }

    public static int clampSpecialPrice(int specialPriceDiff, ItemStack baseCostA) {
        if (!Villagers.isEnabled(Villagers.class) || maxDiscount == 1.0) {
            return specialPriceDiff;
        }
        if (specialPriceDiff < 0 && (double)Mth.m_14040_((int)specialPriceDiff) > (double)baseCostA.m_41613_() * maxDiscount) {
            return Mth.m_14045_((int)specialPriceDiff, (int)((int)((double)baseCostA.m_41613_() * -maxDiscount.doubleValue())), (int)0);
        }
        return specialPriceDiff;
    }

    public static int clampDemand(int demand, int maxUses) {
        if (!Villagers.isEnabled(Villagers.class) || !clampNegativeDemand.booleanValue()) {
            return demand;
        }
        return Math.max(demand, -maxUses);
    }

    public static void lockTrades(Villager villager) {
        if (!Villagers.isEnabled(Villagers.class) || !lockTrades.booleanValue()) {
            return;
        }
        if (villager.m_7809_() == 0) {
            villager.m_35546_(1);
        }
    }

    public static boolean shouldConvertVillagerToZombie() {
        return Villagers.isEnabled(Villagers.class) && alwaysConvertZombie != false;
    }

    public static boolean shouldSpawnAsNitwit(Villager villager) {
        return Feature.isEnabled(Villagers.class) && villager.m_217043_().m_188500_() < nitwitChance;
    }
}

