/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.movement;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.MCUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Terrain Slowdown", description="Slowdown based off the terrain entities walking on. Custom Terrain Slowdown are controlled via json in this feature's folder")
@LoadFeature(module="iguanatweaksreborn:movement")
public class TerrainSlowdown
extends JsonFeature {
    private static final UUID TERRAIN_SLOWDOWN = UUID.fromString("a849043f-b280-4789-bafd-5da8e8e1078e");
    public static final TagKey<Item> SNOW_SLOWDOWN_IGNORE = ISOItemTagsProvider.create("snow_slowdown_ignore");
    public static final ArrayList<IdTagValue> CUSTOM_TERRAIN_SLOWDOWN_DEFAULT = new ArrayList<IdTagValue>(List.of(IdTagValue.newTag((String)"minecraft:ice", (double)0.55)));
    public static final ArrayList<IdTagValue> customTerrainSlowdown = new ArrayList();
    public static final ArrayList<IdTagValue> CUSTOM_IN_TERRAIN_SLOWDOWN_DEFAULT = new ArrayList<IdTagValue>(List.of(IdTagValue.newId((String)"minecraft:snow", (double)0.075), IdTagValue.newId((String)"minecraft:powder_snow", (double)0.5)));
    public static final ArrayList<IdTagValue> customInTerrainSlowdown = new ArrayList();
    @Config
    public static Boolean frostWalkerReducesIceSlowdown = true;
    @Config
    @Label(description="If true, snow slowdown is ignored if wearing leather boots (or any item in iguanatweaksreborn:snow_slowdown_ignore item tag)")
    public static Boolean snowSlowdownIgnoredWithLeatherBoots = true;

    public TerrainSlowdown(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        TerrainSlowdown.addSyncType((ResourceLocation)new ResourceLocation("iguanatweaksreborn", "custom_terrain_slowdown"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> TerrainSlowdown.loadAndReadJson((String)json, customTerrainSlowdown, CUSTOM_TERRAIN_SLOWDOWN_DEFAULT, (Type)IdTagValue.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("custom_terrain_slowdown.json", customTerrainSlowdown, CUSTOM_TERRAIN_SLOWDOWN_DEFAULT, IdTagValue.LIST_TYPE, true, new ResourceLocation("iguanatweaksreborn", "custom_terrain_slowdown")));
        TerrainSlowdown.addSyncType((ResourceLocation)new ResourceLocation("iguanatweaksreborn", "custom_in_terrain_slowdown"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> TerrainSlowdown.loadAndReadJson((String)json, customInTerrainSlowdown, CUSTOM_IN_TERRAIN_SLOWDOWN_DEFAULT, (Type)IdTagValue.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("custom_in_terrain_slowdown.json", customInTerrainSlowdown, CUSTOM_IN_TERRAIN_SLOWDOWN_DEFAULT, IdTagValue.LIST_TYPE, true, new ResourceLocation("iguanatweaksreborn", "custom_in_terrain_slowdown")));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.player.m_20096_()) {
            TerrainSlowdown.applyTerrainSlowdown((LivingEntity)event.player, 1.0f);
        } else if (event.player.isInFluidType()) {
            TerrainSlowdown.removeTerrainSlowdown((LivingEntity)event.player);
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (!this.isEnabled() || event.getEntity() instanceof Player || (event.getEntity().f_19797_ + event.getEntity().m_19879_()) % 5 != 0) {
            return;
        }
        TerrainSlowdown.applyTerrainSlowdown(event.getEntity(), 0.65f);
    }

    public static void applyTerrainSlowdown(LivingEntity entity, float multiplier) {
        double onTerrainSlowdown = 0.0;
        int blocks = 0;
        AABB bb = entity.m_20191_();
        int mX = Mth.m_14107_((double)bb.f_82288_);
        int mY = Mth.m_14107_((double)bb.f_82289_);
        int mZ = Mth.m_14107_((double)bb.f_82290_);
        int x2 = mX;
        while ((double)x2 < bb.f_82291_) {
            int z2 = mZ;
            while ((double)z2 < bb.f_82293_) {
                BlockState state = entity.m_9236_().m_8055_(BlockPos.m_274561_((double)x2, (double)(entity.m_20182_().f_82480_ - 0.02), (double)z2));
                if (!state.m_60795_()) {
                    double blockSlowdown = 0.0;
                    for (IdTagValue idTagValue : customTerrainSlowdown) {
                        if (!idTagValue.id.matchesBlock(state.m_60734_())) continue;
                        blockSlowdown = idTagValue.value;
                        if (state.m_204336_(BlockTags.f_13047_) && frostWalkerReducesIceSlowdown.booleanValue()) {
                            int lvl = entity.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel(Enchantments.f_44974_);
                            blockSlowdown -= blockSlowdown * (double)((float)lvl * 0.5f);
                        } else if (state.m_204336_(BlockTags.f_144279_) && entity.m_6844_(EquipmentSlot.FEET).m_204117_(SNOW_SLOWDOWN_IGNORE) && snowSlowdownIgnoredWithLeatherBoots.booleanValue()) {
                            blockSlowdown = 0.0;
                        }
                        ++blocks;
                        break;
                    }
                    onTerrainSlowdown += blockSlowdown;
                }
                ++z2;
            }
            ++x2;
        }
        if (blocks != 0) {
            onTerrainSlowdown /= (double)blocks;
        }
        double inTerrainSlowdown = 0.0;
        blocks = 0;
        int x22 = mX;
        while ((double)x22 < bb.f_82291_) {
            int y2 = mY;
            while ((double)y2 < bb.f_82292_) {
                int z2 = mZ;
                while ((double)z2 < bb.f_82293_) {
                    BlockState state = entity.m_9236_().m_8055_(new BlockPos(x22, y2, z2));
                    if (!state.m_60795_()) {
                        double blockSlowdown = 0.0;
                        for (IdTagValue idTagValue : customInTerrainSlowdown) {
                            if (!idTagValue.id.matchesBlock(state.m_60734_())) continue;
                            blockSlowdown = idTagValue.value;
                            if (state.m_204336_(BlockTags.f_144279_) && entity.m_6844_(EquipmentSlot.FEET).m_204117_(SNOW_SLOWDOWN_IGNORE) && snowSlowdownIgnoredWithLeatherBoots.booleanValue()) {
                                blockSlowdown = 0.0;
                            }
                            ++blocks;
                            break;
                        }
                        inTerrainSlowdown += blockSlowdown;
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x22;
        }
        if (blocks != 0) {
            inTerrainSlowdown /= (double)blocks;
        }
        double slowdown = (onTerrainSlowdown + inTerrainSlowdown) * (double)multiplier;
        TerrainSlowdown.applySlowdown(entity, slowdown);
    }

    public static void applySlowdown(LivingEntity entity, double slowdown) {
        AttributeModifier modifier = entity.m_21051_(Attributes.f_22279_).m_22111_(TERRAIN_SLOWDOWN);
        if (slowdown == 0.0) {
            TerrainSlowdown.removeTerrainSlowdown(entity, modifier);
            return;
        }
        if (modifier == null || modifier.m_22218_() != -slowdown) {
            if (modifier != null) {
                TerrainSlowdown.removeTerrainSlowdown(entity, modifier);
            }
            MCUtils.applyModifier((LivingEntity)entity, (Attribute)Attributes.f_22279_, (UUID)TERRAIN_SLOWDOWN, (String)"terrain slowdown", (double)(-slowdown), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
    }

    public static void removeTerrainSlowdown(LivingEntity entity, @Nullable AttributeModifier modifier) {
        if (modifier != null) {
            entity.m_21051_(Attributes.f_22279_).m_22120_(TERRAIN_SLOWDOWN);
        }
    }

    public static void removeTerrainSlowdown(LivingEntity entity) {
        AttributeModifier modifier = entity.m_21051_(Attributes.f_22279_).m_22111_(TERRAIN_SLOWDOWN);
        TerrainSlowdown.removeTerrainSlowdown(entity, modifier);
    }
}

