/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.movement.weightedequipment;

import com.ezylang.evalex.Expression;
import com.google.common.collect.Multimap;
import insane96mcp.iguanatweaksreborn.module.combat.RegeneratingAbsorption;
import insane96mcp.iguanatweaksreborn.module.movement.weightedequipment.ArmorEnchantmentWeight;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Weighted Armor", description="Armor slows down the player. Enchantment Weights are controlled via json in this feature's folder. If you need more control over armor, use item definitions")
@LoadFeature(module="iguanatweaksreborn:movement", enabledByDefault=false)
public class WeightedArmor
extends JsonFeature {
    public static final String ARMOR_SLOWDOWN = "iguanatweaksreborn.armor_slowdown";
    public static final UUID ARMOR_SLOWDOWN_UUID = UUID.fromString("8588420e-ce50-4e4e-a3e4-974dfc8a98ec");
    public static final ArrayList<ArmorEnchantmentWeight> ENCHANTMENTS_LIST_DEFAULT = new ArrayList<ArmorEnchantmentWeight>(List.of(new ArmorEnchantmentWeight.Builder(IdTagMatcher.newId((String)"minecraft:feather_falling")).setPercentageSlownessPerLevel(-0.005f).build()));
    public static final ArrayList<ArmorEnchantmentWeight> enchantmentsList = new ArrayList();
    @Config
    @Label(description="Formula to calculate the slowdown of a piece of armor. Variables available are: armor, armor_toughness. This is evaluated with EvalEx https://ezylang.github.io/EvalEx/concepts/parsing_evaluation.html. Please note that 1 means 100% slowdown")
    public static String slowdownFormula = "(armor * 0.01) * (1 + (armor_toughness * 0.05))";

    public WeightedArmor(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        WeightedArmor.addSyncType((ResourceLocation)new ResourceLocation("iguanatweaksreborn", "enchantments_weights"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> WeightedArmor.loadAndReadJson((String)json, enchantmentsList, ENCHANTMENTS_LIST_DEFAULT, (Type)ArmorEnchantmentWeight.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("enchantments_weights.json", enchantmentsList, ENCHANTMENTS_LIST_DEFAULT, ArmorEnchantmentWeight.LIST_TYPE, true, new ResourceLocation("iguanatweaksreborn", "enchantments_weights")));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        AttributeInstance movementSpeed = player.m_21051_(Attributes.f_22279_);
        if (movementSpeed == null) {
            return;
        }
        AttributeModifier modifier = movementSpeed.m_22111_(ARMOR_SLOWDOWN_UUID);
        if (!this.isEnabled()) {
            if (modifier != null) {
                movementSpeed.m_22130_(modifier);
            }
            return;
        }
        double slowdown = 0.0;
        for (ItemStack stack : player.m_6168_()) {
            slowdown += this.getArmorSlowdown(stack);
        }
        if (slowdown == 0.0) {
            if (modifier != null) {
                movementSpeed.m_22130_(modifier);
            }
            return;
        }
        if (modifier == null || modifier.m_22218_() != -slowdown) {
            modifier = new AttributeModifier(ARMOR_SLOWDOWN_UUID, ARMOR_SLOWDOWN, -slowdown, AttributeModifier.Operation.MULTIPLY_BASE);
            movementSpeed.m_22120_(ARMOR_SLOWDOWN_UUID);
            movementSpeed.m_22118_(modifier);
        }
    }

    private double getArmorSlowdown(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return 0.0;
        }
        ArmorItem armorItem = (ArmorItem)item;
        double slowdown = 0.0;
        Multimap attributeModifiers = itemStack.m_41638_(armorItem.m_40402_());
        double armor = 0.0;
        Collection armorModifiers = attributeModifiers.get((Object)Attributes.f_22284_);
        if (armorModifiers.isEmpty()) {
            armorModifiers = attributeModifiers.get((Object)((Attribute)RegeneratingAbsorption.ATTRIBUTE.get()));
        }
        for (AttributeModifier attributeModifier : armorModifiers) {
            if (!attributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) continue;
            armor += attributeModifier.m_22218_();
        }
        double armorToughness = 0.0;
        Collection toughnessModifiers = attributeModifiers.get((Object)Attributes.f_22285_);
        if (armorModifiers.isEmpty()) {
            toughnessModifiers = attributeModifiers.get((Object)((Attribute)RegeneratingAbsorption.SPEED_ATTRIBUTE.get()));
        }
        for (AttributeModifier attributeModifier : toughnessModifiers) {
            if (!attributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) continue;
            armorToughness += attributeModifier.m_22218_();
        }
        slowdown = this.evaluateWeight(armor, armorToughness);
        double flatEnchantmentSlowdown = 0.0;
        double percentageEnchantmentSlowdown = 0.0;
        for (ArmorEnchantmentWeight enchantmentWeight : enchantmentsList) {
            int enchantmentLevel = MCUtils.getEnchantmentLevel((ResourceLocation)enchantmentWeight.enchantment.location, (ItemStack)itemStack);
            if (enchantmentLevel == 0) continue;
            flatEnchantmentSlowdown += (double)(enchantmentWeight.flatSlowness + enchantmentWeight.flatSlownessPerLevel * (float)enchantmentLevel);
            percentageEnchantmentSlowdown += (double)(enchantmentWeight.percentageSlowness + enchantmentWeight.percentageSlownessPerLevel * (float)enchantmentLevel);
        }
        slowdown += flatEnchantmentSlowdown;
        return slowdown *= 1.0 + percentageEnchantmentSlowdown;
    }

    private float evaluateWeight(double armor, double armorToughness) {
        Expression expression = new Expression(slowdownFormula).with("armor", (Object)armor).with("armor_toughness", (Object)armorToughness);
        try {
            return expression.evaluate().getNumberValue().floatValue();
        }
        catch (Exception ex) {
            LogHelper.error((String)"Failed to evaluate armor formula: %s\n%s", (Object[])new Object[]{slowdownFormula, ex});
            return 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        double slowdown = this.getArmorSlowdown(stack) * 100.0;
        if (slowdown <= 0.0) {
            return;
        }
        event.getToolTip().add(Component.m_237110_((String)ARMOR_SLOWDOWN, (Object[])new Object[]{Utils.formatDecimal((double)slowdown, (String)"#.#")}).m_130940_(ChatFormatting.RED));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void debugScreen(CustomizeGuiOverlayEvent.DebugText event) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer playerEntity = mc.f_91074_;
        if (playerEntity == null) {
            return;
        }
        AttributeInstance movementSpeed = playerEntity.m_21051_(Attributes.f_22279_);
        if (movementSpeed == null) {
            return;
        }
        AttributeModifier modifier = movementSpeed.m_22111_(ARMOR_SLOWDOWN_UUID);
        if (mc.f_91066_.f_92063_ && !mc.m_91299_() && modifier != null) {
            event.getLeft().add(String.format("Armor Slowdown: %s%%", Utils.formatDecimal((double)(Math.abs(modifier.m_22218_()) * 100.0), (String)"#.#")));
        }
    }
}

