/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn;

import insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness.Tiredness;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Sleeping and Spawn Point", description="Changes to sleeping and spawn points")
@LoadFeature(module="iguanatweaksreborn:sleep_respawn", enabledByDefault=false)
public class Sleeping
extends Feature {
    public static final String DECORATIVE_BEDS = "iguanatweaksreborn.decorative_beds";
    public static final String ENJOY_THE_NIGHT = "iguanatweaksreborn.enjoy_the_night";
    @Config
    @Label(name="Disable Sleeping", description="If set to true the player will not be able to sleep.")
    public static Boolean disableSleeping = true;
    @Config
    @Label(name="Disable Spawn Point", description="If set to true the player spawn point cannot be changed with beds.")
    public static Boolean disableSpawnPoint = false;
    @Config
    @Label(name="Allow Sleeping During Day", description="If set to true the player will be able to sleep during day time. On wake up it will be night time. Note that with 'Tiredness' feature enabled you are still not able to sleep during day unless you're tired enough.")
    public static Boolean allowDaySleep = false;

    public Sleeping(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void disableSleeping(PlayerSleepInBedEvent event) {
        if (!this.isEnabled() || event.getResultStatus() != null || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (disableSleeping.booleanValue()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            if (disableSpawnPoint.booleanValue()) {
                player.m_5661_((Component)Component.m_237115_((String)DECORATIVE_BEDS), false);
            } else {
                player.m_9158_(player.m_9236_().m_46472_(), event.getPos(), player.m_146908_(), false, true);
                player.m_5661_((Component)Component.m_237115_((String)ENJOY_THE_NIGHT), false);
            }
        }
    }

    @SubscribeEvent
    public void forceSleepDuringDay(PlayerSleepInBedEvent event) {
        if (!(this.isEnabled() && allowDaySleep.booleanValue() && event.getResultStatus() == null && Tiredness.canSleepDuringDay(event.getEntity()))) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        player.m_5802_(event.getPos());
        ((ServerLevel)player.m_9236_()).m_8878_();
    }

    @SubscribeEvent
    public void trySleepDuringDay(SleepingTimeCheckEvent event) {
        if (!this.isEnabled() || !allowDaySleep.booleanValue() || Sleeping.isEnabled(Tiredness.class) && !Tiredness.canSleepDuringDay(event.getEntity())) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onWakeUp(SleepFinishedTimeEvent event) {
        if (!this.isEnabled() || !allowDaySleep.booleanValue()) {
            return;
        }
        int toSub = 11458;
        if (event.getLevel().m_6106_().m_6533_()) {
            toSub = 11990;
        }
        event.setTimeAddition(event.getNewTime() - (long)toSub);
    }
}

