/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.death;

import insane96mcp.iguanatweaksreborn.module.sleeprespawn.death.Death;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "items";
    public static final String XP_STORED_TAG = "xp_stored";
    public static final String OWNER_TAG = "owner";
    public static final String DEATH_NUMBER_TAG = "death_number";
    public static final String MESSAGE_TAG = "message";
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private int xpStored = 0;
    private UUID owner;
    private int deathNumber;
    @Nullable
    private Component message;

    public GraveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Death.GRAVE_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
        this.m_6596_();
    }

    public int getXpStored() {
        return this.xpStored;
    }

    public void setXpStored(int xpStored) {
        this.xpStored = xpStored;
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public int getDeathNumber() {
        return this.deathNumber;
    }

    public void setDeathNumber(int deathNumber) {
        this.deathNumber = deathNumber;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        ListTag itemsList = compoundTag.m_128437_(ITEMS_TAG, 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag itemStackTag = itemsList.m_128728_(i);
            this.items.add(ItemStack.m_41712_((CompoundTag)itemStackTag));
        }
        this.xpStored = compoundTag.m_128451_(XP_STORED_TAG);
        if (compoundTag.m_128441_(OWNER_TAG)) {
            this.owner = compoundTag.m_128342_(OWNER_TAG);
            this.deathNumber = compoundTag.m_128451_(DEATH_NUMBER_TAG);
        }
        if (compoundTag.m_128441_(MESSAGE_TAG)) {
            this.message = Component.Serializer.m_130701_((String)compoundTag.m_128461_(MESSAGE_TAG));
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ListTag itemsList = new ListTag();
        for (ItemStack itemStack : this.items) {
            CompoundTag itemStackTag = new CompoundTag();
            itemStack.m_41739_(itemStackTag);
            itemsList.add((Object)itemStackTag);
        }
        compoundTag.m_128365_(ITEMS_TAG, (Tag)itemsList);
        compoundTag.m_128405_(XP_STORED_TAG, this.xpStored);
        if (this.owner != null) {
            compoundTag.m_128362_(OWNER_TAG, this.owner);
            compoundTag.m_128405_(DEATH_NUMBER_TAG, this.deathNumber);
        }
        if (this.message != null) {
            compoundTag.m_128359_(MESSAGE_TAG, Component.Serializer.m_130703_((Component)this.message));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (level.m_46467_() % 20L != 9L) {
            return;
        }
        GraveBlockEntity graveBlockEntity = (GraveBlockEntity)t;
        if (graveBlockEntity.owner == null) {
            return;
        }
        Optional<ServerPlayer> oPlayer = GraveBlockEntity.getPlayerOwner((ServerLevel)level, graveBlockEntity.owner);
        oPlayer.ifPresent(player -> {
            if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) != graveBlockEntity.deathNumber) {
                graveBlockEntity.dropContent(pos);
            }
        });
    }

    public void dropContent(BlockPos pos) {
        this.dropExperience(pos);
        this.dropItems(pos);
        this.owner = null;
    }

    public void dropExperience(BlockPos pos) {
        int amount;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (amount > 0) {
            int i;
            for (amount = this.getXpStored(); amount > 0; amount -= i) {
                i = ExperienceOrb.m_20782_((int)amount);
                if (ExperienceOrb.m_147096_((ServerLevel)serverLevel, (Vec3)pos.m_252807_(), (int)i)) continue;
                ExperienceOrb xpOrb = new ExperienceOrb(this.f_58857_, pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, i);
                this.f_58857_.m_7967_((Entity)xpOrb);
                xpOrb.getPersistentData().m_128379_("iguanatweaksreborn:xp_processed", true);
            }
            this.setXpStored(0);
        }
    }

    public void dropItems(BlockPos pos) {
        this.getItems().forEach(itemStack -> GraveBlockEntity.dropItem(this.f_58857_, itemStack, pos));
        this.getItems().clear();
    }

    public static void dropItem(Level level, ItemStack stack, BlockPos pos) {
        if (stack.m_41619_()) {
            return;
        }
        ItemEntity itementity = new ItemEntity(level, pos.m_252807_().f_82479_, pos.m_252807_().f_82480_ + 0.8, pos.m_252807_().f_82481_, stack);
        itementity.m_32010_(5);
        itementity.lifespan = Death.despawnTime;
        float f = level.f_46441_.m_188501_() * 0.1f;
        float f1 = level.f_46441_.m_188501_() * ((float)Math.PI * 2);
        itementity.m_20334_((double)(-Mth.m_14031_((float)f1) * f), (double)0.1f, (double)(Mth.m_14089_((float)f1) * f));
        level.m_7967_((Entity)itementity);
    }

    public static Optional<ServerPlayer> getPlayerOwner(ServerLevel level, UUID playerUUID) {
        for (ServerPlayer player : level.m_6907_()) {
            UUID uuid = player.m_20148_();
            if (!uuid.equals(playerUUID)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }
}

