/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawn;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.ISOMobEffectInstance;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawn.RespawnObeliskBlock;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Respawn", description="Changes to respawning. Adds the doLooseRespawn gamerule that can disable the loose spawn range")
@LoadFeature(module="iguanatweaksreborn:sleep_respawn")
public class Respawn
extends JsonFeature {
    public static final TagKey<Block> RESPAWN_OBELISK_BLOCKS_TO_ROT = ISOBlockTagsProvider.create("structures/respawn_obelisk/blocks_to_rot");
    public static final String FAIL_RESPAWN_OBELISK_LANG = "iguanatweaksreborn.fail_respawn_obelisk";
    public static final String LOOSE_RESPAWN_POINT_SET = "iguanatweaksreborn.loose_bed_respawn_point_set";
    public static final GameRules.Key<GameRules.BooleanValue> RULE_RANGEDRESPAWN = GameRules.m_46189_((String)"iguanatweaks:doLooseRespawn", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final String DEATHS = "iguanatweaksreborn:deaths";
    public static final String HUNGER_ON_DEATH_TAG = "iguanatweaksreborn:hunger_on_death";
    public static final String SATURATION_ON_DEATH_TAG = "iguanatweaksreborn:saturation_on_death";
    public static final SimpleBlockWithItem RESPAWN_OBELISK = SimpleBlockWithItem.register("respawn_obelisk", () -> new RespawnObeliskBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(50.0f, 1200.0f).m_60953_(RespawnObeliskBlock::lightLevel)));
    @Config(min=0.0)
    @Label(name="Loose World Spawn Range", description="The range from world spawn where players will respawn.")
    public static MinMax looseWorldSpawnRange = new MinMax(96.0, 192.0);
    @Config(min=0.0)
    @Label(name="Despawn mobs on world respawn", description="Mobs in this range from the player will be despawned when respawning at world spawn.")
    public static Integer despawnMobsOnWorldRespawn = 64;
    @Config(min=0.0)
    @Label(name="Loose Bed Spawn Range", description="The range from beds where players will respawn.")
    public static MinMax looseBedSpawnRange = new MinMax(64.0, 128.0);
    @Config(min=0.0)
    @Label(name="Despawn mobs on bed respawn", description="Mobs in this range from the player will be despawned when respawning at bed spawn.")
    public static Integer despawnMobsOnBedRespawn = 32;
    @Config
    @Label(name="Don't respawn on fluid", description="If enabled, respawning will try to place you on land and not in fluids")
    public static Boolean dontRespawnOnFluid = true;
    @Config(min=0.0, max=20.0)
    @Label(name="Stats Penalty.Health.Minimum", description="Min Health of respawning players")
    public static Difficulty minHealthOnRespawn = new Difficulty(10.0, 10.0, 6.0);
    @Config(min=0.0, max=20.0)
    @Label(name="Stats Penalty.Health.Per Death", description="How much health respawning players lose on respawn (not max health)")
    public static Difficulty perDeathHealthOnRespawn = new Difficulty(1.0, 2.0, 2.0);
    @Config(min=0.0, max=20.0)
    @Label(name="Stats Penalty.Hunger.Minimum", description="Min Hunger of respawning players. If below this value on death will be set to this value")
    public static Difficulty hungerOnRespawnMin = new Difficulty(6.0, 6.0, 6.0);
    @Config(min=0.0, max=20.0)
    @Label(name="Stats Penalty.Hunger.Maximum", description="Max Hunger of respawning players. If above this value on death will be set to this value")
    public static Difficulty hungerOnRespawnMax = new Difficulty(14.0, 14.0, 10.0);
    @Config(min=0.0, max=20.0)
    @Label(name="Stats Penalty.Saturation.Minimum", description="Min Saturation of respawning players. If below this value on death will be set to this value")
    public static Difficulty saturationOnRespawnMin = new Difficulty(6.0, 6.0, 6.0);
    @Config(min=0.0, max=20.0)
    @Label(name="Stats Penalty.Saturation.Maximum", description="Max Saturation of respawning players. If above this value on death will be set to this value")
    public static Difficulty saturationOnRespawnMax = new Difficulty(10.0, 10.0, 6.0);
    @Config
    @Label(description="Data pack that makes respawn obelisks generate in the world")
    public static Boolean respawnObelisks = true;
    @Config
    @Label(name="Allow obelisk spawn point overwrite with beds when sneaking", description="If enabled, sleeping a bed when sneaking will overwrite obelisk spawn point")
    public static Boolean allowObeliskSpawnPointOverwriteWithBedsSneaking = true;
    public static final List<IdTagValue> RESPAWN_OBELISK_CATALYSTS_DEFAULT = List.of(IdTagValue.newId((String)"minecraft:iron_block", (double)0.75), IdTagValue.newId((String)"minecraft:gold_block", (double)0.3), IdTagValue.newId((String)"caverns_and_chasms:silver_block", (double)0.3), IdTagValue.newId((String)"caverns_and_chasms:sanguine_block", (double)0.25), IdTagValue.newId((String)"iguanatweaksexpanded:durium_block", (double)0.075), IdTagValue.newId((String)"minecraft:diamond_block", (double)0.05), IdTagValue.newId((String)"iguanatweaksexpanded:keego_block", (double)0.05), IdTagValue.newId((String)"iguanatweaksexpanded:quaron_block", (double)0.25), IdTagValue.newId((String)"iguanatweaksexpanded:soul_steel_block", (double)0.05), IdTagValue.newId((String)"minecraft:emerald_block", (double)0.35), IdTagValue.newId((String)"minecraft:netherite_block", (double)0.0), IdTagValue.newId((String)"caverns_and_chasms:necromium_block", (double)0.0));
    public static final ArrayList<IdTagValue> respawnObeliskCatalysts = new ArrayList();
    public static final List<ISOMobEffectInstance> RESPAWN_OBELISK_EFFECTS_DEFAULT = List.of(new ISOMobEffectInstance.Builder(MobEffects.f_19605_, 900).noParticles().build(), new ISOMobEffectInstance.Builder(MobEffects.f_19617_, 1200).setAmplifier(1).noParticles().build(), new ISOMobEffectInstance.Builder(MobEffects.f_19596_, 1200).noParticles().build(), new ISOMobEffectInstance.Builder(MobEffects.f_19618_, 400).noParticles().build());
    public static final ArrayList<ISOMobEffectInstance> respawnObeliskEffects = new ArrayList();

    public Respawn(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("respawn_obelisk_catalysts.json", respawnObeliskCatalysts, RESPAWN_OBELISK_CATALYSTS_DEFAULT, IdTagValue.LIST_TYPE));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("respawn_obelisk_effects.json", respawnObeliskEffects, RESPAWN_OBELISK_EFFECTS_DEFAULT, ISOMobEffectInstance.LIST_TYPE));
        InsaneSurvivalOverhaul.addServerPack("respawn_obelisk", "Insane's Survival Overhaul Respawn Obelisk", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && respawnObelisks != false);
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        MCUtils.getOrCreatePersistedData((Player)player).m_128405_(DEATHS, MCUtils.getOrCreatePersistedData((Player)player).m_128451_(DEATHS) + 1);
        MCUtils.getOrCreatePersistedData((Player)player).m_128405_(HUNGER_ON_DEATH_TAG, player.m_36324_().f_38696_);
        MCUtils.getOrCreatePersistedData((Player)player).m_128350_(SATURATION_ON_DEATH_TAG, player.m_36324_().f_38697_);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!this.isEnabled() || event.isEndConquered()) {
            return;
        }
        this.applyStatsPenalty(event.getEntity());
        this.tryRespawnObelisk(event);
    }

    public void applyStatsPenalty(Player player) {
        int hunger = MCUtils.getOrCreatePersistedData((Player)player).m_128451_(HUNGER_ON_DEATH_TAG);
        int maxHunger = (int)hungerOnRespawnMax.getByDifficulty(player.m_9236_());
        int minHunger = (int)hungerOnRespawnMin.getByDifficulty(player.m_9236_());
        player.m_36324_().f_38696_ = hunger = Mth.m_14045_((int)hunger, (int)minHunger, (int)maxHunger);
        float saturation = MCUtils.getOrCreatePersistedData((Player)player).m_128457_(SATURATION_ON_DEATH_TAG);
        float maxSaturation = (float)saturationOnRespawnMax.getByDifficulty(player.m_9236_());
        float minSaturation = (float)saturationOnRespawnMin.getByDifficulty(player.m_9236_());
        player.m_36324_().f_38697_ = saturation = Mth.m_14036_((float)saturation, (float)minSaturation, (float)maxSaturation);
        double healthOnRespawn = (double)player.m_21233_() - perDeathHealthOnRespawn.getByDifficulty(player.m_9236_()) * (double)MCUtils.getOrCreatePersistedData((Player)player).m_128451_(DEATHS);
        double minHealth = minHealthOnRespawn.getByDifficulty(player.m_9236_());
        player.m_21153_((float)Math.max(healthOnRespawn, minHealth));
    }

    public static Optional<Vec3> tryLooseRespawn(ServerLevel level, ServerPlayer player, Optional<Vec3> originalRespawn) {
        if (!level.m_46469_().m_46207_(RULE_RANGEDRESPAWN)) {
            return originalRespawn;
        }
        Optional<Vec3> newRespawn = Respawn.looseWorldSpawn(level, player);
        if (newRespawn.isEmpty()) {
            newRespawn = Respawn.looseBedSpawn(level, player);
        }
        return newRespawn.or(() -> originalRespawn);
    }

    private static Optional<Vec3> looseWorldSpawn(ServerLevel level, ServerPlayer player) {
        if (Respawn.looseWorldSpawnRange.min == 0.0 || player.m_5833_()) {
            return Optional.empty();
        }
        BlockPos pos = player.m_8961_();
        if (pos != null) {
            return Optional.empty();
        }
        BlockPos respawnPos = Respawn.getSpawnPositionInRange(level.m_220360_(), looseWorldSpawnRange, (Level)level, level.f_46441_);
        if (respawnPos == null) {
            return Optional.empty();
        }
        return Optional.of(new Vec3((double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_() + 0.5, (double)respawnPos.m_123343_() + 0.5));
    }

    private static Optional<Vec3> looseBedSpawn(ServerLevel level, ServerPlayer player) {
        if (Respawn.looseBedSpawnRange.min == 0.0 || player.m_5833_()) {
            return Optional.empty();
        }
        BlockPos pos = player.m_8961_();
        if (pos == null || !level.m_8055_(pos).m_204336_(BlockTags.f_13038_)) {
            return Optional.empty();
        }
        BlockPos respawnPos = Respawn.getSpawnPositionInRange(pos, looseBedSpawnRange, (Level)level, level.f_46441_);
        if (respawnPos == null) {
            return Optional.empty();
        }
        return Optional.of(new Vec3((double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_() + 0.5, (double)respawnPos.m_123343_() + 0.5));
    }

    @Nullable
    private static BlockPos getSpawnPositionInRange(BlockPos center, MinMax minMax, Level level, RandomSource random) {
        double minSqr = minMax.min * minMax.min;
        double maxSqr = minMax.max * minMax.max;
        BlockPos.MutableBlockPos respawn = new BlockPos.MutableBlockPos();
        boolean foundValidY = false;
        int triesLeft = 1024;
        while (true) {
            BlockState stateBelow;
            int z;
            int x;
            if ((double)((x = random.m_216339_((int)(-minMax.max), (int)minMax.max)) * x + (z = random.m_216339_((int)(-minMax.max), (int)minMax.max)) * z) > maxSqr || (double)(x * x + z * z) < minSqr) {
                continue;
            }
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, center.m_123341_() + x, center.m_123343_() + z);
            if (y < level.m_5736_() + 2) {
                y = level.m_5736_() + 2;
            }
            while (level.m_8055_((BlockPos)respawn.m_122178_(x + center.m_123341_(), y, z + center.m_123343_())).m_280555_()) {
                ++y;
            }
            do {
                respawn.m_122178_(x + center.m_123341_(), y, z + center.m_123343_());
                stateBelow = level.m_8055_(respawn.m_7495_());
                if (stateBelow.m_60819_().m_205070_(FluidTags.f_13132_)) break;
                if (!stateBelow.m_280555_() && stateBelow.m_60819_().m_76178_()) continue;
                foundValidY = true;
                break;
            } while (--y > level.m_141937_());
            if (dontRespawnOnFluid.booleanValue() && !stateBelow.m_60819_().m_76178_()) {
                foundValidY = false;
            }
            if (foundValidY || --triesLeft <= 0) break;
        }
        if (triesLeft <= 0) {
            LogHelper.warn((String)"Failed to find a respawn point within %s", (Object[])new Object[]{center});
            return null;
        }
        return respawn.m_7949_();
    }

    private void tryRespawnObelisk(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        BlockPos pos = player.m_8961_();
        if (pos == null || !player.m_9236_().m_8055_(pos).m_60713_((Block)RESPAWN_OBELISK.block().get())) {
            return;
        }
        if (!((Boolean)player.m_9236_().m_8055_(pos).m_61143_((Property)RespawnObeliskBlock.ENABLED)).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)FAIL_RESPAWN_OBELISK_LANG));
            RespawnObeliskBlock.trySetOldSpawn(player);
            return;
        }
        RespawnObeliskBlock.onObeliskRespawn((Player)player, player.m_9236_(), pos);
    }

    @SubscribeEvent
    public void onSetRespawn(PlayerSetSpawnEvent event) {
        if (!this.isEnabled() || event.isForced()) {
            return;
        }
        if (this.onSetSpawnPreventObeliskOverwrite(event)) {
            return;
        }
        this.onSetSpawnLooseMessage(event);
    }

    public void onSetSpawnLooseMessage(PlayerSetSpawnEvent event) {
        if (!event.getEntity().m_9236_().m_46469_().m_46207_(RULE_RANGEDRESPAWN) || Respawn.looseBedSpawnRange.min == 0.0 || event.getNewSpawn() == null || !event.getEntity().m_9236_().m_8055_(event.getNewSpawn()).m_204336_(BlockTags.f_13038_)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.getNewSpawn().equals((Object)player.m_8961_())) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)LOOSE_RESPAWN_POINT_SET), false);
    }

    public boolean onSetSpawnPreventObeliskOverwrite(PlayerSetSpawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_8961_() == null || !player.m_9236_().m_46472_().equals((Object)player.m_8963_()) || !player.m_9236_().m_8055_(player.m_8961_()).m_60713_((Block)RESPAWN_OBELISK.block().get()) || !((Boolean)player.m_9236_().m_8055_(player.m_8961_()).m_61143_((Property)RespawnObeliskBlock.ENABLED)).booleanValue() || event.getNewSpawn() == null || player.m_9236_().m_8055_(event.getNewSpawn()).m_60713_((Block)RESPAWN_OBELISK.block().get())) {
            return false;
        }
        if (allowObeliskSpawnPointOverwriteWithBedsSneaking.booleanValue()) {
            if (!event.getEntity().m_6047_()) {
                player.m_213846_((Component)Component.m_237115_((String)"iguanatweaksreborn.sneak_to_overwrite"));
            } else {
                return false;
            }
        }
        if (RespawnObeliskBlock.saveOldSpawn(player, event.getNewSpawn(), event.isForced(), 0.0f, (ResourceKey<Level>)event.getSpawnLevel())) {
            player.m_213846_((Component)Component.m_237115_((String)"iguanatweaksreborn.set_old_respawn"));
        }
        event.setCanceled(true);
        return true;
    }
}

