/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawn;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.DynamicOps;
import insane96mcp.iguanatweaksreborn.data.ISOMobEffectInstance;
import insane96mcp.iguanatweaksreborn.data.criterion.ISOTriggers;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawn.Respawn;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.MCUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RespawnObeliskBlock
extends Block {
    public static final String REQUIRES_CATALYST_LANG = "iguanatweaksreborn.requires_catalyst";
    public static final String OBELISK_DISABLED = "iguanatweaksreborn.obelisk_disabled";
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private static final ImmutableList<Vec3i> CATALYST_RELATIVE_POSITIONS = ImmutableList.of((Object)new Vec3i(-4, 0, 0), (Object)new Vec3i(4, 0, 0), (Object)new Vec3i(0, 0, -4), (Object)new Vec3i(0, 0, 4));
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(offset -> offset.m_6625_(3)).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(offset -> offset.m_6625_(2)).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::m_7495_).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::m_7494_).iterator()).build();

    public RespawnObeliskBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!((Boolean)state.m_61143_((Property)ENABLED)).booleanValue()) {
            if (RespawnObeliskBlock.hasCatalysts(level, pos)) {
                RespawnObeliskBlock.enable((Entity)player, level, pos, state);
            } else if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND) {
                player.m_5661_((Component)Component.m_237115_((String)REQUIRES_CATALYST_LANG), true);
                for (Vec3i catalystPos : CATALYST_RELATIVE_POSITIONS) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175828_, (double)pos.m_123341_() + 0.5 + (double)catalystPos.m_123341_(), (double)pos.m_123342_() + 0.5 + (double)catalystPos.m_123342_(), (double)pos.m_123343_() + 0.5 + (double)catalystPos.m_123343_(), 10, 0.2, 0.2, 0.2, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && !level.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!RespawnObeliskBlock.hasCatalysts(level, pos)) {
                RespawnObeliskBlock.disable((Entity)player, level, pos, state, true);
            } else if (serverPlayer.m_8963_() != level.m_46472_() || !pos.equals((Object)serverPlayer.m_8961_())) {
                RespawnObeliskBlock.trySaveOldSpawn(serverPlayer);
                serverPlayer.m_9158_(level.m_46472_(), pos, 0.0f, false, true);
                level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ISOTriggers.ACTIVATE_RESPAWN_OBELISK.trigger(serverPlayer);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55886_) {
        p_55886_.m_61104_(new Property[]{ENABLED});
    }

    public static void enable(@javax.annotation.Nullable Entity p_270997_, Level p_270172_, BlockPos p_270534_, BlockState p_270661_) {
        BlockState blockstate = (BlockState)p_270661_.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
        p_270172_.m_7731_(p_270534_, blockstate, 3);
        p_270172_.m_220407_(GameEvent.f_157792_, p_270534_, GameEvent.Context.m_223719_((Entity)p_270997_, (BlockState)blockstate));
        p_270172_.m_6263_(null, (double)p_270534_.m_123341_() + 0.5, (double)p_270534_.m_123342_() + 0.5, (double)p_270534_.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void disable(@javax.annotation.Nullable Entity entity, Level level, BlockPos pos, BlockState state, boolean showDisabledMessage) {
        ServerPlayer serverPlayer;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 3);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (showDisabledMessage) {
                player.m_5661_((Component)Component.m_237115_((String)OBELISK_DISABLED), false);
            }
        }
        if (entity instanceof ServerPlayer && !RespawnObeliskBlock.trySetOldSpawn(serverPlayer = (ServerPlayer)entity)) {
            serverPlayer.m_9158_(Level.f_46428_, null, 0.0f, false, false);
        }
    }

    public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader levelReader, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        if (!((Boolean)levelReader.m_8055_(pos).m_61143_((Property)ENABLED)).booleanValue()) {
            return Optional.empty();
        }
        if (state.m_60734_() instanceof RespawnObeliskBlock) {
            return RespawnObeliskBlock.findStandUpPosition(type, (CollisionGetter)levelReader, pos);
        }
        return Optional.empty();
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> pEntityType, CollisionGetter pLevel, BlockPos pPos) {
        Optional<Vec3> optional = RespawnObeliskBlock.findStandUpPosition(pEntityType, pLevel, pPos, true);
        return optional.isPresent() ? optional : RespawnObeliskBlock.findStandUpPosition(pEntityType, pLevel, pPos, false);
    }

    private static Optional<Vec3> findStandUpPosition(EntityType<?> pEntityType, CollisionGetter pLevel, BlockPos pPos, boolean pSimulate) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : RESPAWN_OFFSETS) {
            blockpos$mutableblockpos.m_122190_((Vec3i)pPos).m_122193_(vec3i);
            Vec3 vec3 = DismountHelper.m_38441_(pEntityType, (CollisionGetter)pLevel, (BlockPos)blockpos$mutableblockpos, (boolean)pSimulate);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    public static void onObeliskRespawn(Player player, Level level, BlockPos respawnPos) {
        BlockPos.MutableBlockPos relativePos = new BlockPos.MutableBlockPos();
        for (Vec3i rel : CATALYST_RELATIVE_POSITIONS) {
            relativePos.m_122190_((Vec3i)respawnPos).m_122193_(rel);
            if (!RespawnObeliskBlock.isBlockCatalyst(level.m_8055_((BlockPos)relativePos).m_60734_())) continue;
            double chance = RespawnObeliskBlock.getCatalystBlockChanceToBreak(level.m_8055_((BlockPos)relativePos).m_60734_());
            if (!(chance > 0.0) || !(level.m_213780_().m_188500_() < chance)) break;
            level.m_46961_((BlockPos)relativePos, false);
            break;
        }
        for (ISOMobEffectInstance ISOMobEffectInstance2 : Respawn.respawnObeliskEffects) {
            player.m_7292_(ISOMobEffectInstance2.getMobEffectInstance());
        }
        if (!RespawnObeliskBlock.hasCatalysts(level, respawnPos)) {
            RespawnObeliskBlock.disable((Entity)player, level, respawnPos, level.m_8055_(respawnPos), true);
        }
    }

    public static boolean hasCatalysts(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos relativePos = new BlockPos.MutableBlockPos();
        for (Vec3i rel : CATALYST_RELATIVE_POSITIONS) {
            relativePos.m_122190_((Vec3i)pos).m_122193_(rel);
            if (!RespawnObeliskBlock.isBlockCatalyst(level.m_8055_((BlockPos)relativePos).m_60734_())) continue;
            return true;
        }
        return false;
    }

    public boolean m_48673_(BlockState pState) {
        return true;
    }

    public static void trySaveOldSpawn(ServerPlayer player) {
        if (player.m_8961_() == null) {
            return;
        }
        RespawnObeliskBlock.saveOldSpawn(player, player.m_8961_(), player.m_8964_(), player.m_8962_(), (ResourceKey<Level>)player.m_8963_());
    }

    public static boolean saveOldSpawn(ServerPlayer player, BlockPos pos, boolean isForced, float angle, ResourceKey<Level> dimension) {
        CompoundTag tag = MCUtils.getOrCreatePersistedData((Player)player);
        if (tag.m_128451_("OldSpawnX") == pos.m_123341_() && tag.m_128451_("OldSpawnY") == pos.m_123342_() && tag.m_128451_("OldSpawnZ") == pos.m_123343_() && tag.m_128471_("OldSpawnForced") == isForced && tag.m_128457_("OldSpawnAngle") == angle && Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("OldSpawnDimension")).resultOrPartial(x$0 -> ISOLogHelper.error(x$0, new Object[0])).orElse(Level.f_46428_) == dimension) {
            return false;
        }
        tag.m_128405_("OldSpawnX", pos.m_123341_());
        tag.m_128405_("OldSpawnY", pos.m_123342_());
        tag.m_128405_("OldSpawnZ", pos.m_123343_());
        tag.m_128379_("OldSpawnForced", isForced);
        tag.m_128350_("OldSpawnAngle", angle);
        ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)dimension.m_135782_()).resultOrPartial(x$0 -> ISOLogHelper.error(x$0, new Object[0])).ifPresent(t -> tag.m_128365_("OldSpawnDimension", t));
        return true;
    }

    public static boolean trySetOldSpawn(ServerPlayer player) {
        CompoundTag tag = MCUtils.getOrCreatePersistedData((Player)player);
        if (!tag.m_128441_("OldSpawnX")) {
            return false;
        }
        player.m_9158_(Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("OldSpawnDimension")).resultOrPartial(x$0 -> ISOLogHelper.error(x$0, new Object[0])).orElse(Level.f_46428_), new BlockPos(tag.m_128451_("OldSpawnX"), tag.m_128451_("OldSpawnY"), tag.m_128451_("OldSpawnZ")), tag.m_128457_("OldSpawnAngle"), tag.m_128471_("OldSpawnForced"), false);
        tag.m_128473_("OldSpawnX");
        tag.m_128473_("OldSpawnY");
        tag.m_128473_("OldSpawnZ");
        tag.m_128473_("OldSpawnAngle");
        tag.m_128473_("OldSpawnForced");
        tag.m_128473_("OldSpawnDimension");
        return true;
    }

    public static int lightLevel(BlockState state) {
        return (Boolean)state.m_61143_((Property)ENABLED) != false ? 15 : 7;
    }

    public static boolean isBlockCatalyst(Block block) {
        return Respawn.respawnObeliskCatalysts.stream().anyMatch(idTagValue -> idTagValue.id.matchesBlock(block));
    }

    public static double getCatalystBlockChanceToBreak(Block block) {
        Optional<IdTagValue> catalyst = Respawn.respawnObeliskCatalysts.stream().filter(idTagValue -> idTagValue.id.matchesBlock(block)).findFirst();
        return catalyst.map(idTagValue -> idTagValue.value).orElse(0.0);
    }
}

