/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness.Tiredness;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.MCUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

@JsonAdapter(value=Serializer.class)
public class EnergyBoostItem {
    IdTagMatcher edible;
    public int duration;
    public int amplifier;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<EnergyBoostItem>>(){}.getType();

    public EnergyBoostItem(IdTagMatcher edible, int duration, int amplifier) {
        this.edible = edible;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public void tryApply(Player player, ItemStack stack) {
        int duration;
        if (!this.edible.matchesItem(stack.m_41720_())) {
            return;
        }
        MobEffectInstance mobEffectInstance = player.m_21124_((MobEffect)Tiredness.ENERGY_BOOST.get());
        if (mobEffectInstance == null) {
            duration = 0;
        } else {
            if (mobEffectInstance.m_267577_()) {
                return;
            }
            duration = mobEffectInstance.f_19503_;
        }
        if (this.duration == 0) {
            FoodProperties food = stack.getFoodProperties((LivingEntity)player);
            duration += (int)((double)(MCUtils.getFoodEffectiveness((FoodProperties)food) * 20.0f) * Tiredness.energyBoostDurationMultiplier);
        } else {
            duration += this.duration;
        }
        player.m_7292_(MCUtils.createEffectInstance((MobEffect)((MobEffect)Tiredness.ENERGY_BOOST.get()), (int)duration, (int)this.amplifier, (boolean)false, (boolean)false, (boolean)true, (boolean)false));
    }

    public static class Serializer
    implements JsonDeserializer<EnergyBoostItem>,
    JsonSerializer<EnergyBoostItem> {
        public EnergyBoostItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            IdTagMatcher edible = (IdTagMatcher)context.deserialize(json.getAsJsonObject().get("edible"), IdTagMatcher.class);
            return new EnergyBoostItem(edible, GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"duration", (int)0), GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"amplifier", (int)0));
        }

        public JsonElement serialize(EnergyBoostItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("edible", context.serialize((Object)src.edible));
            if (src.duration > 0) {
                jsonObject.addProperty("duration", (Number)src.duration);
            }
            if (src.amplifier > 0) {
                jsonObject.addProperty("amplifier", (Number)src.amplifier);
            }
            return jsonObject;
        }
    }
}

