/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.mixin.LivingEntityAccessor;
import insane96mcp.iguanatweaksreborn.mixin.MobAccessor;
import insane96mcp.iguanatweaksreborn.mixin.ServerLevelAccessor;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness.EnergyBoostItem;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness.TirednessEffect;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness.TirednessHandler;
import insane96mcp.iguanatweaksreborn.module.world.weather.Weather;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.event.PlayerExhaustionEvent;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.world.effect.ILMobEffect;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerSpawnPhantomsEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Tiredness", description="Prevents sleeping if the player is not tired. Tiredness is gained by gaining exhaustion. Allows you to sleep during daytime if too tired. Energy Boost Items are controlled via json in this feature's folder")
@LoadFeature(module="iguanatweaksreborn:sleep_respawn")
public class Tiredness
extends JsonFeature {
    public static final RegistryObject<MobEffect> TIRED = ISORegistries.MOB_EFFECTS.register("tired", () -> new TirednessEffect(MobEffectCategory.HARMFUL, 8489108).m_19472_(Attributes.f_22279_, "697c48dd-6bbd-4082-8501-040bb9812c09", -0.04f, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22283_, "40c789ef-d30d-4a27-8f46-13fe0edbb259", (double)-0.04f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> ENERGY_BOOST = ISORegistries.MOB_EFFECTS.register("energy_boost", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8747365, true));
    public static final String NOT_TIRED = "iguanatweaksreborn.not_tired";
    public static final String TIRED_ENOUGH = "iguanatweaksreborn.tired_enough";
    public static final String TOO_TIRED = "iguanatweaksreborn.too_tired";
    public static final TagKey<Item> ENERGY_BOOST_ITEM_TAG = ISOItemTagsProvider.create("energy_boost");
    public static final List<EnergyBoostItem> ENERGY_BOOST_ITEMS_DEFAULT = new ArrayList<EnergyBoostItem>(List.of(new EnergyBoostItem(IdTagMatcher.newTag((String)"iguanatweaksreborn:energy_boost"), 0, 0), new EnergyBoostItem(IdTagMatcher.newTag((String)"atmospheric:orange_pudding"), 0, 0), new EnergyBoostItem(IdTagMatcher.newId((String)"farmersdelight:hot_cocoa"), 80, 0)));
    public static final List<EnergyBoostItem> energyBoostItems = new ArrayList<EnergyBoostItem>();
    @Config(min=0.0, max=128.0)
    @Label(name="Tiredness gained multiplier", description="Multiply the tiredness gained by this value. Normally you gain tiredness equal to the exhaustion gained. 'Effective Hunger' doesn't affect the exhaustion gained.")
    public static Double tirednessGainMultiplier = 1.0;
    @Config
    @Label(name="Prevent Spawn Point", description="If true the player will not set the spawn point if can't sleep.")
    public static Boolean shouldPreventSpawnPoint = false;
    @Config(min=0.0)
    @Label(name="Tiredness for effect", description="Tiredness required to get the Tired effect and be able to sleep.")
    public static Double tirednessToEffect = 400.0;
    @Config(min=0.0)
    @Label(name="Tiredness per level", description="Every this Tiredness above 'Tiredness for effect' will add a new level of Tired.")
    public static Double tirednessPerLevel = 250.0;
    @Config(min=0.0)
    @Label(name="Energy boost.Tiredness reduction", description="If the player has energy boost, reduce tiredness by this value (multiplied by the effect level) each tick.")
    public static Double energyBoostTirednessReduction = 0.025;
    @Config(min=0.0)
    @Label(name="Energy boost.Duration multiplier", description="By default if omitted in the json, food items will give 1 second of Energy Boost per effectiveness (hunger + saturation) of the food. This multiplies the duration of the effect")
    public static Double energyBoostDurationMultiplier = 5.0;
    @Config
    @Label(name="On death behaviour", description="What to do with tiredness when the player dies.\nRESET resets the tiredness to 0\nKEEP keeps the current tiredness\nSET_AT_EFFECT keeps the current tiredness but if higher than 'Tiredness for effect' it's set to that\nREMOVE_ONE_LEVEL keeps the current tiredness but if higher than 'Tiredness for effect' removes one level of Tired to a minimum of I")
    public static OnDeath onDeathBehaviour = OnDeath.SET_AT_EFFECT;
    @Config
    @Label(name="Fake sound.Mobs", description="List of mobs (and optional dimension where they should play) that will have their ambience sound played when the player is tired")
    public static List<String> fakeSoundMobsConfig = List.of("minecraft:skeleton,minecraft:overworld", "minecraft:zombie,minecraft:overworld", "minecraft:spider,minecraft:overworld", "minecraft:ghast,minecraft:the_nether", "minecraft:zombified_piglin,minecraft:the_nether");
    public static List<IdTagMatcher> fakeSoundMobs = new ArrayList<IdTagMatcher>();
    @Config(min=0.0)
    @Label(name="Fake sound.Cooldown", description="The cooldown (in ticks) between choosing a mob to play the fake sound. This is reduced with higher Tired effect levels")
    public static MinMax fakeSoundCooldownBetweenMobs = new MinMax(12000.0, 24000.0);
    @Config(min=0.0)
    @Label(name="Fake sound.Times", description="How many times will a fake sound of a mob play before going into cooldown")
    public static MinMax fakeSoundTimes = new MinMax(2.0, 6.0);
    @Config
    @Label(description="Phantoms will no longer spawn based on insomnia, but instead based off tiredness. Will spawn with Tired III.")
    public static Boolean tiredPhantoms = true;
    private static long fakeSoundCooldown = 1200L;
    private static long fakeSoundTimesToPlay = 0L;
    private static long ambientSoundTime = 0L;
    private static Mob mobFakeSound;
    private static BlockPos fakeMobPos;
    static int timeSkipped;

    public Tiredness(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("energy_boost_items.json", energyBoostItems, ENERGY_BOOST_ITEMS_DEFAULT, EnergyBoostItem.LIST_TYPE));
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        fakeSoundMobs = fakeSoundMobsConfig.stream().map(IdTagMatcher::parseLine).collect(Collectors.toList());
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.player.m_9236_().f_46443_ || event.phase == TickEvent.Phase.START) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        this.tickEnergyBoostEffect(serverPlayer);
    }

    @SubscribeEvent
    public void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || fakeSoundMobs.isEmpty() || !event.player.m_9236_().f_46443_ || event.phase == TickEvent.Phase.START || !event.player.m_21023_((MobEffect)TIRED.get())) {
            return;
        }
        if (--fakeSoundCooldown > 0L) {
            return;
        }
        RandomSource random = event.player.m_217043_();
        int amplifier = event.player.m_21124_((MobEffect)TIRED.get()).m_19564_() + 1;
        if (mobFakeSound == null) {
            List<IdTagMatcher> idTagMatchers = fakeSoundMobs.stream().filter(idTagMatcher1 -> idTagMatcher1.matchesDimension(event.player.m_9236_().m_46472_().m_135782_())).toList();
            if (idTagMatchers.isEmpty()) {
                this.resetMobFakeSound(random, amplifier);
                return;
            }
            IdTagMatcher idTagMatcher = idTagMatchers.get(random.m_188503_(idTagMatchers.size()));
            if (idTagMatcher.getAllEntityTypes().isEmpty()) {
                this.resetMobFakeSound(random, amplifier);
                return;
            }
            Entity entity = ((EntityType)idTagMatcher.getAllEntityTypes().get(0)).m_20615_(event.player.m_9236_());
            if (!(entity instanceof Mob)) {
                LogHelper.warn((String)"Can't play fake sound, %s is not an instance of Mob", (Object[])new Object[]{entity});
                this.resetMobFakeSound(random, amplifier);
                return;
            }
            mobFakeSound = (Mob)entity;
            fakeSoundTimesToPlay = (int)random.m_216328_(Tiredness.fakeSoundTimes.min, Tiredness.fakeSoundTimes.max + 1.0);
            fakeMobPos = event.player.m_20183_();
        }
        if (mobFakeSound != null && (long)random.m_188503_(1000) < ambientSoundTime++) {
            SoundEvent soundEvent = ((MobAccessor)mobFakeSound).ambientSound();
            event.player.m_9236_().m_6263_(event.player, (double)fakeMobPos.m_123341_() + Tiredness.getRandomRange(random), (double)fakeMobPos.m_123342_() + Tiredness.getRandomRange(random), (double)fakeMobPos.m_123343_() + Tiredness.getRandomRange(random), soundEvent, mobFakeSound.m_5720_(), ((LivingEntityAccessor)mobFakeSound).soundVolume(), ((LivingEntityAccessor)mobFakeSound).voicePitch());
            ambientSoundTime = -mobFakeSound.m_8100_();
            if (--fakeSoundTimesToPlay <= 0L) {
                this.resetMobFakeSound(random, amplifier);
            }
        }
    }

    private static double getRandomRange(RandomSource random) {
        double randomRange = (double)random.m_188501_() * 24.0 - 12.0;
        if (randomRange > -6.0 && randomRange < 0.0) {
            randomRange = -6.0;
        } else if (randomRange >= 0.0 && randomRange < 6.0) {
            randomRange = 0.0;
        }
        return randomRange;
    }

    private void resetMobFakeSound(RandomSource random, int reduction) {
        fakeSoundTimesToPlay = 0L;
        fakeSoundCooldown = (long)((float)fakeSoundCooldownBetweenMobs.getIntRandBetween(random) * (1.0f - 0.15f * (float)reduction));
        mobFakeSound = null;
    }

    private void tickEnergyBoostEffect(ServerPlayer player) {
        if (!player.m_21023_((MobEffect)ENERGY_BOOST.get())) {
            return;
        }
        int effectLevel = player.m_21124_((MobEffect)ENERGY_BOOST.get()).m_19564_() + 1;
        TirednessHandler.subtract((LivingEntity)player, energyBoostTirednessReduction.floatValue() * (float)effectLevel);
        if (player.f_19797_ % 20 == 0) {
            TirednessHandler.syncToClient(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFoodExhaustion(PlayerExhaustionEvent event) {
        if (!Tiredness.isEnabled(Tiredness.class) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
        if (!serverPlayer.f_8941_.m_9294_()) {
            return;
        }
        float tiredness = TirednessHandler.get((LivingEntity)serverPlayer);
        TirednessHandler.add((LivingEntity)serverPlayer, event.getAmount() * tirednessGainMultiplier.floatValue());
        Tiredness.tryApplyTired(tiredness, serverPlayer);
        TirednessHandler.syncToClient(serverPlayer);
    }

    private static void tryApplyTired(float tiredness, ServerPlayer player) {
        int wantedAmplifier = -1;
        if ((double)tiredness >= tirednessToEffect) {
            wantedAmplifier = (int)Math.min(Math.round(((double)tiredness - tirednessToEffect) / tirednessPerLevel), 2L);
        }
        if (wantedAmplifier >= 0) {
            int currAmplifier = -1;
            if (player.m_21023_((MobEffect)TIRED.get())) {
                currAmplifier = player.m_21124_((MobEffect)TIRED.get()).m_19564_();
            }
            if (wantedAmplifier != currAmplifier) {
                player.m_7292_(new MobEffectInstance((MobEffect)TIRED.get(), -1, wantedAmplifier, true, false, true));
                if (wantedAmplifier == 0) {
                    player.m_5661_((Component)Component.m_237115_((String)TIRED_ENOUGH), false);
                } else if (wantedAmplifier == 4) {
                    player.m_5661_((Component)Component.m_237115_((String)TOO_TIRED), false);
                }
            }
        } else if (!player.m_21023_((MobEffect)ENERGY_BOOST.get()) && player.m_21023_((MobEffect)TIRED.get())) {
            player.m_21195_((MobEffect)TIRED.get());
        }
    }

    @SubscribeEvent
    public void onItemFinishUse(LivingEntityUseItemEvent.Finish event) {
        Object object;
        if (!this.isEnabled() || event.getItem().m_41720_().m_41473_() == null || !((object = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        for (EnergyBoostItem energyBoostItem : energyBoostItems) {
            energyBoostItem.tryApply(player, event.getItem());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTiredBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || !event.getEntity().m_21023_((MobEffect)TIRED.get())) {
            return;
        }
        int level = event.getEntity().m_21124_((MobEffect)TIRED.get()).m_19564_() + 1;
        event.setNewSpeed(event.getNewSpeed() * (1.0f - (float)level * 0.04f));
    }

    @SubscribeEvent
    public void notTiredToSleep(PlayerSleepInBedEvent event) {
        if (!this.isEnabled() || event.getResultStatus() != null || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (!player.m_21023_((MobEffect)TIRED.get()) && !player.m_150110_().f_35937_) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.m_5661_((Component)Component.m_237115_((String)NOT_TIRED), true);
            if (!shouldPreventSpawnPoint.booleanValue()) {
                player.m_9158_(player.m_9236_().m_46472_(), event.getPos(), player.m_146908_(), false, true);
            }
        } else {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.m_5802_(event.getPos());
            ((ServerLevel)player.m_9236_()).m_8878_();
            if (!shouldPreventSpawnPoint.booleanValue()) {
                player.m_9158_(player.m_9236_().m_46472_(), event.getPos(), player.m_146908_(), false, true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void resetTirednessOnWakeUp(SleepFinishedTimeEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        AtomicInteger highestTired = new AtomicInteger();
        event.getLevel().m_6907_().stream().filter(LivingEntity::m_5803_).filter(player -> player.m_21023_((MobEffect)TIRED.get())).toList().forEach(player -> {
            float tirednessOnWakeUp = TirednessHandler.getOnWakeUp((LivingEntity)player);
            if (player.m_21124_((MobEffect)TIRED.get()).m_19564_() > highestTired.get()) {
                highestTired.set(player.m_21124_((MobEffect)TIRED.get()).m_19564_());
            }
            TirednessHandler.set((LivingEntity)player, tirednessOnWakeUp);
            player.m_21195_((MobEffect)TIRED.get());
        });
        Tiredness.skipTime(event, highestTired.get());
    }

    private static void skipTime(SleepFinishedTimeEvent event, int highestTiredAmplifier) {
        timeSkipped = 12000;
        event.setTimeAddition(event.getLevel().m_8044_() + (long)(timeSkipped += 3000 * highestTiredAmplifier));
        Weather.onSkipNight(timeSkipped, (ServerLevel)event.getLevel());
    }

    public static boolean onSleepFinished(ServerLevel level, boolean original) {
        if (!Feature.isEnabled(Tiredness.class)) {
            return original;
        }
        int rainTime = ((ServerLevelAccessor)level).getServerLevelData().m_6531_();
        int thunderTime = ((ServerLevelAccessor)level).getServerLevelData().m_6558_();
        int clearWeatherTime = ((ServerLevelAccessor)level).getServerLevelData().m_6537_();
        if (rainTime > 0) {
            ((ServerLevelAccessor)level).getServerLevelData().m_6399_(Math.max(rainTime -= timeSkipped, 0));
            if (rainTime <= 0) {
                ((ServerLevelAccessor)level).getServerLevelData().m_5565_(false);
            }
        }
        if (thunderTime > 0) {
            ((ServerLevelAccessor)level).getServerLevelData().m_6398_(Math.max(thunderTime -= timeSkipped, 0));
            if (thunderTime <= 0) {
                ((ServerLevelAccessor)level).getServerLevelData().m_5557_(false);
            }
        }
        if (clearWeatherTime > 0) {
            ((ServerLevelAccessor)level).getServerLevelData().m_6393_(Math.max(clearWeatherTime -= timeSkipped, 0));
        }
        return false;
    }

    @SubscribeEvent
    public void allowSleepAtDay(SleepingTimeCheckEvent event) {
        if (!Tiredness.canSleepDuringDay(event.getEntity())) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
    }

    public static boolean canSleepDuringDay(Player player) {
        return Tiredness.isEnabled(Tiredness.class) && player.m_21023_((MobEffect)TIRED.get());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        ((GameRules.IntegerValue)event.getServer().m_129900_().m_46170_(GameRules.f_151486_)).m_151489_(1, event.getServer());
    }

    @SubscribeEvent
    public void onPhantomTryToSpawn(PlayerSpawnPhantomsEvent event) {
        if (!this.isEnabled() || !tiredPhantoms.booleanValue()) {
            return;
        }
        if (event.getEntity().m_21124_((MobEffect)TIRED.get()) == null) {
            event.setResult(Event.Result.DENY);
            return;
        }
        Level level = event.getEntity().m_9236_();
        int amplifier = event.getEntity().m_21124_((MobEffect)TIRED.get()).m_19564_();
        if (amplifier < 2 || !level.m_6042_().f_223549_() || !level.m_45527_(event.getEntity().m_20183_())) {
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setResult(Event.Result.ALLOW);
        event.setPhantomsToSpawn(event.getPhantomsToSpawn());
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.Clone event) {
        if (!this.isEnabled() || !event.isWasDeath()) {
            return;
        }
        float tiredness = TirednessHandler.get((LivingEntity)event.getOriginal());
        switch (onDeathBehaviour) {
            case RESET: {
                tiredness = 0.0f;
                break;
            }
            case KEEP: {
                break;
            }
            case SET_AT_EFFECT: {
                if (!(tiredness > tirednessToEffect.floatValue() + tirednessPerLevel.floatValue())) break;
                tiredness = tirednessToEffect.floatValue() + tirednessPerLevel.floatValue();
                break;
            }
            case REMOVE_ONE_LEVEL: {
                if (!((double)tiredness > tirednessToEffect) || !((double)(tiredness = (float)((double)tiredness - tirednessPerLevel)) < tirednessToEffect)) break;
                tiredness = tirednessToEffect.floatValue();
            }
        }
        TirednessHandler.set((LivingEntity)event.getEntity(), tiredness);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void debugScreen(CustomizeGuiOverlayEvent.DebugText event) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer playerEntity = mc.f_91074_;
        if (playerEntity == null) {
            return;
        }
        if (mc.f_91066_.f_92063_ && !mc.m_91299_()) {
            event.getLeft().add(String.format("Tiredness: %s", new DecimalFormat("#.#").format(TirednessHandler.get((LivingEntity)playerEntity))));
        }
    }

    public static enum OnDeath {
        RESET,
        KEEP,
        SET_AT_EFFECT,
        REMOVE_ONE_LEVEL;

    }
}

