/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.mutable.MutableInt;

@Label(name="Nether")
@LoadFeature(module="iguanatweaksreborn:world")
public class Nether
extends Feature {
    public static final String REQUIRES_CORNERS_LANG = "iguanatweaksreborn.requires_corners";
    public static final TagKey<Block> PORTAL_CORNERS = ISOBlockTagsProvider.create("portal_corners");
    @Config
    @Label(name="Disable Nether Roof and reduce block ratio", description="Enables a data pack that makes the nether 128 blocks high instead of 256, effectively disabling the \"Nether Roof\" and reduces the 8 block ratio between nether and other dimensions to 4.")
    public static Boolean netherTweaks = true;
    @Config
    @Label(name="Remove Lava Pockets", description="If true, lava pockets in the nether are removed. If quark is installed, this is disabled")
    public static Boolean removeLavaPockets = true;
    @Config
    @Label(name="Disable Nether", description="If true you cannot lit nether portals")
    public static Boolean disableNether = false;
    @Config
    @Label(name="Portal wait time", description="How much time inside the portal to pass it. Vanilla is 80 ticks")
    public static Integer portalWaitTime = 50;
    @Config
    @Label(name="Portal requires Crying Obsidian", description="The portal requires Crying Obsidian in the corners to turn it on (in the overworld). The block tag 'iguanatweaksreborn:portal_corners' can be used to change the required blocks for the corners")
    public static Boolean portalRequiresCryingObsidian = true;

    public Nether(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("nether_tweaks", "Insane's Survival Overhaul Nether Tweaks", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && netherTweaks != false);
    }

    public static boolean shouldDisableLavaPockets(SpringConfiguration configuration) {
        return !ModList.get().isLoaded("quark") && Nether.isEnabled(Nether.class) && removeLavaPockets != false && !configuration.f_68125_ && configuration.f_68124_.m_205070_(FluidTags.f_13132_);
    }

    @SubscribeEvent
    public void onPortalTryToActivate(BlockEvent.PortalSpawnEvent event) {
        if (!this.isEnabled() || event.getPortalSize().f_77690_ == null) {
            return;
        }
        AABB aabb = AABB.m_165882_((Vec3)event.getPos().m_252807_(), (double)8.0, (double)8.0, (double)8.0);
        if (disableNether.booleanValue()) {
            Level level = (Level)event.getLevel();
            for (Player player : level.m_6907_()) {
                if (!aabb.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                player.m_213846_((Component)Component.m_237115_((String)"no_nether"));
            }
            event.setCanceled(true);
        } else if (portalRequiresCryingObsidian.booleanValue()) {
            Level level = (Level)event.getLevel();
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            MutableInt cryingObsidians = new MutableInt();
            BlockPos.m_121940_((BlockPos)event.getPortalSize().f_77690_.m_7495_().m_5484_(event.getPortalSize().f_77688_.m_122424_(), 1), (BlockPos)event.getPortalSize().f_77690_.m_5484_(Direction.UP, event.getPortalSize().f_77691_).m_5484_(event.getPortalSize().f_77688_, event.getPortalSize().f_77692_)).forEach(pos -> {
                if (level.m_8055_(pos).m_204336_(PORTAL_CORNERS)) {
                    cryingObsidians.increment();
                }
            });
            if (cryingObsidians.getValue() < 4) {
                for (Player player : level.m_6907_()) {
                    if (!aabb.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                    player.m_213846_((Component)Component.m_237115_((String)REQUIRES_CORNERS_LANG));
                }
                event.setCanceled(true);
            }
        }
    }
}

